/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.forms;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.ValidationMessage;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.module.forms.Form;
import de.virtimo.bpc.module.forms.FormValidator;
import de.virtimo.bpc.module.forms.InvalidFormConfigException;
import de.virtimo.bpc.module.forms.Manager;
import de.virtimo.bpc.module.forms.NoFormFoundException;
import de.virtimo.bpc.module.forms.SimpleForm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class ElasticsearchManagerImpl
implements Manager {
    private static final Logger LOG = Logger.getLogger(ElasticsearchManagerImpl.class.getName());
    static final String FORMS_INDEX = "bpc-forms";
    static final String FORM_ID_FIELD = "id";
    static final String FORM_VERSION_FIELD = "version";
    static final int LATEST_VERSION = -1;
    private ElasticsearchService elasticsearchService;
    private FormValidator formValidator;
    private static final ObjectMapper mapper = new ObjectMapper();

    public ElasticsearchManagerImpl(ElasticsearchService elasticsearchService) {
        this(elasticsearchService, FormValidator.getDefaultInstance());
    }

    public ElasticsearchManagerImpl(ElasticsearchService elasticsearchService, FormValidator formValidator) {
        this.elasticsearchService = elasticsearchService;
        this.formValidator = formValidator;
    }

    @Override
    public Form getForm(String formId) throws NoFormFoundException {
        return this.getForm(formId, -1);
    }

    @Override
    public Form getForm(String formId, int version) throws NoFormFoundException {
        if (version <= 0) {
            version = this.getLastFormVersion(formId);
        }
        GetRequest getRequest = new GetRequest(FORMS_INDEX, this.getElasticsearchFormId(formId, version));
        try {
            GetResponse getResponse = this.elasticsearchService.getClient().get(getRequest, RequestOptions.DEFAULT);
            if (getResponse.isExists()) {
                return ElasticsearchManagerImpl.getFormFromMap(getResponse.getSourceAsMap());
            }
            throw new NoFormFoundException("no form with id " + formId + " and version " + version + " found");
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            throw new UnknownError(e.getMessage());
        }
    }

    @Override
    public Set<Form> getForms() {
        LOG.finest("getForms");
        SearchRequest searchRequest = this.getFormsSearchLatestVersion(null);
        return this.getFormsFromSearchRequest(searchRequest);
    }

    @Override
    public Set<Form> getFormHistory(String formID) {
        LOG.finest("getFormHistory");
        SearchRequest searchRequest = this.getFormsSearch((QueryBuilder)QueryBuilders.termQuery((String)FORM_ID_FIELD, (String)formID));
        return this.getFormsFromSearchRequest(searchRequest);
    }

    @Override
    public Form addForm(String formId, String formName, Map<String, Object> formConfig) throws InvalidFormConfigException {
        return this.addForm(formId, formName, formConfig, true);
    }

    public Form addForm(String formId, String formName, Map<String, Object> formConfig, Boolean waitUntilVisible) throws InvalidFormConfigException {
        LOG.finest("addForm");
        if (waitUntilVisible == null) {
            waitUntilVisible = false;
        }
        int nextVersion = 1;
        try {
            nextVersion = this.getLastFormVersion(formId) + 1;
            LOG.finest("add new version " + nextVersion + " to form " + formId);
        }
        catch (NoFormFoundException e) {
            LOG.finest("create new form " + formId);
        }
        SimpleForm form = new SimpleForm(formId, nextVersion, formName, formConfig);
        Set<ValidationMessage> validationMessages = this.formValidator.validate(form);
        if (validationMessages.size() > 0) {
            InvalidFormConfigException invalidFormConfigException = new InvalidFormConfigException(validationMessages);
            LOG.warning("addForm canceled. formConfig Validation failed:\n" + invalidFormConfigException.getMessage());
            throw invalidFormConfigException;
        }
        IndexRequest indexRequest = new IndexRequest(FORMS_INDEX).id(this.getElasticsearchFormId(form)).source(ElasticsearchManagerImpl.getMapFromForm(form));
        if (waitUntilVisible.booleanValue()) {
            indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
        }
        LOG.finest("addForm Request: " + indexRequest.toString());
        try {
            this.elasticsearchService.getClient().index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        return form;
    }

    static Form getFormFromMap(Map<String, Object> formMap) {
        return (Form)mapper.convertValue(formMap, SimpleForm.class);
    }

    static Map<String, Object> getMapFromForm(Form form) {
        return (Map)mapper.convertValue((Object)form, Map.class);
    }

    private String getElasticsearchFormId(Form form) {
        return this.getElasticsearchFormId(form.getId(), form.getVersion());
    }

    private String getElasticsearchFormId(String formId, int version) {
        return formId + "-" + version;
    }

    private SearchRequest getFormsSearch(QueryBuilder queryBuilder) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(100).sort(FORM_ID_FIELD, SortOrder.DESC).sort(FORM_VERSION_FIELD, SortOrder.DESC);
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        return new SearchRequest().indices(new String[]{FORMS_INDEX}).source(searchSourceBuilder).scroll(new TimeValue(60000L));
    }

    private SearchRequest getFormsSearchLatestVersion(QueryBuilder queryBuilder) {
        ArrayList<CompositeValuesSourceBuilder> sources = new ArrayList<CompositeValuesSourceBuilder>();
        sources.add(new TermsValuesSourceBuilder("form").field(FORM_ID_FIELD));
        CompositeAggregationBuilder compositeAggregationBuilder = (CompositeAggregationBuilder)new CompositeAggregationBuilder("forms", sources).size(10000).subAggregation((AggregationBuilder)new TopHitsAggregationBuilder("latestVersion").sort(FORM_VERSION_FIELD, SortOrder.DESC).size(1));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).aggregation((AggregationBuilder)compositeAggregationBuilder);
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        return new SearchRequest().indices(new String[]{FORMS_INDEX}).source(searchSourceBuilder);
    }

    private Set<Form> getFormsFromSearchRequest(SearchRequest searchRequest) {
        LinkedHashSet<Form> formSet = new LinkedHashSet<Form>();
        try {
            SearchResponse searchResponse = this.elasticsearchService.getClient().search(searchRequest, RequestOptions.DEFAULT);
            LOG.info("Number of settings read from Elasticsearch: " + searchResponse.getHits().getTotalHits().value);
            if (searchResponse.getHits().getTotalHits().value > 0L) {
                do {
                    for (SearchHit hit : searchResponse.getHits().getHits()) {
                        formSet.add(ElasticsearchManagerImpl.getFormFromMap(hit.getSourceAsMap()));
                    }
                    if (searchResponse.getScrollId() == null) continue;
                    searchResponse = this.elasticsearchService.getClient().scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT);
                } while (searchResponse.getHits().getHits().length != 0);
            }
            if (searchResponse.getAggregations() != null && searchResponse.getAggregations().get("forms") != null) {
                CompositeAggregation forms = (CompositeAggregation)searchResponse.getAggregations().get("forms");
                for (CompositeAggregation.Bucket formBucket : forms.getBuckets()) {
                    if (formBucket.getAggregations() == null || formBucket.getAggregations().get("latestVersion") == null) continue;
                    TopHits latestVersions = (TopHits)formBucket.getAggregations().get("latestVersion");
                    for (SearchHit hit : latestVersions.getHits().getHits()) {
                        formSet.add(ElasticsearchManagerImpl.getFormFromMap(hit.getSourceAsMap()));
                    }
                }
            }
            if (searchResponse.getScrollId() != null) {
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(searchResponse.getScrollId());
                this.elasticsearchService.getClient().clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        return formSet;
    }

    private int getLastFormVersion(String formId) throws NoFormFoundException {
        Set<Form> formHistory = this.getFormHistory(formId);
        if (formHistory.isEmpty()) {
            throw new NoFormFoundException("No form found with id " + formId);
        }
        return formHistory.iterator().next().getVersion();
    }
}

