/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.forms;

import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.module.forms.ElasticsearchManagerImpl;
import de.virtimo.bpc.module.forms.Manager;
import de.virtimo.bpc.module.forms.ModuleInstance;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class Module
extends AbstractInstantiableModule {
    private static final Logger LOG = Logger.getLogger(Module.class.getName());
    private BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private BpcServicesTracker<BackupManager> backupManagerServiceTracker;
    private static Module instance;
    private static final String INDEX_BACKUP_ID = "forms:forms";
    private Manager manager;

    public Module(ModuleManager moduleManager) {
        super(moduleManager);
        instance = this;
    }

    public static Module getInstance() {
        return instance;
    }

    public Manager getManager() {
        return this.manager;
    }

    public ModuleConfiguration getDefaultConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/default_module_settings.json").build();
    }

    public ModuleConfiguration getDefaultInstanceConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).withInstanceId(null).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/default_instance_settings.json").build();
    }

    public void setModuleBundle(Bundle moduleBundle) {
        super.setModuleBundle(moduleBundle);
        BpcServicesTracker.stopAll((Object)((Object)this));
        this.elasticsearchServiceTracker = new BpcServicesTracker(moduleBundle.getBundleContext(), ElasticsearchService.class);
        this.elasticsearchServiceTracker.start();
        try {
            ElasticsearchService es = (ElasticsearchService)this.elasticsearchServiceTracker.getService();
            Map managedIndicesConfigMap = JsonDefaultsUtil.loadJsonFileAsMap((Bundle)moduleBundle, (String)"managed_indices.json");
            es.prepareManagedIndices(managedIndicesConfigMap);
            this.manager = new ElasticsearchManagerImpl(es);
        }
        catch (ServiceNotFoundException e) {
            LOG.log(Level.SEVERE, "ElasticsearchService not found", e);
        }
        catch (ElasticsearchRelatedException e) {
            LOG.log(Level.SEVERE, "Problem with ElasticsearchService", e);
        }
        this.backupManagerServiceTracker = new BpcServicesTracker(moduleBundle.getBundleContext(), BackupManager.class);
        this.backupManagerServiceTracker.start();
        try {
            BackupManager backupManager = (BackupManager)this.backupManagerServiceTracker.getService();
            backupManager.scheduleBackupJobWithSettings(INDEX_BACKUP_ID, new BackupSetting(true, 86400L, 2592000L, new String[]{"bpc-forms"}));
        }
        catch (ServiceNotFoundException e) {
            LOG.log(Level.SEVERE, "BackupManager not found", e);
        }
    }

    public String getModuleId() {
        return "forms";
    }

    public String getModuleName() {
        return "Forms";
    }

    public Class<? extends de.virtimo.bpc.api.ModuleInstance> getModuleInstanceClass() {
        return ModuleInstance.class;
    }

    public void destroy() {
        try {
            BackupManager backupManager = (BackupManager)this.backupManagerServiceTracker.getService();
            backupManager.stopBackupJob(INDEX_BACKUP_ID);
        }
        catch (ServiceNotFoundException e) {
            LOG.log(Level.SEVERE, "BackupManager not found", e);
        }
        BpcServicesTracker.stopAll((Object)((Object)this));
        instance = null;
        super.destroy();
    }
}

