/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor;

import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.util.StringUtil;
import java.util.Map;
import java.util.logging.Logger;
import org.elasticsearch.client.RestHighLevelClient;

public class Elasticsearch {
    private static final Logger LOG = Logger.getLogger(Elasticsearch.class.getName());
    private ElasticsearchService elasticsearchService;

    public Elasticsearch(ElasticsearchService elasticsearchService) {
        LOG.info("Elasticsearch");
        this.elasticsearchService = elasticsearchService;
    }

    public RestHighLevelClient getClient() {
        LOG.info("getClient");
        return this.elasticsearchService.getClient();
    }

    public ElasticsearchService getElasticsearchService() {
        LOG.info("getElasticsearchService");
        return this.elasticsearchService;
    }

    public Map getIndexMapping(String esIndex) {
        LOG.info("getIndexMapping esIndex=" + esIndex);
        if (!StringUtil.isNullOrEmpty((String)esIndex)) {
            try {
                Map columnMap;
                Object mappingPropertiesObject;
                if (this.elasticsearchService.existsIndex(esIndex) && (mappingPropertiesObject = (columnMap = this.elasticsearchService.getMapping(esIndex)).get("properties")) instanceof Map) {
                    Map m = (Map)mappingPropertiesObject;
                    m.remove("_percolator_query");
                    return m;
                }
            }
            catch (Exception ex) {
                LOG.warning("Failed to get the mapping of the index: " + esIndex);
            }
        }
        return null;
    }
}

