/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.AbstractMaintenanceModeAcknowledgeEventHandler;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.CollaborationService;
import de.virtimo.bpc.api.service.CoreBundleService;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.module.monitor.Elasticsearch;
import de.virtimo.bpc.module.monitor.MonitorModuleInstance;
import de.virtimo.bpc.module.monitor.MonitorModuleInstanceSettingValidator;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.HttpHeaders;
import org.apache.http.HttpEntity;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.tasks.CancelTasksRequest;
import org.elasticsearch.client.tasks.CancelTasksResponse;
import org.elasticsearch.client.tasks.TaskId;
import org.elasticsearch.index.query.QueryBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class MonitorModule
extends AbstractInstantiableModule {
    private static final Logger LOG = Logger.getLogger(MonitorModule.class.getName());
    public static final String MODULE_ID = "monitor";
    public static final String SETTING_MAX_RESULT_WINDOW = "monitor_data_view_limit";
    public static final String SETTING_MAX_DATA_COUNT = "monitor_data_count_limit";
    public static final String SETTING_QUERY_BUFFER_LIMIT_IN_MB = "monitor_query_buffer_limit_in_mb";
    private static MonitorModule instance;
    private ExecutorService registerSearchQueriesQueue;
    private ScheduledExecutorService checkForMappingUpdatesExecutorService;
    private BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private BpcServicesTracker<CollaborationService> collaborationServiceTracker;
    private BpcServicesTracker<CoreBundleService> coreBundleServiceTracker;
    private BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private ServiceTracker moduleManagerTracker;
    private EventRegistration eventRegistration;
    private MonitorModuleInstanceSettingValidator monitorModuleInstanceSettingValidator;

    public MonitorModule(ModuleManager moduleManager) {
        super(moduleManager);
        LOG.info("********** MonitorModule **********");
        instance = this;
        this.registerSearchQueriesQueue = Executors.newSingleThreadExecutor((ThreadFactory)new ThreadFactoryWithNamePrefix("bpc-monitor-register-search-queries"));
        this.monitorModuleInstanceSettingValidator = new MonitorModuleInstanceSettingValidator();
        this.eventRegistration = new EventRegistration(null);
    }

    public static MonitorModule getInstance() {
        return instance;
    }

    public void setModuleBundle(Bundle moduleBundle) {
        super.setModuleBundle(moduleBundle);
        BundleContext bundleContext = moduleBundle.getBundleContext();
        BpcServicesTracker.stopAll((Object)((Object)this));
        this.elasticsearchServiceTracker = new BpcServicesTracker(bundleContext, ElasticsearchService.class);
        this.clientSessionManagerTracker = new BpcServicesTracker(bundleContext, ClientSessionManager.class);
        this.collaborationServiceTracker = new BpcServicesTracker(bundleContext, CollaborationService.class);
        this.coreBundleServiceTracker = new BpcServicesTracker(bundleContext, CoreBundleService.class);
        this.percolatorsManagerTracker = new BpcServicesTracker(bundleContext, PercolatorsManager.class);
        this.moduleManagerTracker = new ModuleManagerServiceTracker(bundleContext);
        this.moduleManagerTracker.open();
        this.eventRegistration.setBundleContext(bundleContext);
        this.eventRegistration.forMaintenanceModeAcknowledgeEvents((AbstractMaintenanceModeAcknowledgeEventHandler)new MaintenanceModeChangedEventHandler(bundleContext));
        try {
            if (!((CoreBundleService)this.coreBundleServiceTracker.getService()).isMaintenanceModeEnabled()) {
                this.startCheckingForIndexMappingUpdates();
            }
        }
        catch (ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Failed to start the check for index mapping updates.", ex);
        }
    }

    public void destroy() {
        super.destroy();
        if (this.registerSearchQueriesQueue != null) {
            this.registerSearchQueriesQueue.shutdown();
            this.registerSearchQueriesQueue = null;
        }
        this.stopCheckingForIndexMappingUpdates();
        BpcServicesTracker.stopAll((Object)((Object)this));
        if (this.moduleManagerTracker != null) {
            this.moduleManagerTracker.close();
        }
        this.eventRegistration.unregisterAllEventHandler();
        instance = null;
    }

    public String getModuleId() {
        return MODULE_ID;
    }

    public String getModuleName() {
        return "Process Monitoring";
    }

    public ModuleConfiguration getDefaultConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/default_module_settings.json").build();
    }

    public Class<? extends ModuleInstance> getModuleInstanceClass() {
        return MonitorModuleInstance.class;
    }

    public ModuleConfiguration getDefaultInstanceConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).withInstanceId(null).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/default_instance_settings.json").build();
    }

    public Elasticsearch getElasticsearch() {
        LOG.info("getElasticsearch");
        try {
            return new Elasticsearch((ElasticsearchService)this.elasticsearchServiceTracker.getService());
        }
        catch (ServiceNotFoundException e) {
            throw new IllegalStateException("Elasticsearch service is not available at the moment.");
        }
    }

    public void keepElasticsearchQueryForWebsocketUpdates(HttpHeaders httpHeaders, final String componentId, final String customId, final ElasticsearchService es, final String elasticSearchIndex, final QueryBuilder queryBuilder) throws ServiceNotFoundException {
        LOG.info("keepElasticsearchQueryForWebsocketUpdates(httpHeaders=..., componentId=" + componentId + ", customId=" + customId + ", es=..., elasticSearchIndex=" + elasticSearchIndex + ", queryBuilder=...)");
        ClientSessionManager clientSessionManager = (ClientSessionManager)this.clientSessionManagerTracker.getService();
        final PercolatorsManager percolatorsManager = (PercolatorsManager)this.percolatorsManagerTracker.getService();
        final String sessionId = clientSessionManager.getSessionId(httpHeaders);
        if (sessionId != null) {
            this.registerSearchQueriesQueue.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        percolatorsManager.registerPercolator(sessionId, componentId, customId, es, elasticSearchIndex, queryBuilder);
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, "Failed to register percolator.", ex);
                    }
                }
            });
        } else {
            LOG.warning("No session id found in the request headers. There must be something wrong.");
        }
    }

    public String createSearchIdPrefix(HttpHeaders httpHeaders, String componentId, String customId) {
        LOG.info("createSearchIdPrefix httpHeaders=..., componentId=" + componentId + ", customId=" + customId);
        String result = null;
        try {
            ClientSessionManager clientSessionManager = (ClientSessionManager)this.clientSessionManagerTracker.getService();
            String sessionId = clientSessionManager.getSessionId(httpHeaders);
            if (sessionId != null) {
                result = sessionId + "@@@" + componentId + "@@@" + customId;
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to create the searchIdPrefix.", ex);
        }
        return result;
    }

    public RequestOptions getRequestOptionsWithXOpaqueIdHeader(String searchIdPrefix, long timestamp) {
        LOG.info("getRequestOptionsWithXOpaqueIdHeader searchIdPrefix=" + searchIdPrefix + ", timestamp=" + timestamp);
        int queryBufferLimitInBytes = 0x100000 * this.getConfiguration().getSettingValue(SETTING_QUERY_BUFFER_LIMIT_IN_MB).asInt(100);
        RequestOptions.Builder requestOptionsBuilder = RequestOptions.DEFAULT.toBuilder();
        requestOptionsBuilder.setHttpAsyncResponseConsumerFactory((HttpAsyncResponseConsumerFactory)new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(queryBufferLimitInBytes));
        if (searchIdPrefix != null) {
            requestOptionsBuilder.addHeader("X-Opaque-Id", searchIdPrefix + "@@@" + timestamp);
        }
        return requestOptionsBuilder.build();
    }

    public void cancelRunningSearchTasks(final Elasticsearch es, final String searchIdPrefix, final long currentTimestamp) {
        LOG.info("cancelRunningSearchTasks es=..., searchIdPrefix=" + searchIdPrefix + ", currentTimestamp=" + currentTimestamp);
        if (searchIdPrefix == null) {
            return;
        }
        try {
            Object tasksEndpoint = "/_tasks";
            tasksEndpoint = (String)tasksEndpoint + "?group_by=none";
            tasksEndpoint = (String)tasksEndpoint + "&detailed=false";
            tasksEndpoint = (String)tasksEndpoint + "&wait_for_completion=false";
            tasksEndpoint = (String)tasksEndpoint + "&actions=" + URLEncoder.encode("indices:data/read/search*", "UTF-8");
            Request searchTasksRequest = new Request("GET", (String)tasksEndpoint);
            es.getClient().getLowLevelClient().performRequestAsync(searchTasksRequest, new ResponseListener(){

                public void onSuccess(Response searchTasksResponse) {
                    try (InputStream inputStream = searchTasksResponse.getEntity().getContent();){
                        ObjectMapper mapper = new ObjectMapper();
                        Map resp = (Map)mapper.readValue(inputStream, Map.class);
                        List tasks = (List)resp.get("tasks");
                        if (tasks != null && !tasks.isEmpty()) {
                            for (Map task : tasks) {
                                long oldTimestamp;
                                String opaqueId;
                                if (task.containsKey("parent_task_id")) continue;
                                String nodeId = (String)task.get("node");
                                long taskId = ((Number)task.get("id")).longValue();
                                Map headers = (Map)task.get("headers");
                                if (headers == null || !headers.containsKey("X-Opaque-Id") || !(opaqueId = (String)headers.get("X-Opaque-Id")).startsWith(searchIdPrefix) || (oldTimestamp = Long.parseLong(opaqueId.substring(opaqueId.lastIndexOf("@@@") + "@@@".length()))) >= currentTimestamp) continue;
                                CancelTasksRequest cancelRequest = new CancelTasksRequest.Builder().withTaskId(new TaskId(nodeId, taskId)).build();
                                es.getClient().tasks().cancelAsync(cancelRequest, RequestOptions.DEFAULT, (ActionListener)new ActionListener<CancelTasksResponse>(){

                                    public void onResponse(CancelTasksResponse cancelTasksResponse) {
                                        LOG.info("Task cancellation response received: " + cancelTasksResponse.getTasks());
                                    }

                                    public void onFailure(Exception ex) {
                                        LOG.log(Level.SEVERE, "Task cancellation failed.", ex);
                                    }
                                });
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, "Failed to cancel BPC search tasks.", ex);
                    }
                }

                public void onFailure(Exception ex) {
                    LOG.log(Level.SEVERE, "Failed to fetch the BPC related search tasks.", ex);
                }
            });
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to cancel old search tasks with the searchIdPrefix '" + searchIdPrefix + "'", ex);
        }
    }

    public boolean isTaskCancelledException(Exception ex) {
        ElasticsearchStatusException esse;
        Throwable[] suppressedExceptions;
        if (ex instanceof ElasticsearchStatusException && (suppressedExceptions = (esse = (ElasticsearchStatusException)ex).getSuppressed()) != null) {
            for (Throwable suppressedException : suppressedExceptions) {
                if (!(suppressedException instanceof ResponseException)) continue;
                ResponseException responseException = (ResponseException)suppressedException;
                try {
                    Map errorMap;
                    HttpEntity httpEntity = responseException.getResponse().getEntity();
                    Map stringObjectMap = JsonUtil.getInstance().jsonInputStreamAsMap(httpEntity.getContent());
                    if (stringObjectMap.containsKey("error") && (errorMap = (Map)stringObjectMap.get("error")).containsKey("root_cause")) {
                        List rootCauses = (List)errorMap.get("root_cause");
                        for (Object rootCause : rootCauses) {
                            if (!(rootCause instanceof Map)) continue;
                            Map rootCauseMap = (Map)rootCause;
                            String rootCauseType = (String)rootCauseMap.get("type");
                            String rootCauseReason = (String)rootCauseMap.get("reason");
                            if (!"task_cancelled_exception".equalsIgnoreCase(rootCauseType)) continue;
                            return true;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed to parse the Elasticsearch response exception (" + ex + "). Maybe Elasticsearch changed the way they return them now.", e);
                }
            }
        }
        return false;
    }

    public CollaborationService getCollaborationService() throws ServiceNotFoundException {
        return (CollaborationService)this.collaborationServiceTracker.getService();
    }

    private void startCheckingForIndexMappingUpdates() {
        LOG.info("startCheckingForIndexMappingUpdates");
        if (this.checkForMappingUpdatesExecutorService == null) {
            this.checkForMappingUpdatesExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryWithNamePrefix("bpc-monitor-mapping-updates"));
            this.checkForMappingUpdatesExecutorService.scheduleWithFixedDelay(new ElasticsearchMappingChecker(), 0L, 60L, TimeUnit.SECONDS);
        }
    }

    private void stopCheckingForIndexMappingUpdates() {
        LOG.info("stopCheckingForIndexMappingUpdates");
        if (this.checkForMappingUpdatesExecutorService != null) {
            this.checkForMappingUpdatesExecutorService.shutdownNow();
            this.checkForMappingUpdatesExecutorService = null;
        }
    }

    private class ModuleManagerServiceTracker
    extends ServiceTracker {
        public ModuleManagerServiceTracker(BundleContext context) {
            super(context, ModuleManager.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            ModuleManager moduleManager = (ModuleManager)this.context.getService(reference);
            moduleManager.setSettingValidator((SettingValidator)MonitorModule.this.monitorModuleInstanceSettingValidator);
            return moduleManager;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof ModuleManager) {
                ((ModuleManager)service).removeSettingValidator((SettingValidator)MonitorModule.this.monitorModuleInstanceSettingValidator);
            }
        }
    }

    private class ElasticsearchMappingChecker
    implements Runnable {
        private ElasticsearchMappingChecker() {
        }

        @Override
        public void run() {
            try {
                this.checkForIndexMappingUpdates();
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Exception while checking for index mapping updates.", t);
            }
        }

        public void checkForIndexMappingUpdates() {
            LOG.info("checkForIndexMappingUpdates");
            Map moduleInstances = MonitorModule.this.getModuleInstances();
            for (String moduleInstanceId : moduleInstances.keySet()) {
                ModuleConfiguration moduleInstanceConfiguration;
                LOG.info(moduleInstanceId + ": checkForIndexMappingUpdates");
                ModuleInstance moduleInstance = (ModuleInstance)moduleInstances.get(moduleInstanceId);
                if (moduleInstance == null || (moduleInstanceConfiguration = moduleInstance.getConfiguration()) == null) continue;
                try {
                    this.checkForIndexMappingUpdates(moduleInstance, moduleInstanceConfiguration, "data_index", "column_list");
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, moduleInstanceId + ": Failed to update the 'column_list' setting.", ex);
                }
                try {
                    this.checkForIndexMappingUpdates(moduleInstance, moduleInstanceConfiguration, "data_historyIndex", "column_historyList");
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, moduleInstanceId + ": Failed to update the 'column_historyList' setting.", ex);
                }
            }
        }

        private void checkForIndexMappingUpdates(ModuleInstance moduleInstance, ModuleConfiguration moduleInstanceConfiguration, String indexSettingName, String relatedTargetSettingName) throws SettingException {
            Elasticsearch es;
            LOG.info("checkForIndexMappingUpdates moduleInstance=" + moduleInstance + ", moduleInstanceConfiguration=..., indexSettingName=" + indexSettingName + ", relatedTargetSettingName=" + relatedTargetSettingName);
            if (moduleInstance == null || moduleInstanceConfiguration == null) {
                return;
            }
            try {
                es = MonitorModule.this.getElasticsearch();
            }
            catch (Exception ex) {
                LOG.warning(moduleInstance.getModuleId() + ": Skipping check for index mapping updates ... Elasticsearch service is not available at the moment");
                return;
            }
            Setting relatedTargetSetting = moduleInstanceConfiguration.getSetting(relatedTargetSettingName);
            Map currentMonitorInstanceIndexMapping = (Map)relatedTargetSetting.getValue();
            String esIndex = moduleInstanceConfiguration.getSettingValue(indexSettingName).asString("").toLowerCase();
            if (StringUtil.isNullOrEmpty((String)esIndex)) {
                if (currentMonitorInstanceIndexMapping != null) {
                    ((SimpleSettingImpl)relatedTargetSetting).setValue(null);
                    moduleInstanceConfiguration.addSetting(relatedTargetSetting, true);
                }
                LOG.info(moduleInstance.getModuleId() + ": esIndex '" + esIndex + "' is not set");
                return;
            }
            Map elasticsearchIndexMapping = es.getIndexMapping(esIndex);
            if (elasticsearchIndexMapping == null) {
                if (currentMonitorInstanceIndexMapping != null) {
                    ((SimpleSettingImpl)relatedTargetSetting).setValue(null);
                    moduleInstanceConfiguration.addSetting(relatedTargetSetting, true);
                }
                LOG.warning("Checking for index mapping updates not possible. The monitor instance '" + moduleInstance.getModuleId() + "' uses an non existing Elasticsearch index '" + esIndex + "' in the config field '" + relatedTargetSettingName + "'.");
                return;
            }
            if (elasticsearchIndexMapping.equals(currentMonitorInstanceIndexMapping)) {
                LOG.info(moduleInstance.getModuleId() + ": No index mapping change detected for index '" + esIndex + "'");
            } else {
                LOG.info(moduleInstance.getModuleId() + ": Mapping change detected for index '" + esIndex + "'");
                ((SimpleSettingImpl)relatedTargetSetting).setValue((Object)elasticsearchIndexMapping);
                moduleInstanceConfiguration.addSetting(relatedTargetSetting, true);
            }
        }
    }

    private class MaintenanceModeChangedEventHandler
    extends AbstractMaintenanceModeAcknowledgeEventHandler {
        public MaintenanceModeChangedEventHandler(BundleContext bundleContext) {
            super(bundleContext, MonitorModule.MODULE_ID);
        }

        public void processNewMaintenanceMode(boolean maintenanceModeEnabled) {
            LOG.info(((Object)((Object)this)).getClass().getSimpleName() + ".processNewMaintenanceMode enabled=" + maintenanceModeEnabled);
            try {
                if (maintenanceModeEnabled) {
                    MonitorModule.this.stopCheckingForIndexMappingUpdates();
                } else {
                    MonitorModule.this.startCheckingForIndexMappingUpdates();
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to start/stop the check for index mapping updates.", ex);
            }
        }
    }
}

