/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.module.monitor.MonitorErrorCode;
import de.virtimo.bpc.util.MapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class MonitorModuleInstanceSettingValidator
implements SettingValidator {
    private static final Logger LOG = Logger.getLogger(MonitorModuleInstanceSettingValidator.class.getName());

    public void destroy() {
        LOG.info("destroy");
    }

    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        LOG.info("canValidate moduleId:" + moduleId + ", moduleInstanceId:" + moduleInstanceId + ", instanceType:" + instanceType);
        return "monitor".equalsIgnoreCase(moduleId) && moduleInstanceId != null && !"noinstance".equalsIgnoreCase(moduleInstanceId);
    }

    public boolean canValidate(Setting setting) {
        LOG.info("canValidate setting:" + setting);
        return "column_config".equalsIgnoreCase(setting.getName());
    }

    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        LOG.info("validate setting:" + setting);
        if ("column_config".equalsIgnoreCase(setting.getName())) {
            this.validateColumnConfig(setting);
        }
        return null;
    }

    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String moduleInstanceType, Map<String, Setting> settings) throws ValidationException {
        LOG.info("validateModuleSettings moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId + ", moduleInstanceType=" + moduleInstanceType + ", settings:...");
        return null;
    }

    private void validateColumnConfig(Setting setting) throws ValidationException {
        Object valueObject = setting.getValue();
        if (valueObject instanceof ArrayList) {
            for (Object columnConfigEntryObject : (ArrayList)valueObject) {
                Map entry;
                Object minWidthObject;
                if (!(columnConfigEntryObject instanceof Map) || (minWidthObject = (entry = (Map)columnConfigEntryObject).get("minWidth")) == null) continue;
                String entryName = (String)entry.get("dataIndex");
                if (minWidthObject instanceof Integer) {
                    Integer minWidth = (Integer)minWidthObject;
                    if (minWidth > 0) continue;
                    throw new ValidationException((ErrorCode)MonitorErrorCode.VALIDATION_INVALID_INPUT, "${field}: Zero or negative value is not allowed for field 'minWidth'. Belongs to '${subField}' and the value '${subFieldValue}'.", MapUtil.mapOf((Object[])new Object[]{"field", "column_config", "subField", entryName, "subFieldValue", "" + minWidth}));
                }
                throw new ValidationException((ErrorCode)MonitorErrorCode.VALIDATION_INVALID_INPUT, "No numeric type (integer) given for field 'minWidth'. Belongs to '${subField}' and the value '${subFieldValue}'.", MapUtil.mapOf((Object[])new Object[]{"field", "column_config", "subField", entryName, "subFieldValue", "" + minWidthObject}));
            }
        }
    }
}

