/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.resource;

import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.module.monitor.resource.MonitorDataExporter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;

public class MonitorDataXlsxExporter
extends MonitorDataExporter {
    private static final Logger LOG = Logger.getLogger(MonitorDataXlsxExporter.class.getName());
    public static final String MONITOR_COLUMN_CONFIG_IDENTIFIER_XLSX_EXPORT_FORMAT = "formatXlsxExport";
    private boolean useCustomColumnHeaders = true;
    private boolean autoResizeColumns;
    private final XSSFWorkbook wb = new XSSFWorkbook();
    private final XSSFCellStyle defaultDateCellStyle = this.wb.createCellStyle();
    private final HashMap<String, XSSFCellStyle> cellStylesCache;

    public MonitorDataXlsxExporter(ModuleInstance mi, MappingMetadata mappingMetaData, List<String> inclOnlyThisColumns, boolean inclHidden, Map<String, Object> translationsForBpcLanguage) throws IOException {
        super(mi, mappingMetaData, inclOnlyThisColumns, inclHidden, translationsForBpcLanguage);
        this.defaultDateCellStyle.setDataFormat(this.wb.getCreationHelper().createDataFormat().getFormat("dd.mm.yyyy hh:mm:ss"));
        this.cellStylesCache = new HashMap();
    }

    public boolean isUseCustomColumnHeaders() {
        return this.useCustomColumnHeaders;
    }

    public void setUseCustomColumnHeaders(boolean useCustomColumnHeaders) {
        this.useCustomColumnHeaders = useCustomColumnHeaders;
    }

    public boolean isAutoResizeColumns() {
        return this.autoResizeColumns;
    }

    public void setAutoResizeColumns(boolean autoResizeColumns) {
        this.autoResizeColumns = autoResizeColumns;
    }

    /*
     * WARNING - void declaration
     */
    public void writeSearchResponseToOutputStream(RestHighLevelClient esClient, SearchResponse scrollResp, Integer limit, OutputStream outputStream) throws IOException {
        LOG.info("writeSearchResponseToOutputStream");
        ArrayList<MonitorDataExporter.MonitorDataExportColumn> monitorDataExportColumns = this.getMonitorDataExportColumns(this.useCustomColumnHeaders);
        XSSFSheet sheet = this.wb.createSheet("Monitor Export");
        XSSFFont headerCellFont = this.wb.createFont();
        headerCellFont.setBold(true);
        headerCellFont.setColor(new XSSFColor(Color.BLACK, null));
        XSSFCellStyle headerCellStyle = this.wb.createCellStyle();
        headerCellStyle.setAlignment(HorizontalAlignment.CENTER);
        headerCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headerCellStyle.setFillForegroundColor(new XSSFColor(Color.LIGHT_GRAY, null));
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerCellStyle.setFont((Font)headerCellFont);
        int rowIdx = 0;
        XSSFRow headerRow = sheet.createRow(rowIdx);
        int headerCellIdx = 0;
        for (MonitorDataExporter.MonitorDataExportColumn monitorDataExportColumn : monitorDataExportColumns) {
            Cell cell = headerRow.createCell(headerCellIdx);
            cell.setCellValue(monitorDataExportColumn.getColumnNameForExport());
            cell.setCellStyle((CellStyle)headerCellStyle);
            ++headerCellIdx;
        }
        boolean done = false;
        while (!done) {
            for (SearchHit hit : scrollResp.getHits().getHits()) {
                XSSFRow row = sheet.createRow(++rowIdx);
                Map sourceValues = hit.getSourceAsMap();
                int innerCellIdx = 0;
                for (MonitorDataExporter.MonitorDataExportColumn monitorDataExportColumn : monitorDataExportColumns) {
                    String columnName = monitorDataExportColumn.getColumnName();
                    Object columnValue = sourceValues.get(columnName);
                    XSSFCell cell = row.createCell(innerCellIdx);
                    if (columnValue != null) {
                        String columnType = this.getElasticsearchColumnType(columnName);
                        this.setValueToCell(cell, columnName, columnValue, columnType);
                    }
                    ++innerCellIdx;
                }
                if (limit == null || rowIdx < limit) continue;
                LOG.info("Stop .... export limit of " + limit + " rows reached (" + rowIdx + ")");
                done = true;
                break;
            }
            if (done || (scrollResp = esClient.scroll(new SearchScrollRequest(scrollResp.getScrollId()).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0) continue;
            LOG.info("Stop ... no more hits");
            done = true;
            break;
        }
        if (this.autoResizeColumns) {
            void var13_18;
            boolean bl = false;
            while (var13_18 < monitorDataExportColumns.size()) {
                sheet.autoSizeColumn((int)var13_18);
                ++var13_18;
            }
        }
        this.wb.write(outputStream);
    }

    private void setValueToCell(XSSFCell cell, String columnName, Object columnValue, String columnType) {
        if ("date".equalsIgnoreCase(columnType)) {
            Date date = this.getDateFromValue(columnValue);
            if (date != null) {
                cell.setCellValue(date);
                cell.setCellStyle((CellStyle)this.getDateCellStyle(columnName));
            } else {
                cell.setCellValue(columnValue.toString());
            }
        } else if ("boolean".equalsIgnoreCase(columnType)) {
            if (columnValue instanceof Boolean) {
                cell.setCellValue(((Boolean)columnValue).booleanValue());
            } else {
                cell.setCellValue(columnValue.toString());
            }
        } else if (Arrays.asList("long", "integer", "short", "byte", "double", "float", "half_float").contains(columnType)) {
            XSSFCellStyle numberCellStyle;
            boolean formattableNumberObject = true;
            if (columnValue instanceof Double) {
                cell.setCellValue(((Double)columnValue).doubleValue());
            } else if (columnValue instanceof Float) {
                cell.setCellValue((double)((Float)columnValue).floatValue());
            } else if (columnValue instanceof Integer) {
                cell.setCellValue((double)((Integer)columnValue).intValue());
            } else if (columnValue instanceof Long) {
                cell.setCellValue((double)((Long)columnValue).longValue());
            } else {
                LOG.warning("Formatting of column '" + columnName + "' of type '" + columnType + "' and value class '" + columnValue.getClass().getName() + "' is not yet implemented.");
                formattableNumberObject = false;
                cell.setCellValue(columnValue.toString());
            }
            if (formattableNumberObject && (numberCellStyle = this.getNumberCellStyle(columnName)) != null) {
                cell.setCellStyle((CellStyle)numberCellStyle);
            }
        } else if ("scaled_float".equalsIgnoreCase(columnType)) {
            String scalingFactor = this.getElasticsearchMappingFieldConfig(columnName).get("scaling_factor").toString();
            LOG.warning("Formatting column '" + columnName + "' of type '" + columnType + "' and value class '" + columnValue.getClass().getName() + "' is not yet implemented.");
            cell.setCellValue(columnValue.toString());
        } else {
            String columnValueToSet = columnValue.toString();
            if (columnValueToSet.length() > Short.MAX_VALUE) {
                LOG.warning("A value in the column '" + columnName + "' exceeded the max string length limit of 32767 characters and has been truncated. This is a limitation of the Microsoft Excel specification.");
                cell.setCellValue(columnValueToSet.substring(0, Short.MAX_VALUE));
            } else {
                cell.setCellValue(columnValueToSet);
            }
        }
    }

    private XSSFCellStyle getNumberCellStyle(String columnName) {
        String customNumberFormat = this.getMonitorColumnConfigStringSetting(columnName, MONITOR_COLUMN_CONFIG_IDENTIFIER_XLSX_EXPORT_FORMAT);
        if (customNumberFormat != null) {
            XSSFCellStyle numberCellStyle = this.cellStylesCache.get(customNumberFormat);
            if (numberCellStyle == null) {
                numberCellStyle = this.wb.createCellStyle();
                numberCellStyle.setDataFormat(this.wb.getCreationHelper().createDataFormat().getFormat(customNumberFormat));
                this.cellStylesCache.put(customNumberFormat, numberCellStyle);
            }
            return numberCellStyle;
        }
        return null;
    }

    private XSSFCellStyle getDateCellStyle(String columnName) {
        String customDateFormat = this.getMonitorColumnConfigStringSetting(columnName, MONITOR_COLUMN_CONFIG_IDENTIFIER_XLSX_EXPORT_FORMAT);
        if (customDateFormat != null) {
            XSSFCellStyle dateCellStyle = this.cellStylesCache.get(customDateFormat);
            if (dateCellStyle == null) {
                dateCellStyle = this.wb.createCellStyle();
                dateCellStyle.setDataFormat(this.wb.getCreationHelper().createDataFormat().getFormat(customDateFormat));
                this.cellStylesCache.put(customDateFormat, dateCellStyle);
            }
            return dateCellStyle;
        }
        return this.defaultDateCellStyle;
    }
}

