/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.resource.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.CollaborationService;
import de.virtimo.bpc.api.service.ReplicationInfoService;
import de.virtimo.bpc.module.monitor.MonitorModule;
import de.virtimo.bpc.module.monitor.resource.response.MonitorData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class MonitorDataImpl
implements MonitorData {
    private static final Logger LOG = Logger.getLogger(MonitorDataImpl.class.getName());
    private final String dataIndex;
    private final SearchResponse sr;
    private final String collaboration;
    private final String instanceId;
    private CollaborationService collaborationService;
    private final UserSession session;

    public MonitorDataImpl(SearchResponse sr, String dataIndex) {
        this(sr, dataIndex, null, null);
    }

    public MonitorDataImpl(SearchResponse sr, String dataIndex, String collaboration, String instanceId) {
        this(sr, dataIndex, null, null, null);
    }

    public MonitorDataImpl(SearchResponse sr, String dataIndex, String collaboration, String instanceId, UserSession session) {
        this.sr = sr;
        this.dataIndex = dataIndex;
        this.collaboration = collaboration;
        this.instanceId = instanceId;
        this.session = session;
        try {
            if (this.collaboration != null) {
                this.collaborationService = MonitorModule.getInstance().getCollaborationService();
            }
        }
        catch (ServiceNotFoundException ex) {
            LOG.warning("Failed to get the collaboration service");
            this.collaborationService = null;
        }
    }

    @Override
    public long getTotalCount() {
        return this.sr == null ? 0L : this.sr.getHits().getTotalHits().value;
    }

    @Override
    public List<Map<String, Object>> getData() {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        if (this.sr != null) {
            for (SearchHit hit : this.sr.getHits().getHits()) {
                Map<String, Object> processDataMap = hit.getSourceAsMap();
                if (!processDataMap.containsKey("_id")) {
                    processDataMap.put("_id", hit.getId());
                }
                if (this.collaboration != null && this.collaborationService != null) {
                    processDataMap = this.getCollabDataForSourceMap(processDataMap);
                } else {
                    processDataMap.put("collabData", "Collaboration Service not available or collabReferenceKey not set");
                }
                dataList.add(processDataMap);
            }
        }
        return dataList;
    }

    @JsonIgnore
    private Map<String, Object> getCollabDataForSourceMap(Map<String, Object> processDataMap) {
        try {
            if (processDataMap.containsKey(this.collaboration)) {
                String collabReferenceId = String.valueOf(processDataMap.get(this.collaboration));
                if (collabReferenceId != null) {
                    if (this.instanceId != null) {
                        Map map;
                        ModuleInstance mi = MonitorModule.getInstance().getModuleInstance(this.instanceId);
                        Map collabDescriptor = mi.getConfiguration().getSettingValue("module_collab_descriptor").asMap();
                        String integrationReference = null;
                        if (collabDescriptor.containsKey("integrationReference")) {
                            integrationReference = (String)collabDescriptor.get("integrationReference");
                        }
                        if ((map = this.collaborationService.getReferenceOverview(this.session, "monitor", this.instanceId, collabReferenceId, integrationReference)) != null) {
                            processDataMap.put("collabData", map);
                        } else {
                            processDataMap.put("collabData", "Error while fetching collab Data");
                        }
                    }
                } else {
                    processDataMap.put("collabData", "Reference not found in dataSource");
                }
            }
        }
        catch (Exception e) {
            processDataMap.put("collabData", "Oups, something went wrong");
        }
        return processDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> getLastReplication() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = null;
        try {
            serviceReference = bundleContext.getServiceReference(ReplicationInfoService.class);
            ReplicationInfoService replicationInfoService = (ReplicationInfoService)bundleContext.getService(serviceReference);
            Map infoObj = replicationInfoService.getReplicationJob(this.dataIndex);
            ArrayList<Map<String, Object>> jobInfoList = new ArrayList<Map<String, Object>>();
            jobInfoList.add(infoObj);
            ArrayList<Map<String, Object>> arrayList = jobInfoList;
            return arrayList;
        }
        finally {
            if (serviceReference != null) {
                bundleContext.ungetService(serviceReference);
            }
        }
    }
}

