/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.backup.BackupActivatedInfo;
import de.virtimo.bpc.api.backup.BackupRestoredInfo;
import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.exception.BackupConflictException;
import de.virtimo.bpc.api.backup.exception.BackupException;
import de.virtimo.bpc.api.backup.exception.BackupNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupRepositoryNotFoundException;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.response.GlobalConfig;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.StreamingOutput;

public interface BackupManager {
    public int getNumberOfScheduledBackupJobs();

    public Set<String> getIdentifiersOfScheduledBackupJobs();

    public void scheduleBackupJobWithSettings(String var1, BackupSetting var2);

    public void stopBackupJob(String var1);

    public void stopBackupJobsWithPrefix(String var1);

    public List<BackupSnapshotInfo> getAllBackups() throws ServiceNotFoundException, BackupRepositoryNotFoundException, ElasticsearchRelatedException;

    public BackupSnapshotInfo getBackupInfo(String var1) throws BackupRepositoryNotFoundException, BackupNotFoundException, ServiceNotFoundException, ElasticsearchRelatedException;

    public BackupSnapshotInfo createBackup(BackupSetting var1) throws BackupException, ServiceNotFoundException, ElasticsearchRelatedException;

    public BackupSnapshotInfo createBackup(String var1, Set<String> var2) throws BackupException, ServiceNotFoundException, ElasticsearchRelatedException;

    public BackupSnapshotInfo deleteBackup(String var1) throws BackupRepositoryNotFoundException, BackupNotFoundException, ServiceNotFoundException, ElasticsearchRelatedException;

    public BackupActivatedInfo activateBackup(String var1) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, ElasticsearchRelatedException;

    public BackupRestoredInfo restoreBackup(String var1, String var2) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, ElasticsearchRelatedException;

    public StreamingOutput downloadSnapshotContent(String var1) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, ElasticsearchRelatedException;

    public GlobalConfig exportBpcConfiguration(String var1) throws BackupException, BackupConflictException, ServiceNotFoundException, ElasticsearchRelatedException;
}

