/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.BackupSettingFactory;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class BackupSetting {
    private static final Logger LOG = Logger.getLogger(BackupSetting.class.getName());
    public static final boolean DEFAULT_ENABLED = true;
    public static final long DEFAULT_INTERVAL_IN_SECONDS = 86400L;
    public static final long DEFAULT_KEEP_BACKUPS_DURATION_IN_SECONDS = 2592000L;
    private final boolean enabled;
    private final long intervalInSeconds;
    private final long keepBackupsDurationInSeconds;
    private final Set<String> indicesToBackup;

    public static BackupSetting buildFrom(Setting backupSetting, String[] indices) {
        return BackupSettingFactory.createFrom(backupSetting, indices);
    }

    private BackupSetting() {
        this(true, 86400L, 2592000L, null);
    }

    public BackupSetting(boolean enabled, long intervalInSeconds, long keepBackupsDurationInSeconds, String[] indicesToBackup) {
        LOG.info("BackupSetting enabled=" + enabled + ", intervalInSeconds=" + intervalInSeconds + ", keepBackupsDurationInSeconds=" + keepBackupsDurationInSeconds + ", indicesToBackup=" + (indicesToBackup == null ? null : Arrays.asList(indicesToBackup)));
        this.enabled = enabled;
        this.intervalInSeconds = intervalInSeconds;
        this.keepBackupsDurationInSeconds = keepBackupsDurationInSeconds;
        this.indicesToBackup = indicesToBackup == null ? null : new HashSet<String>(Arrays.asList(indicesToBackup));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getIntervalInSeconds() {
        return this.intervalInSeconds;
    }

    public long getKeepBackupsDurationInSeconds() {
        return this.keepBackupsDurationInSeconds;
    }

    public Set<String> getIndicesToBackup() {
        return this.indicesToBackup;
    }

    public String getIndicesToBackupNamesAsKey() {
        return StringUtil.implode("_", this.indicesToBackup);
    }

    public String getSnapshotNamePrefix() {
        return "snapshot-" + this.getIndicesToBackupNamesAsKey() + "-";
    }

    public String getNewSnapshotName() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        return this.getSnapshotNamePrefix() + dateFormat.format(new Date());
    }

    public String toString() {
        return "BackupSetting{enabled=" + this.enabled + ", intervalInSeconds=" + this.intervalInSeconds + ", keepBackupsDurationInSeconds=" + this.keepBackupsDurationInSeconds + ", indicesToBackup=" + this.indicesToBackup + "}";
    }
}

