/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.util.MapUtil;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackupSettingFactory {
    private static final Logger LOG = Logger.getLogger(BackupSettingFactory.class.getName());
    private static final String ENABLED = "enabled";
    private static final String INTERVAL_IN_SECONDS = "intervalInSeconds";
    private static final String KEEP_BACKUPS_DURATION_IN_SECONDS = "keepBackupsDurationInSeconds";

    public static BackupSetting createFrom(Setting backupSetting, String[] indices) {
        boolean enabled = true;
        long intervalInSeconds = 86400L;
        long keepBackupsDurationInSeconds = 2592000L;
        if (backupSetting != null) {
            Object backupSettingObject = backupSetting.getValue();
            if (backupSettingObject instanceof Map) {
                Map valueMap = (Map)backupSettingObject;
                enabled = MapUtil.getValueAsBoolean(valueMap, ENABLED, true);
                intervalInSeconds = MapUtil.getValueAsLong(valueMap, INTERVAL_IN_SECONDS, 86400L);
                keepBackupsDurationInSeconds = MapUtil.getValueAsLong(valueMap, KEEP_BACKUPS_DURATION_IN_SECONDS, 2592000L);
            } else {
                LOG.log(Level.SEVERE, "The backup setting '" + backupSetting.getName() + "' must be a JSON Map/Dictionary. Using the defaults.");
            }
        } else {
            LOG.info("The backup setting is missing. Using the defaults.");
        }
        return new BackupSetting(enabled, intervalInSeconds, keepBackupsDurationInSeconds, indices);
    }
}

