/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class ErrorResponse {
    public static ErrorResponseBuilder forException(Exception ex) {
        return ErrorResponseBuilder.newInstance().forException(ex);
    }

    public static ErrorResponseBuilder usingTracker(BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker) {
        return ErrorResponseBuilder.newInstance().usingTracker(errorResponseServiceTracker);
    }

    public static ErrorResponseBuilder languageFrom(HttpHeaders httpHeaders) {
        return ErrorResponseBuilder.newInstance().languageFrom(httpHeaders);
    }

    public static ErrorResponseBuilder language(String language) {
        return ErrorResponseBuilder.newInstance().language(language);
    }

    public static <T extends Enum<T>> SystemException reconstructSystemException(BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker, Response r, Class<T> usingErrorCodeEnum) {
        try {
            return errorResponseServiceTracker.getService().reconstructSystemException(r, usingErrorCodeEnum);
        }
        catch (ServiceNotFoundException snfex) {
            return null;
        }
    }

    public static <T extends Enum<T>> SystemException reconstructSystemException(Response r, Class<T> usingErrorCodeEnum) {
        try {
            return ErrorResponse.getErrorResponseService().reconstructSystemException(r, usingErrorCodeEnum);
        }
        catch (ServiceNotFoundException snfex) {
            return null;
        }
    }

    private static ErrorResponseService getErrorResponseService() throws ServiceNotFoundException {
        BundleContext bundleContext = FrameworkUtil.getBundle(ErrorResponse.class).getBundleContext();
        try (BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(bundleContext, ErrorResponseService.class);){
            ErrorResponseService errorResponseService = errorResponseServiceTracker.getService();
            return errorResponseService;
        }
    }

    public static class ErrorResponseBuilder {
        private Exception ex = null;
        private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker = null;
        private HttpHeaders httpHeaders = null;
        private String language = null;

        private ErrorResponseBuilder() {
        }

        private static ErrorResponseBuilder newInstance() {
            return new ErrorResponseBuilder();
        }

        public ErrorResponseBuilder forException(Exception ex) {
            this.ex = ex;
            return this;
        }

        public ErrorResponseBuilder usingTracker(BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker) {
            this.errorResponseServiceTracker = errorResponseServiceTracker;
            return this;
        }

        public ErrorResponseBuilder languageFrom(HttpHeaders httpHeaders) {
            this.httpHeaders = httpHeaders;
            return this;
        }

        public ErrorResponseBuilder language(String language) {
            this.language = language;
            return this;
        }

        public Response build() {
            try {
                ErrorResponseService errorResponseService;
                ErrorResponseService errorResponseService2 = errorResponseService = this.errorResponseServiceTracker != null ? this.errorResponseServiceTracker.getService() : ErrorResponse.getErrorResponseService();
                if (this.language != null) {
                    return errorResponseService.responseForException(this.language, this.ex);
                }
                if (this.httpHeaders != null) {
                    return errorResponseService.responseForException(this.httpHeaders, this.ex);
                }
                return errorResponseService.responseForException(this.ex);
            }
            catch (ServiceNotFoundException snfex) {
                return this.shouldNotHappenWorkaroundResponse();
            }
        }

        private Response shouldNotHappenWorkaroundResponse() {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").entity(Map.of("error", Map.of("code", 1, "name", "UNEXPECTED", "message", "Failed to get the mandatory error response service."))).build();
        }
    }
}

