/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.service.InternationalizationService;
import de.virtimo.bpc.util.StringUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class SystemException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String language = null;
    private ErrorCode errorCode;
    private String messagePrefixKey;
    private final Map<String, Object> properties = new TreeMap<String, Object>();

    public static SystemException wrap(Throwable exception, ErrorCode errorCode) {
        if (exception instanceof SystemException) {
            SystemException se = (SystemException)exception;
            if (errorCode != null && errorCode != se.getErrorCode()) {
                return new SystemException(errorCode, se.getMessage(), se.getProperties(), (Throwable)se);
            }
            return se;
        }
        return new SystemException(errorCode, exception.getMessage(), exception);
    }

    private static String filledMessage(String message, Map<String, Object> props) {
        String result = message;
        if (props != null) {
            for (Map.Entry<String, Object> stringObjectEntry : props.entrySet()) {
                result = result.replace("${" + stringObjectEntry.getKey() + "}", String.valueOf(stringObjectEntry.getValue()));
                result = result.replace("{" + stringObjectEntry.getKey() + "}", String.valueOf(stringObjectEntry.getValue()));
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getTranslation(String language, String key) {
        if (language == null) return null;
        if (StringUtil.isNullOrEmpty(key)) return null;
        BundleContext bundleContext = FrameworkUtil.getBundle(SystemException.class).getBundleContext();
        try (BpcServicesTracker<InternationalizationService> internationalizationServiceTracker = new BpcServicesTracker<InternationalizationService>(bundleContext, InternationalizationService.class);){
            InternationalizationService internationalizationService = internationalizationServiceTracker.getService();
            Map<String, Object> translationsForLanguage = internationalizationService.getTranslationsForLanguage(language);
            if (translationsForLanguage == null) return null;
            String string = (String)translationsForLanguage.get(key);
            return string;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static SystemException wrap(Throwable exception) {
        return SystemException.wrap(exception, null);
    }

    public SystemException(ErrorCode errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public SystemException(ErrorCode errorCode, String messagePrefixKey, String message) {
        super(message);
        this.messagePrefixKey = messagePrefixKey;
        this.errorCode = errorCode;
    }

    public SystemException(ErrorCode errorCode, String message, Map<String, Object> props) {
        super(SystemException.filledMessage(message, props));
        this.errorCode = errorCode;
        if (props != null) {
            this.properties.putAll(props);
        }
    }

    public SystemException(ErrorCode errorCode, String messagePrefixKey, String message, Map<String, Object> props) {
        super(SystemException.filledMessage(message, props));
        this.messagePrefixKey = messagePrefixKey;
        this.errorCode = errorCode;
        if (props != null) {
            this.properties.putAll(props);
        }
    }

    public SystemException(ErrorCode errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    public SystemException(ErrorCode errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public SystemException(ErrorCode errorCode, String messagePrefixKey, String message, Throwable cause) {
        super(message, cause);
        this.messagePrefixKey = messagePrefixKey;
        this.errorCode = errorCode;
    }

    public SystemException(ErrorCode errorCode, String message, Map<String, Object> props, Throwable cause) {
        super(SystemException.filledMessage(message, props), cause);
        this.errorCode = errorCode;
        if (props != null) {
            this.properties.putAll(props);
        }
    }

    public SystemException(ErrorCode errorCode, String messagePrefixKey, String message, Map<String, Object> props, Throwable cause) {
        super(SystemException.filledMessage(message, props), cause);
        this.messagePrefixKey = messagePrefixKey;
        this.errorCode = errorCode;
        if (props != null) {
            this.properties.putAll(props);
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
        if (this.getCause() instanceof SystemException) {
            SystemException causeAsSex = (SystemException)this.getCause();
            if (language != null && !language.equals(causeAsSex.getLanguage())) {
                causeAsSex.setLanguage(language);
            }
        }
    }

    public boolean isErrorCode(ErrorCode ... errorCodes) {
        for (ErrorCode code : errorCodes) {
            if (code != this.errorCode) continue;
            return true;
        }
        return false;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public SystemException setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public <T> T get(String name) {
        return (T)this.properties.get(name);
    }

    public SystemException set(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    @Override
    public String getLocalizedMessage() {
        String languageToUse;
        String messageOrLangKey = this.getMessage();
        String localizedMessagePrefix = this.messagePrefixKey;
        String localizedMessage = messageOrLangKey;
        String string = this.language != null ? this.language : (languageToUse = messageOrLangKey != null && messageOrLangKey.indexOf(32) == -1 ? "en" : null);
        if (languageToUse != null) {
            String translatedMessage;
            String translateMessagePrefix;
            if (this.messagePrefixKey != null && (translateMessagePrefix = SystemException.getTranslation(languageToUse, this.messagePrefixKey)) != null) {
                localizedMessagePrefix = SystemException.filledMessage(translateMessagePrefix, this.getProperties());
            }
            if (messageOrLangKey != null && (translatedMessage = SystemException.getTranslation(languageToUse, messageOrLangKey)) != null) {
                localizedMessage = SystemException.filledMessage(translatedMessage, this.getProperties());
            }
        }
        ArrayList<String> msgPieces = new ArrayList<String>();
        if (localizedMessagePrefix != null) {
            msgPieces.add(localizedMessagePrefix);
        }
        if (localizedMessage != null) {
            msgPieces.add(localizedMessage);
        }
        return StringUtil.implode("", msgPieces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            this.printStackTrace(new PrintWriter(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            StackTraceElement[] trace;
            s.println(this);
            s.println("\t-------------------------------");
            if (this.errorCode != null) {
                s.println("\t" + this.errorCode + ":" + this.errorCode.getClass().getName());
            }
            for (String string : this.properties.keySet()) {
                s.println("\t" + string + "=[" + this.properties.get(string) + "]");
            }
            s.println("\t-------------------------------");
            for (StackTraceElement aTrace : trace = this.getStackTrace()) {
                s.println("\tat " + aTrace);
            }
            Throwable throwable = this.getCause();
            if (throwable != null) {
                throwable.printStackTrace(s);
            }
            s.flush();
        }
    }

    public Map<String, Object> asMap() {
        String message = this.getMessage();
        String localizedMessage = this.getLocalizedMessage();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", this.errorCode.getNumber());
        result.put("name", this.errorCode);
        result.put("message", localizedMessage);
        if (localizedMessage != null && !localizedMessage.equals(message)) {
            result.put("messageKey", message);
        }
        if (this.messagePrefixKey != null) {
            result.put("messagePrefixKey", this.messagePrefixKey);
        }
        result.put("properties", this.properties);
        return result;
    }

    public Map<String, Object> asErrorResponseMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("error", this.asMap());
        return result;
    }
}

