/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.es.querybuilder;

import de.virtimo.bpc.api.es.querybuilder.EsDataFilter;

public class EsDataFilterBuilder {
    private String property;
    private String value;
    private String[] values;
    private String operator;
    private String source;
    private boolean invert = false;

    public static EsDataFilterBuilder newInstance() {
        return new EsDataFilterBuilder();
    }

    public EsDataFilterBuilder withProperty(String property) {
        this.property = property;
        return this;
    }

    public EsDataFilterBuilder withValue(String value) {
        this.value = value;
        return this;
    }

    public EsDataFilterBuilder withValue(int value) {
        this.value = String.valueOf(value);
        return this;
    }

    public EsDataFilterBuilder withValues(String[] values) {
        this.values = values;
        return this;
    }

    public EsDataFilterBuilder withOperator(String operator) {
        this.operator = operator;
        return this;
    }

    public EsDataFilterBuilder withSource(String source) {
        this.source = source;
        return this;
    }

    public EsDataFilterBuilder withInvert(boolean invert) {
        this.invert = invert;
        return this;
    }

    public EsDataFilter build() {
        return new EsDataFilter(this.property, this.value, this.values, this.operator, this.source, this.invert);
    }
}

