/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.es.querybuilder;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EsDataSort {
    private String property;
    private String direction;

    public static List<EsDataSort> fromJsonArray(String sortJson) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            List list = (List)objectMapper.readValue(sortJson, (TypeReference)new TypeReference<List<EsDataSort>>(){});
            return list;
        }
        finally {
            if (objectMapper != null) {
                ObjectMapperPool.getInstance().restore((Object)objectMapper);
            }
        }
    }

    public static List<EsDataSort> fromCompactFormat(String sortInstructions) {
        ArrayList<EsDataSort> result = new ArrayList<EsDataSort>();
        if (!StringUtil.isNullOrEmpty(sortInstructions)) {
            List<String> sortInstructionsList = StringUtil.explode(sortInstructions, ",");
            for (String sortInstruction : sortInstructionsList) {
                String fieldSortOrder;
                String fieldName;
                int separatorIdx = sortInstruction.lastIndexOf("|");
                if (separatorIdx == -1) {
                    fieldName = sortInstruction;
                    fieldSortOrder = "ASC";
                } else {
                    fieldName = sortInstruction.substring(0, separatorIdx);
                    fieldSortOrder = sortInstruction.substring(separatorIdx + 1);
                }
                String sortOrder = fieldSortOrder.equalsIgnoreCase("DESC") ? "DESC" : "ASC";
                result.add(new EsDataSort(fieldName, sortOrder));
            }
        }
        return result;
    }

    private EsDataSort() {
    }

    public EsDataSort(String property, String direction) {
        this.property = property;
        this.direction = direction;
    }

    public String getProperty() {
        return this.property;
    }

    public String getDirection() {
        return this.direction;
    }

    public String toString() {
        return this.property + " : " + this.direction;
    }
}

