/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.es.querybuilder;

import de.virtimo.bpc.api.es.querybuilder.EsDataSort;
import de.virtimo.bpc.api.es.querybuilder.EsIndexMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class EsSortBuilder {
    private static final Logger LOG = Logger.getLogger(EsSortBuilder.class.getName());
    private final List<SortBuilder> sorters = new ArrayList<SortBuilder>();
    private final EsIndexMapping indexMapping;

    public static EsSortBuilder init(EsIndexMapping indexMapping) {
        return new EsSortBuilder(indexMapping);
    }

    private EsSortBuilder(EsIndexMapping indexMapping) {
        this.indexMapping = indexMapping;
    }

    public EsSortBuilder addSortFromJsonArray(String sortJson) throws IOException {
        return this.addSortBuilder(this.createSortBuildersFromJsonArray(sortJson));
    }

    public EsSortBuilder addSort(List<EsDataSort> sorts) {
        return this.addSortBuilder(this.createSortBuilders(sorts));
    }

    public EsSortBuilder addSort(String fieldName, String direction) {
        return this.addSortBuilder(this.createSortBuilder(new EsDataSort(fieldName, direction)));
    }

    public EsSortBuilder addSort(EsDataSort sort) {
        return this.addSortBuilder(this.createSortBuilder(sort));
    }

    public EsSortBuilder addSortFromCompactFormat(String sortInstructions) {
        return this.addSortBuilder(this.createSortBuildersFromCompactFormat(sortInstructions));
    }

    public EsSortBuilder addSortBuilder(List<SortBuilder> sortBuilders) {
        if (sortBuilders != null) {
            this.sorters.addAll(sortBuilders);
        }
        return this;
    }

    public EsSortBuilder addSortBuilder(SortBuilder sortBuilder) {
        if (sortBuilder != null) {
            this.sorters.add(sortBuilder);
        }
        return this;
    }

    public List<SortBuilder> build() {
        return new ArrayList<SortBuilder>(this.sorters);
    }

    private List<SortBuilder> createSortBuildersFromCompactFormat(String sortInstructions) {
        LOG.info("createSortBuildersFromCompactFormat sortInstructions=" + sortInstructions);
        ArrayList<SortBuilder> result = new ArrayList<SortBuilder>();
        if (sortInstructions != null) {
            List<EsDataSort> sorters = EsDataSort.fromCompactFormat(sortInstructions);
            result.addAll(this.createSortBuilders(sorters));
        }
        return result;
    }

    private List<SortBuilder> createSortBuildersFromJsonArray(String sortJson) throws IOException {
        LOG.info("createSortBuildersFromJsonArray sortJson=" + sortJson);
        ArrayList<SortBuilder> result = new ArrayList<SortBuilder>();
        if (sortJson != null) {
            List<EsDataSort> sorters = EsDataSort.fromJsonArray(sortJson);
            result.addAll(this.createSortBuilders(sorters));
        }
        return result;
    }

    private List<SortBuilder> createSortBuilders(List<EsDataSort> sorters) {
        LOG.info("createSortBuilders sorters=" + sorters);
        ArrayList<SortBuilder> result = new ArrayList<SortBuilder>();
        if (sorters != null) {
            for (EsDataSort sorter : sorters) {
                result.add(this.createSortBuilder(sorter));
            }
        }
        return result;
    }

    private SortBuilder createSortBuilder(EsDataSort sorter) {
        LOG.info("createSortBuilder sorter=" + sorter);
        String sortField = this.indexMapping.getPreferredQueryFieldForSortOrAggregation(sorter.getProperty());
        return ((FieldSortBuilder)SortBuilders.fieldSort(sortField).order(SortOrder.valueOf(sorter.getDirection()))).unmappedType("keyword");
    }
}

