/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.identityManagement;

import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.User;
import de.virtimo.bpc.api.identityManagement.IdentityManager;
import de.virtimo.bpc.api.identityManagement.IdentityManagerException;
import de.virtimo.bpc.api.identityManagement.IdentityManagerUnsupportedOperationException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IdentityManagerPlaceholder
implements IdentityManager {
    private static final Logger LOG = Logger.getLogger(IdentityManagerPlaceholder.class.getName());
    private static IdentityManagerPlaceholder instance = null;

    private IdentityManagerPlaceholder() {
    }

    public static IdentityManagerPlaceholder getInstance() {
        LOG.log(Level.FINEST, "getInstance");
        if (instance == null) {
            instance = new IdentityManagerPlaceholder();
        }
        return instance;
    }

    public static void destroySingleton() {
        instance = null;
    }

    @Override
    public void destroy() {
        LOG.log(Level.FINEST, "destroy");
    }

    @Override
    public User getUser(String userId) throws IdentityManagerException {
        LOG.log(Level.FINEST, "getUser");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USER_UNSUPPORTED");
    }

    @Override
    public List<User> getUsers() throws IdentityManagerException {
        LOG.log(Level.FINEST, "getUsers");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USERS_UNSUPPORTED");
    }

    @Override
    public Set<Organisation> getOrganisations() throws IdentityManagerException {
        LOG.log(Level.FINEST, "getOrganisations");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_ORGANISATIONS_UNSUPPORTED");
    }

    @Override
    public Set<Role> getRoles() throws IdentityManagerException {
        LOG.log(Level.FINEST, "getRoles");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_ROLES_UNSUPPORTED");
    }

    @Override
    public Set<Right> getRights() throws IdentityManagerException {
        LOG.log(Level.FINEST, "getRights");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_RIGHTS_UNSUPPORTED");
    }

    @Override
    public Set<Organisation> getUserOrganisations(String userId) throws IdentityManagerException {
        LOG.log(Level.FINEST, "getUserOrganisations");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ORGANISATIONS_UNSUPPORTED");
    }

    @Override
    public Set<Role> getUserRoles(String userId) throws IdentityManagerException {
        LOG.log(Level.FINEST, "getUserRoles");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ROLES_UNSUPPORTED");
    }

    @Override
    public Set<Right> getUserRights(String userId) throws IdentityManagerException {
        LOG.log(Level.FINEST, "getUserRights");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USER_RIGHTS_UNSUPPORTED");
    }

    @Override
    public void addUser(String userId, String userPassword) throws IdentityManagerException {
        LOG.log(Level.FINEST, "addUser");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_UNSUPPORTED");
    }

    @Override
    public void addUser(User user, String userPassword) throws IdentityManagerException {
        LOG.log(Level.FINEST, "addUser");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_UNSUPPORTED");
    }

    @Override
    public void addOrganisation(String userId, String orgName) throws IdentityManagerException {
        LOG.log(Level.FINEST, "addOrganisation");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_TO_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void addRole(String userId, String roleName) throws IdentityManagerException {
        LOG.log(Level.FINEST, "addRole");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_USER_UNSUPPORTED");
    }

    @Override
    public void addOrganisationRole(String orgName, String roleName) throws IdentityManagerException {
        LOG.log(Level.FINEST, "addOrganisationRole");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void addRight(String userId, String rightName) throws IdentityManagerException {
        LOG.log(Level.FINEST, "addRight");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_RIGHT_TO_USER_UNSUPPORTED");
    }

    @Override
    public void deleteUser(String userId) throws IdentityManagerException {
        LOG.log(Level.FINEST, "deleteUser");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_UNSUPPORTED");
    }

    @Override
    public void deleteOrganisation(String userId, String orgName) throws IdentityManagerException {
        LOG.log(Level.FINEST, "deleteOrganisation");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_FROM_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void deleteRole(String userId, String roleName) throws IdentityManagerException {
        LOG.log(Level.FINEST, "deleteRole");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_USER_UNSUPPORTED");
    }

    @Override
    public void deleteOrganisationRole(String orgName, String roleName) throws IdentityManagerException {
        LOG.log(Level.FINEST, "deleteOrganisationRole");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void deleteRight(String userId, String rightName) throws IdentityManagerException {
        LOG.log(Level.FINEST, "deleteRight");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_RIGHT_FROM_USER_UNSUPPORTED");
    }

    @Override
    public void updateUser(User user) throws IdentityManagerException {
        LOG.log(Level.FINEST, "updateUser");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_UNSUPPORTED");
    }

    @Override
    public void updateUserPassword(String userId, String userPassword) throws IdentityManagerException {
        LOG.log(Level.FINEST, "updateUserPassword");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD_UNSUPPORTED");
    }

    @Override
    public boolean checkUserPassword(String userId, String userPassword) throws IdentityManagerException {
        LOG.log(Level.FINEST, "checkUserPassword");
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_CHECK_USER_PASSWORD_UNSUPPORTED");
    }
}

