/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.service;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.es.BpcIndexInfo;
import de.virtimo.bpc.api.es.BpcIndexState;
import de.virtimo.bpc.api.es.IndexInfo;
import de.virtimo.bpc.api.es.ManagedIndicesHandler;
import de.virtimo.bpc.api.exception.ElasticsearchIndexMappingNotFoundException;
import de.virtimo.bpc.api.exception.ElasticsearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.tasks.TaskId;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.QueryBuilder;
import org.jetbrains.annotations.NotNull;

public interface ElasticsearchService
extends BpcService {
    public RestHighLevelClient getClient();

    public String getEsHost();

    public int getPort();

    public String getEsScheme();

    public String getEsVersion();

    public void setDefaultIndexCreationSettings(Map<String, ?> var1);

    public Map<String, ?> getDefaultIndexCreationSettings();

    public void setDefaultDynamicTemplates(List var1);

    public List getDefaultDynamicTemplates();

    public ManagedIndicesHandler getManagedIndicesHandler();

    public boolean hasIndexState(String var1);

    public BpcIndexState getIndexState(String var1);

    public boolean existsIndex(String var1) throws ElasticsearchRelatedException;

    public boolean createIndex(String var1) throws ElasticsearchRelatedException;

    public boolean createIndex(String var1, Map<String, ?> var2) throws ElasticsearchRelatedException;

    public String createIndex(String var1, Map<String, ?> var2, Map<String, Object> var3) throws ElasticsearchRelatedException;

    public String createIndex(String var1, String var2, Map<String, ?> var3, Map<String, Object> var4) throws ElasticsearchRelatedException;

    public Map<String, Object> getMapping(String var1);

    public MappingMetadata getMappingMetaData(String var1) throws ElasticsearchIndexMappingNotFoundException, ElasticsearchIndexNotFoundException, ElasticsearchRelatedException;

    public Map<String, Object> getSettings(String var1);

    public Map<String, String> getFieldsTypeMapping(String var1);

    public Set<String> getFieldNamesOfType(String var1, String var2);

    public boolean copyIndexMapping(String var1, String var2) throws ElasticsearchRelatedException;

    public boolean hasDynamicTemplatesMapping(String var1);

    public boolean hasDynamicTemplatesMapping(Map<String, Object> var1);

    public boolean deleteIndex(String var1) throws ElasticsearchRelatedException;

    public boolean closeIndex(String var1) throws ElasticsearchRelatedException;

    public boolean openIndex(String var1) throws ElasticsearchRelatedException;

    public String newIndexNameForAlias(String var1);

    public String aliasFromBpcIndexName(String var1);

    public long getCreationTimestampOfIndexName(String var1, String var2);

    public boolean addAliasToIndex(String var1, String var2) throws ElasticsearchRelatedException;

    public boolean moveAlias(String var1, String var2) throws ElasticsearchRelatedException;

    public boolean removeAlias(String var1, String var2) throws ElasticsearchRelatedException;

    @NotNull
    public Set<String> getAliasesOfAllIndices() throws ElasticsearchRelatedException;

    @NotNull
    public Set<String> getAliasesForIndexName(String var1) throws ElasticsearchRelatedException;

    @NotNull
    public Set<String> getIndexNamesWithAlias(String var1) throws ElasticsearchRelatedException;

    @NotNull
    public String getBpcIndexNameForAlias(String var1) throws ElasticsearchRelatedException;

    @NotNull
    public List<String> getAllIndexNamesWithPrefix(String var1) throws ElasticsearchRelatedException;

    @NotNull
    public List<String> getAllBpcIndexNamesWithAlias(String var1) throws ElasticsearchRelatedException;

    public void refreshIndices(String ... var1) throws ElasticsearchRelatedException;

    public void flushIndices(String ... var1) throws ElasticsearchRelatedException;

    public void reindex(String var1, String var2, QueryBuilder var3) throws ElasticsearchRelatedException;

    public void waitForTaskCompletionByPollingStatus(TaskId var1, long var2) throws ElasticsearchRelatedException;

    public Map<String, Object> getMetaDataValues(String var1);

    public boolean setMetaDataValues(String var1, Map<String, Object> var2) throws ElasticsearchRelatedException;

    public Object getMetaDataValue(String var1, String var2);

    public boolean setMetaDataValue(String var1, String var2, Object var3) throws ElasticsearchRelatedException;

    public boolean removeMetaDataValue(String var1, String var2) throws ElasticsearchRelatedException;

    public int getModelVersion(String var1);

    public boolean setModelVersion(String var1, int var2) throws ElasticsearchRelatedException;

    public boolean updateIndexSettings(String var1, Settings.Builder var2) throws ElasticsearchRelatedException;

    public boolean updateIndexMapping(String var1, Map<String, Object> var2) throws ElasticsearchRelatedException;

    @NotNull
    public Set<String> getTemplateNames() throws ElasticsearchRelatedException;

    @NotNull
    public Set<String> getTemplateNamesWithPrefix(String var1) throws ElasticsearchRelatedException;

    public boolean deleteTemplate(String var1) throws ElasticsearchRelatedException;

    public boolean createTemplate(String var1, Map<String, Object> var2) throws ElasticsearchRelatedException;

    public void prepareManagedIndices(Map<String, Object> var1) throws ElasticsearchRelatedException;

    public boolean releaseScrollId(SearchResponse var1);

    public boolean releaseScrollId(String var1);

    public Map<String, IndexInfo> getIndexInfos() throws ElasticsearchRelatedException;

    public boolean isOpen(String var1) throws ElasticsearchRelatedException;

    public boolean isClosed(String var1) throws ElasticsearchRelatedException;

    public boolean waitForElasticsearch(int var1, String[] var2) throws InterruptedException;

    public List<Map<String, Object>> getIndexCatalog() throws ElasticsearchRelatedException;

    public Map<String, Object> getFilesystemStats() throws ElasticsearchRelatedException;

    public List<Map<String, Object>> getInstalledPlugins() throws ElasticsearchRelatedException;

    public String getAttachmentsPipelineName(String var1);

    public void prepareAttachmentsPipeline(String var1) throws ElasticsearchRelatedException;

    public boolean existsAttachmentsPipeline(String var1) throws ElasticsearchRelatedException;

    public boolean deleteAttachmentsPipeline(String var1) throws ElasticsearchRelatedException;

    public String formatForElasticsearch(java.util.Date var1);

    public String formatForElasticsearch(Date var1);

    public String formatForElasticsearch(Timestamp var1);

    public String formatForElasticsearch(Instant var1);

    public boolean removeAllReadOnlyFlags() throws ElasticsearchRelatedException;

    public BpcIndexInfo getBpcIndexInfoUsingIndexName(String var1) throws ElasticsearchRelatedException;

    public BpcIndexInfo getBpcIndexInfoUsingIndexAlias(String var1) throws ElasticsearchRelatedException;
}

