/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import com.fasterxml.jackson.databind.type.TypeFactory;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.Checker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.auditlog.AuditLogService;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.deployment.DeploymentManager;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.identityManagement.IdentityManagerPlaceholder;
import de.virtimo.bpc.api.service.AutoCreateModuleInstancesService;
import de.virtimo.bpc.api.service.BomCollectorService;
import de.virtimo.bpc.api.service.CoreBundleService;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.ExtElasticsearchService;
import de.virtimo.bpc.api.service.FlowService;
import de.virtimo.bpc.api.service.HttpProxyService;
import de.virtimo.bpc.api.service.InternationalizationService;
import de.virtimo.bpc.api.service.ReplicationInfoService;
import de.virtimo.bpc.backendconnections.BackendConnectionsModule;
import de.virtimo.bpc.core.BasicAuthHttpContext;
import de.virtimo.bpc.core.CoreBundleConfigurationImpl;
import de.virtimo.bpc.core.CoreBundleServiceImpl;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.PrometheusExports;
import de.virtimo.bpc.core.ViewConfigurationValidator;
import de.virtimo.bpc.core.auditlog.AuditLogServiceImpl;
import de.virtimo.bpc.core.auditlog.ElasticsearchAuditLogger;
import de.virtimo.bpc.core.auth.ClientSessionManagerImpl;
import de.virtimo.bpc.core.auth.ClientSessionsChecker;
import de.virtimo.bpc.core.auth.ClientSessionsEventFilter;
import de.virtimo.bpc.core.auth.ClientSessionsMetricsCollector;
import de.virtimo.bpc.core.auth.CsrfTokenService;
import de.virtimo.bpc.core.auth.CsrfTokenServiceImpl;
import de.virtimo.bpc.core.auth.IdentityProviderBackendConnectionValidator;
import de.virtimo.bpc.core.auth.IdentityProviderConnectionTester;
import de.virtimo.bpc.core.auth.IdentityProviderInstanceType;
import de.virtimo.bpc.core.auth.IdentityProviderSettingsValidator;
import de.virtimo.bpc.core.auth.IpPinningService;
import de.virtimo.bpc.core.auth.IpPinningServiceImpl;
import de.virtimo.bpc.core.autocreate.AutoCreateModuleInstancesServiceImpl;
import de.virtimo.bpc.core.backup.BackupManagerImpl;
import de.virtimo.bpc.core.bom.BomCollectorServiceImpl;
import de.virtimo.bpc.core.datalock.DataLockService;
import de.virtimo.bpc.core.datalock.DataLockServiceImpl;
import de.virtimo.bpc.core.db.DataSourceConnectionTester;
import de.virtimo.bpc.core.db.DataSourceInstanceType;
import de.virtimo.bpc.core.db.DataSourcesSettingValidator;
import de.virtimo.bpc.core.db.DatabaseManagerImpl;
import de.virtimo.bpc.core.deployment.DeploymentImporter;
import de.virtimo.bpc.core.deployment.DeploymentManagerImpl;
import de.virtimo.bpc.core.deployment.DeploymentSystemConnectionTester;
import de.virtimo.bpc.core.deployment.DeploymentSystemInstanceType;
import de.virtimo.bpc.core.deployment.DeploymentSystemSettingsValidator;
import de.virtimo.bpc.core.es.ModuleManagerImpl;
import de.virtimo.bpc.core.es.PasswordEncryptorService;
import de.virtimo.bpc.core.es.PasswordEncryptorServiceImpl;
import de.virtimo.bpc.core.es.migration.BpcIndicesMigrator;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginEventFilter;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginManager;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginManagerImpl;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.fewrapper.FeWrapperService;
import de.virtimo.bpc.core.fewrapper.FeWrapperServiceImpl;
import de.virtimo.bpc.core.httpproxy.HttpProxyConnectionTester;
import de.virtimo.bpc.core.httpproxy.HttpProxyInstanceType;
import de.virtimo.bpc.core.httpproxy.HttpProxyServiceImpl;
import de.virtimo.bpc.core.internationalization.InternationalizationServiceImpl;
import de.virtimo.bpc.core.license.LicenseChecker;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.license.LicenseServiceImpl;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsManager;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsManagerImpl;
import de.virtimo.bpc.core.notification.NotificationManager;
import de.virtimo.bpc.core.notification.NotificationManagerImpl;
import de.virtimo.bpc.core.paxjdbc.PaxJdbcFeaturesInstaller;
import de.virtimo.bpc.core.percolators.PercolatorsChecker;
import de.virtimo.bpc.core.percolators.PercolatorsManagerImpl;
import de.virtimo.bpc.core.performance.PerformanceMeasurementManager;
import de.virtimo.bpc.core.performance.PerformanceMeasurementManagerImpl;
import de.virtimo.bpc.core.replicator.ElasticsearchSettingsValidator;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.core.replicator.ReplicationManagerImpl;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import de.virtimo.bpc.core.replicator.ReplicationModuleInstanceSettingValidator;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobsLogService;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobsLogServiceImpl;
import de.virtimo.bpc.core.resource.BpcNewCookieHeaderProvider;
import de.virtimo.bpc.core.service.CoreModuleUpdatedEventFilter;
import de.virtimo.bpc.core.service.ElasticsearchServiceImpl;
import de.virtimo.bpc.core.service.ErrorResponseServiceImpl;
import de.virtimo.bpc.core.service.EventManagerImpl;
import de.virtimo.bpc.core.service.ExtElasticsearchServiceImpl;
import de.virtimo.bpc.core.service.IndexCleanupService;
import de.virtimo.bpc.core.service.IndexCleanupServiceImpl;
import de.virtimo.bpc.core.service.MaintenanceModeAcknowledgedEventFilter;
import de.virtimo.bpc.core.service.MetricsService;
import de.virtimo.bpc.core.service.MetricsServiceImpl;
import de.virtimo.bpc.core.service.ReplicationInfoServiceImpl;
import de.virtimo.bpc.core.websocket.BpcWebsocketServlet;
import de.virtimo.bpc.externalContent.ExternalContentModule;
import de.virtimo.bpc.flow.FlowConnectionTester;
import de.virtimo.bpc.flow.FlowModule;
import de.virtimo.bpc.flow.FlowServiceImpl;
import de.virtimo.bpc.htmlContent.HtmlContentModule;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstanceSettingsValidator;
import de.virtimo.bpc.module.DefaultModuleConfigurations;
import de.virtimo.bpc.util.BpcTrustStore;
import de.virtimo.bpc.util.ObjectMapperPool;
import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.client.hotspot.DefaultExports;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class BpcActivator
implements BundleActivator {
    private static final Logger LOG = Logger.getLogger(BpcActivator.class.getName());
    private BundleContext bundleContext;
    private PercolatorsChecker percolatorsChecker;
    private ClientSessionsChecker clientSessionsChecker;
    private LicenseChecker licenseChecker;
    private DeploymentImporter deploymentImporter;
    private ServiceRegistration<DatabaseManager> databaseManagerRegistration;
    private ServiceRegistration<BackupManager> backupManagerRegistration;
    private ServiceRegistration<FeWrapperService> feModuleWrapperRegistration;
    private ServiceRegistration<EventManager> eventManagerRegistration;
    private ServiceRegistration<ElasticsearchService> elasticsearchServiceRegistration;
    private ServiceRegistration<ElasticsearchBpcPluginManager> elasticsearchBpcPluginManagerRegistration;
    private ServiceRegistration<PasswordEncryptorService> passwordEncryptorServiceRegistration;
    private ServiceRegistration<ModuleManager> moduleManagerRegistration;
    private ServiceRegistration<ClientSessionManager> clientSessionManagerRegistration;
    private ServiceRegistration<ReplicationInfoService> replicationInfoServiceRegistration;
    private ServiceRegistration<CoreBundleConfiguration> coreBundleConfigurationRegistration;
    private ServiceRegistration<AuditLogService> auditLogServiceRegistration;
    private ServiceRegistration<PercolatorsManager> percolatorsManagerRegistration;
    private ServiceRegistration<ReplicationManager> replicationManagerRegistration;
    private ServiceRegistration<LookupJoinsManager> lookupJoinsManagerRegistration;
    private ServiceRegistration<CoreBundleService> coreBundleServiceRegistration;
    private ServiceRegistration<DeploymentManager> deploymentManagerRegistration;
    private ServiceRegistration<PerformanceMeasurementManager> performanceMeasurementManagerRegistration;
    private ServiceRegistration<AutoCreateModuleInstancesService> autoCreateModuleInstancesServiceRegistration;
    private ServiceRegistration<ReplicationJobsLogService> replicationJobsLogServiceRegistration;
    private ServiceRegistration<LicenseService> licenseServiceRegistration;
    private ServiceRegistration<HttpProxyService> httpProxyServiceRegistration;
    private ServiceRegistration<MetricsService> metricsServiceRegistration;
    private ServiceRegistration<IndexCleanupService> indexCleanupServiceRegistration;
    private ServiceRegistration<InternationalizationService> internationalizationServiceRegistration;
    private ServiceRegistration<NotificationManager> notificationManagerRegistration;
    private ServiceRegistration<ErrorResponseService> errorResponseServiceRegistration;
    private ServiceRegistration<FlowService> flowServiceRegistration;
    private ServiceRegistration<BomCollectorService> bomCollectorServiceRegistration;
    private ServiceRegistration<DataLockService> dataLockServiceRegistration;
    private ServiceRegistration<ExtElasticsearchService> extElasticsearchServiceRegistration;
    private ServiceRegistration<IpPinningService> ipPinningServiceRegistration;
    private ServiceRegistration<CsrfTokenService> csrfTokenServiceRegistration;
    private ServiceTracker<HttpService, HttpService> httpServiceTracker;
    private PaxJdbcFeaturesInstaller paxJdbcFeaturesInstaller;

    public BpcActivator() {
        LOG.info("********** BpcActivator **********");
        System.setProperty("io.netty.allocator.type", "unpooled");
        BpcNewCookieHeaderProvider.setAsUglyWorkaround();
    }

    public void start(final BundleContext bundleContext) throws Exception {
        LOG.info(bundleContext.getBundle().getSymbolicName() + ": START (" + bundleContext + ")");
        try {
            long startTimestamp = System.currentTimeMillis();
            this.bundleContext = bundleContext;
            this.paxJdbcFeaturesInstaller = new PaxJdbcFeaturesInstaller(bundleContext);
            LOG.info("Registering DatabaseManager START");
            this.databaseManagerRegistration = bundleContext.registerService(DatabaseManager.class, (Object)new DatabaseManagerImpl(bundleContext), null);
            LOG.info("Registering DatabaseManager DONE");
            LOG.info("Registering CoreBundleConfiguration START");
            final CoreBundleConfigurationImpl coreBundleConfiguration = new CoreBundleConfigurationImpl(bundleContext);
            this.coreBundleConfigurationRegistration = bundleContext.registerService(CoreBundleConfiguration.class, (Object)coreBundleConfiguration, null);
            LOG.info("Version: " + coreBundleConfiguration.getCoreVersion());
            LOG.info("Registering CoreBundleConfiguration DONE");
            LOG.info("Registering CoreBundleService START");
            this.coreBundleServiceRegistration = bundleContext.registerService(CoreBundleService.class, (Object)new CoreBundleServiceImpl(bundleContext), null);
            LOG.info("Registering CoreBundleService DONE");
            LOG.info("Registering EventManager START");
            this.eventManagerRegistration = bundleContext.registerService(EventManager.class, (Object)new EventManagerImpl(bundleContext, coreBundleConfiguration.getServerUUID()), null);
            LOG.info("Registering EventManager DONE");
            LOG.info("Registering Elasticsearch Service START");
            ElasticsearchServiceImpl elasticsearchService = new ElasticsearchServiceImpl(bundleContext, coreBundleConfiguration);
            this.elasticsearchServiceRegistration = bundleContext.registerService(ElasticsearchService.class, (Object)elasticsearchService, null);
            LOG.info("Registering Elasticsearch Service DONE");
            LOG.info("Waiting for Elasticsearch to be in an ready state ...");
            if (!elasticsearchService.waitForElasticsearch(30, null)) {
                LOG.log(Level.SEVERE, "Elasticsearch is not available. Please get it up and running, then restart Karaf or just the bpc-be-core bundle.");
                throw new Exception("Elasticsearch is not available. Please get it up and running, then restart Karaf or just the bpc-be-core bundle.");
            }
            LOG.info("Finished waiting for Elasticsearch");
            if (elasticsearchService.existsIndex("bpc-configuration")) {
                LOG.info("Waiting for 'bpc-configuration' index to be in an ready state ...");
                if (!elasticsearchService.waitForElasticsearch(30, new String[]{"bpc-configuration"})) {
                    LOG.log(Level.SEVERE, "Elasticsearch 'bpc-configuration' index is not available. Please get it up and running, then restart Karaf or just the bpc-be-core bundle.");
                    throw new Exception("Elasticsearch 'bpc-configuration' index is not available. Please get it up and running, then restart Karaf or just the bpc-be-core bundle.");
                }
                LOG.info("Finished waiting for 'bpc-configuration' index");
            }
            LOG.info("Migrating Elasticsearch Indices START");
            try {
                BpcIndicesMigrator indicesMigrator = new BpcIndicesMigrator(elasticsearchService);
                indicesMigrator.migrateBpcConfigurationIndex();
                indicesMigrator.migrateBpcNotificationIndex();
            }
            catch (IndexMigrationException ex) {
                if (ex.isErrorCode(CoreErrorCode.INDEX_MIGRATION_NOT_ALLOWED_VERSION)) {
                    LOG.log(Level.SEVERE, "Starting BPC core failed: " + ex.getLocalizedMessage());
                    throw ex;
                }
                LOG.log(Level.SEVERE, "Could not migrate the indices.", ex);
            }
            LOG.info("Migrating Elasticsearch Indices DONE");
            LOG.info("Registering ErrorResponseService START");
            this.errorResponseServiceRegistration = bundleContext.registerService(ErrorResponseService.class, (Object)new ErrorResponseServiceImpl(bundleContext), null);
            LOG.info("Registering ErrorResponseService DONE");
            LOG.info("Registering InternationalizationService START");
            this.internationalizationServiceRegistration = bundleContext.registerService(InternationalizationService.class, (Object)new InternationalizationServiceImpl(bundleContext), null);
            LOG.info("Registering InternationalizationService DONE");
            LOG.info("Registering BomCollectorService START");
            this.bomCollectorServiceRegistration = bundleContext.registerService(BomCollectorService.class, (Object)new BomCollectorServiceImpl(bundleContext), null);
            LOG.info("Registering BomCollectorService DONE");
            LOG.info("Registering NotificationManager START");
            this.notificationManagerRegistration = bundleContext.registerService(NotificationManager.class, (Object)new NotificationManagerImpl(bundleContext), null);
            LOG.info("Registering NotificationManager DONE");
            LOG.info("Registering license service START");
            this.licenseServiceRegistration = bundleContext.registerService(LicenseService.class, (Object)new LicenseServiceImpl(bundleContext), null);
            LOG.info("Registering license service DONE");
            LOG.info("Registering the IndexCleanupService START");
            this.indexCleanupServiceRegistration = bundleContext.registerService(IndexCleanupService.class, (Object)new IndexCleanupServiceImpl(bundleContext), null);
            LOG.info("Registering the IndexCleanupService DONE");
            LOG.info("Registering percolators manager START");
            this.percolatorsManagerRegistration = bundleContext.registerService(PercolatorsManager.class, (Object)new PercolatorsManagerImpl(bundleContext, coreBundleConfiguration.getServerUUID()), null);
            LOG.info("Registering percolators manager DONE");
            LOG.info("Registering LookupJoinsManager START");
            this.lookupJoinsManagerRegistration = bundleContext.registerService(LookupJoinsManager.class, (Object)new LookupJoinsManagerImpl(bundleContext), null);
            LOG.info("Registering LookupJoinsManager DONE");
            LOG.info("Registering DeploymentManager START");
            this.deploymentManagerRegistration = bundleContext.registerService(DeploymentManager.class, (Object)new DeploymentManagerImpl(bundleContext), null);
            LOG.info("Registering DeploymentManager DONE");
            LOG.info("Registering ReplicationJobsLogService START");
            this.replicationJobsLogServiceRegistration = bundleContext.registerService(ReplicationJobsLogService.class, (Object)new ReplicationJobsLogServiceImpl(bundleContext), null);
            LOG.info("Registering ReplicationJobsLogService DONE");
            LOG.info("Registering ReplicationManager START");
            this.replicationManagerRegistration = bundleContext.registerService(ReplicationManager.class, (Object)new ReplicationManagerImpl(bundleContext), null);
            LOG.info("Registering ReplicationManager DONE");
            LOG.info("Registering PerformanceMeasurementManager START");
            this.performanceMeasurementManagerRegistration = bundleContext.registerService(PerformanceMeasurementManager.class, (Object)new PerformanceMeasurementManagerImpl(bundleContext, coreBundleConfiguration), null);
            LOG.info("Registering PerformanceMeasurementManager DONE");
            LOG.info("Registering BackupManager START");
            this.backupManagerRegistration = bundleContext.registerService(BackupManager.class, (Object)new BackupManagerImpl(bundleContext), null);
            LOG.info("Registering BackupManager DONE");
            LOG.info("Registering AuditLogService START");
            AuditLogServiceImpl auditLogService = new AuditLogServiceImpl(bundleContext, coreBundleConfiguration);
            auditLogService.setAuditLogger(new ElasticsearchAuditLogger(bundleContext, coreBundleConfiguration));
            this.auditLogServiceRegistration = bundleContext.registerService(AuditLogService.class, (Object)auditLogService, null);
            LOG.info("Registering AuditLogService DONE");
            LOG.info("Registering PasswordEncryptorService START");
            this.passwordEncryptorServiceRegistration = bundleContext.registerService(PasswordEncryptorService.class, (Object)new PasswordEncryptorServiceImpl(bundleContext), null);
            LOG.info("Registering PasswordEncryptorService DONE");
            LOG.info("Registering the ExtElasticsearchService START");
            this.extElasticsearchServiceRegistration = bundleContext.registerService(ExtElasticsearchService.class, (Object)new ExtElasticsearchServiceImpl(bundleContext), null);
            LOG.info("Registering the ExtElasticsearchService DONE");
            LOG.info("Registering ModuleManager START");
            ModuleManagerImpl moduleManager = new ModuleManagerImpl(bundleContext);
            moduleManager.setSettingValidator(new DataSourcesSettingValidator(bundleContext));
            moduleManager.setSettingValidator(new ReplicationModuleInstanceSettingValidator(bundleContext));
            moduleManager.setSettingValidator(new LogServiceModuleInstanceSettingsValidator(bundleContext));
            moduleManager.setSettingValidator(new DeploymentSystemSettingsValidator(bundleContext));
            moduleManager.setSettingValidator(new ElasticsearchSettingsValidator(bundleContext));
            moduleManager.setSettingValidator(new ViewConfigurationValidator());
            moduleManager.setSettingValidator(new IdentityProviderSettingsValidator(bundleContext));
            moduleManager.setSettingValidator(new IdentityProviderBackendConnectionValidator(bundleContext));
            moduleManager.setConnectionTester(new DeploymentSystemConnectionTester());
            moduleManager.setConnectionTester(new DataSourceConnectionTester(bundleContext));
            moduleManager.setConnectionTester(new IdentityProviderConnectionTester(bundleContext));
            moduleManager.setConnectionTester(new HttpProxyConnectionTester(bundleContext));
            moduleManager.setConnectionTester(new FlowConnectionTester(bundleContext));
            this.moduleManagerRegistration = bundleContext.registerService(ModuleManager.class, (Object)moduleManager, null);
            LOG.info("Registering ModuleManager DONE");
            LOG.info("Registering AutoCreateModuleInstances START");
            this.autoCreateModuleInstancesServiceRegistration = bundleContext.registerService(AutoCreateModuleInstancesService.class, (Object)new AutoCreateModuleInstancesServiceImpl(bundleContext), null);
            LOG.info("Registering AutoCreateModuleInstances DONE");
            LOG.info("Init/register ModuleManager");
            try {
                LOG.info("Loading core module ...");
                CoreModule coreModule = new CoreModule(moduleManager, bundleContext.getBundle());
                moduleManager.loadModule(coreModule);
                elasticsearchService.setDefaultIndexCreationSettings(coreModule.getConfiguration().getSettingValue("indexCreationSettings").asMap(null));
                elasticsearchService.setDefaultDynamicTemplates(coreModule.getConfiguration().getSettingValue("indexDynamicTemplates").asList(null));
                LOG.info("Loading backend connections module ...");
                BackendConnectionsModule backendConnectionsModule = new BackendConnectionsModule(moduleManager);
                backendConnectionsModule.setModuleBundle(bundleContext.getBundle());
                backendConnectionsModule.setAsSupportedInstanceType(new HttpProxyInstanceType());
                backendConnectionsModule.setAsSupportedInstanceType(new DeploymentSystemInstanceType());
                backendConnectionsModule.setAsSupportedInstanceType(new DataSourceInstanceType());
                backendConnectionsModule.setAsSupportedInstanceType(new IdentityProviderInstanceType());
                moduleManager.loadModule(backendConnectionsModule);
                LOG.info("Loading replication module ...");
                ReplicationModule replicationModule = new ReplicationModule(moduleManager);
                replicationModule.setModuleBundle(bundleContext.getBundle());
                moduleManager.loadModule(replicationModule);
                LOG.info("Loading log service module ...");
                LogServiceModule logServiceModule = new LogServiceModule(moduleManager);
                logServiceModule.setModuleBundle(bundleContext.getBundle());
                moduleManager.loadModule(logServiceModule);
                LOG.info("Loading external content module ...");
                ExternalContentModule externalContentModule = new ExternalContentModule(moduleManager);
                externalContentModule.setModuleBundle(bundleContext.getBundle());
                moduleManager.loadModule(externalContentModule);
                LOG.info("Loading HTML content module ...");
                HtmlContentModule htmlContentModule = new HtmlContentModule(moduleManager);
                htmlContentModule.setModuleBundle(bundleContext.getBundle());
                moduleManager.loadModule(htmlContentModule);
                LOG.info("Loading Flow module ...");
                FlowModule flowModule = new FlowModule(moduleManager);
                flowModule.setModuleBundle(bundleContext.getBundle());
                moduleManager.loadModule(flowModule);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Please STOP Me!", e);
                throw e;
            }
            LOG.info("Registering IpPinningService START");
            this.ipPinningServiceRegistration = bundleContext.registerService(IpPinningService.class, (Object)new IpPinningServiceImpl(bundleContext), null);
            LOG.info("Registering IpPinningService DONE");
            LOG.info("Registering CsrfTokenService START");
            this.csrfTokenServiceRegistration = bundleContext.registerService(CsrfTokenService.class, (Object)new CsrfTokenServiceImpl(bundleContext), null);
            LOG.info("Registering CsrfTokenService DONE");
            LOG.info("Registering DataLockService START");
            this.dataLockServiceRegistration = bundleContext.registerService(DataLockService.class, (Object)new DataLockServiceImpl(bundleContext), null);
            LOG.info("Registering DataLockService DONE");
            LOG.info("Registering ReplicationInfoService START");
            this.replicationInfoServiceRegistration = bundleContext.registerService(ReplicationInfoService.class, (Object)new ReplicationInfoServiceImpl(bundleContext), null);
            LOG.info("Registering ReplicationInfoService DONE");
            LOG.info("Registering the HttpProxyService START");
            this.httpProxyServiceRegistration = bundleContext.registerService(HttpProxyService.class, (Object)new HttpProxyServiceImpl(bundleContext), null);
            LOG.info("Registering the HttpProxyService DONE");
            LOG.info("Registering the FlowService START");
            this.flowServiceRegistration = bundleContext.registerService(FlowService.class, (Object)new FlowServiceImpl(bundleContext), null);
            LOG.info("Registering the FlowService DONE");
            LOG.info("Starting LicenseChecker");
            this.licenseChecker = new LicenseChecker(bundleContext);
            this.licenseChecker.startChecker();
            LOG.info("Starting LicenseChecker DONE");
            LOG.info("Starting DeploymentImporter");
            this.deploymentImporter = new DeploymentImporter(bundleContext);
            this.deploymentImporter.startChecker();
            LOG.info("Starting DeploymentImporter DONE");
            LOG.info("Registering ClientSessionManager START");
            ClientSessionManagerImpl clientSessionManager = new ClientSessionManagerImpl(bundleContext, moduleManager);
            clientSessionManager.addBlacklistEventFilter(new CoreModuleUpdatedEventFilter());
            clientSessionManager.addBlacklistEventFilter(new ElasticsearchBpcPluginEventFilter());
            clientSessionManager.addBlacklistEventFilter(new ClientSessionsEventFilter());
            clientSessionManager.addBlacklistEventFilter(new MaintenanceModeAcknowledgedEventFilter());
            this.clientSessionManagerRegistration = bundleContext.registerService(ClientSessionManager.class, (Object)clientSessionManager, new Hashtable());
            LOG.info("Registering ClientSessionManager DONE");
            LOG.info("Starting ClientSessionsChecker");
            this.clientSessionsChecker = new ClientSessionsChecker(bundleContext);
            this.clientSessionsChecker.startChecker();
            LOG.info("Starting ClientSessionsChecker DONE");
            LOG.info("Registering the Elasticsearch BPC Plugin Manager START");
            this.elasticsearchBpcPluginManagerRegistration = bundleContext.registerService(ElasticsearchBpcPluginManager.class, (Object)new ElasticsearchBpcPluginManagerImpl(bundleContext, coreBundleConfiguration), null);
            LOG.info("Registering the Elasticsearch BPC Plugin Manager DONE");
            LOG.info("Registering the MetricsService START");
            MetricsServiceImpl metricsService = new MetricsServiceImpl(bundleContext);
            metricsService.registerCollector("sessions", new ClientSessionsMetricsCollector(bundleContext), TimeUnit.MINUTES.toSeconds(5L));
            this.metricsServiceRegistration = bundleContext.registerService(MetricsService.class, (Object)metricsService, null);
            LOG.info("Registering the MetricsService DONE");
            DefaultExports.initialize();
            PrometheusExports.register(bundleContext);
            this.httpServiceTracker = new ServiceTracker<HttpService, HttpService>(bundleContext, HttpService.class.getName(), null){

                public HttpService addingService(ServiceReference<HttpService> ref) {
                    HttpService httpService = (HttpService)bundleContext.getService(ref);
                    LOG.info("Registering WebsocketServlet START");
                    try {
                        httpService.registerServlet("/websocket", (Servlet)new BpcWebsocketServlet(bundleContext), null, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    LOG.info("Registering WebsocketServlet DONE");
                    LOG.info("Registering Prometheus Metrics Servlet START");
                    try {
                        String metricsBasicAuthUsername = coreBundleConfiguration.getSystemPropertyValueAsString("de.virtimo.bpc.metrics.basic_auth.username", "virtimo");
                        String metricsBasicAuthPassword = coreBundleConfiguration.getSystemPropertyValueAsString("de.virtimo.bpc.metrics.basic_auth.password", "HQucFPZgFzpDB3VQu8");
                        BasicAuthHttpContext basicAuthCheckContext = new BasicAuthHttpContext(metricsBasicAuthUsername, metricsBasicAuthPassword);
                        httpService.registerServlet("/metrics", (Servlet)new MetricsServlet(), null, (HttpContext)basicAuthCheckContext);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    LOG.info("Registering Prometheus Metrics Servlet DONE");
                    return httpService;
                }

                public void removedService(ServiceReference<HttpService> ref, HttpService httpService) {
                    try {
                        httpService.unregister("/metrics");
                        httpService.unregister("/websocket");
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            this.httpServiceTracker.open();
            LOG.info("Starting PercolatorsChecker");
            this.percolatorsChecker = new PercolatorsChecker(bundleContext);
            this.percolatorsChecker.startChecker();
            LOG.info("Starting PercolatorsChecker DONE");
            LOG.info("Registering FeWrapperService START");
            this.feModuleWrapperRegistration = bundleContext.registerService(FeWrapperService.class, (Object)new FeWrapperServiceImpl(bundleContext), null);
            LOG.info("Registering FeWrapperService DONE");
            LOG.info(bundleContext.getBundle().getSymbolicName() + ": STARTED in " + TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTimestamp) + " seconds");
        }
        catch (Throwable t) {
            this.cleanup(bundleContext);
            throw t;
        }
    }

    public void stop(BundleContext bundleContext) {
        LOG.info(bundleContext.getBundle().getSymbolicName() + ": STOP (" + bundleContext + ")");
        this.cleanup(bundleContext);
        LOG.info(bundleContext.getBundle().getSymbolicName() + ": STOPPED");
    }

    private void cleanup(BundleContext bundleContext) {
        LOG.info("cleanup bundleContext=" + bundleContext);
        Checker.stop(this.deploymentImporter);
        Checker.stop(this.percolatorsChecker);
        Checker.stop(this.clientSessionsChecker);
        Checker.stop(this.licenseChecker);
        this.paxJdbcFeaturesInstaller.destroy();
        LOG.info("Unregistering the BPC specific Prometheus exports");
        PrometheusExports.unregister();
        try {
            this.httpServiceTracker.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BpcService.unregister(bundleContext, this.extElasticsearchServiceRegistration, ExtElasticsearchService.class);
        BpcService.unregister(bundleContext, this.metricsServiceRegistration, MetricsService.class);
        BpcService.unregister(bundleContext, this.performanceMeasurementManagerRegistration, PerformanceMeasurementManager.class);
        BpcService.unregister(bundleContext, this.deploymentManagerRegistration, DeploymentManager.class);
        BpcService.unregister(bundleContext, this.bomCollectorServiceRegistration, BomCollectorService.class);
        BpcService.unregister(bundleContext, this.internationalizationServiceRegistration, InternationalizationService.class);
        BpcService.unregister(bundleContext, this.notificationManagerRegistration, NotificationManager.class);
        BpcService.unregister(bundleContext, this.autoCreateModuleInstancesServiceRegistration, AutoCreateModuleInstancesService.class);
        BpcService.unregister(bundleContext, this.elasticsearchBpcPluginManagerRegistration, ElasticsearchBpcPluginManager.class);
        BpcService.unregister(bundleContext, this.flowServiceRegistration, FlowService.class);
        BpcService.unregister(bundleContext, this.httpProxyServiceRegistration, HttpProxyService.class);
        BpcService.unregister(bundleContext, this.replicationInfoServiceRegistration, ReplicationInfoService.class);
        BpcService.unregister(bundleContext, this.replicationJobsLogServiceRegistration, ReplicationJobsLogService.class);
        BpcService.unregister(bundleContext, this.percolatorsManagerRegistration, PercolatorsManager.class);
        BpcService.unregister(bundleContext, this.clientSessionManagerRegistration, ClientSessionManager.class);
        BpcService.unregister(bundleContext, this.lookupJoinsManagerRegistration, LookupJoinsManager.class);
        BpcService.unregister(bundleContext, this.replicationManagerRegistration, ReplicationManager.class);
        BpcService.unregister(bundleContext, this.moduleManagerRegistration, ModuleManager.class);
        BpcService.unregister(bundleContext, this.passwordEncryptorServiceRegistration, PasswordEncryptorService.class);
        BpcService.unregister(bundleContext, this.auditLogServiceRegistration, AuditLogService.class);
        BpcService.unregister(bundleContext, this.backupManagerRegistration, BackupManager.class);
        BpcService.unregister(bundleContext, this.feModuleWrapperRegistration, FeWrapperService.class);
        BpcService.unregister(bundleContext, this.eventManagerRegistration, EventManager.class);
        BpcService.unregister(bundleContext, this.indexCleanupServiceRegistration, IndexCleanupService.class);
        BpcService.unregister(bundleContext, this.dataLockServiceRegistration, DataLockService.class);
        BpcService.unregister(bundleContext, this.ipPinningServiceRegistration, IpPinningService.class);
        BpcService.unregister(bundleContext, this.csrfTokenServiceRegistration, CsrfTokenService.class);
        BpcService.unregister(bundleContext, this.elasticsearchServiceRegistration, ElasticsearchService.class);
        BpcService.unregister(bundleContext, this.databaseManagerRegistration, DatabaseManager.class);
        BpcService.unregister(bundleContext, this.coreBundleServiceRegistration, CoreBundleService.class);
        BpcService.unregister(bundleContext, this.coreBundleConfigurationRegistration, CoreBundleConfiguration.class);
        BpcService.unregister(bundleContext, this.licenseServiceRegistration, LicenseService.class);
        BpcService.unregister(bundleContext, this.errorResponseServiceRegistration, ErrorResponseService.class);
        ObjectMapperPool.destroySingleton();
        DefaultModuleConfigurations.destroySingleton();
        BpcTrustStore.destroySingleton();
        IdentityManagerPlaceholder.destroySingleton();
        BpcNewCookieHeaderProvider.removeUglyWorkaround();
        TypeFactory.defaultInstance().clearCache();
    }
}

