/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.auth.idp.UserFlowIdentityProvider;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.exception.UserFlowIdentityProviderResponseException;
import de.virtimo.bpc.api.response.BpcTheme;
import de.virtimo.bpc.api.service.CoreBundleService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.core.resource.response.BpcThemeImpl;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.UriQueryUtil;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CoreBundleServiceImpl
implements CoreBundleService,
BpcService {
    private static final Logger LOG = Logger.getLogger(CoreBundleServiceImpl.class.getName());
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ReplicationManager> replicationManagerTracker;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private final BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private final EventRegistration eventRegistration;
    private CoreModule coreModule;

    public CoreBundleServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(bundleContext, ReplicationManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(bundleContext, ClientSessionManager.class);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forBackendModuleLoadedEvents("_core", new CoreModuleLoadedEvent());
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
        this.coreModule = null;
    }

    private CoreModule getCoreModule() throws ModuleNotFoundException {
        if (this.coreModule == null) {
            throw new ModuleNotFoundException("_core");
        }
        return this.coreModule;
    }

    @Override
    public String getServerUUID() throws ServiceNotFoundException {
        return this.coreBundleConfigurationTracker.getService().getServerUUID();
    }

    @Override
    public boolean isMaster() throws ServiceNotFoundException {
        return this.replicationManagerTracker.getService().isReplicationEnabled();
    }

    @Override
    public boolean isSlave() throws ServiceNotFoundException {
        return !this.replicationManagerTracker.getService().isReplicationEnabled();
    }

    @Override
    public boolean isMaintenanceModeEnabled() throws ServiceNotFoundException {
        return this.coreBundleConfigurationTracker.getService().isMaintenanceModeEnabled();
    }

    @Override
    public boolean hasValidUserSession(HttpServletRequest servletRequest) throws ServiceNotFoundException {
        LOG.info("hasValidUserSession servletRequest=" + servletRequest);
        String sessionId = this.clientSessionManagerTracker.getService().getSessionId(servletRequest);
        return sessionId != null && this.clientSessionManagerTracker.getService().existsSession(sessionId);
    }

    @Override
    public boolean isUserFlowIdentityProviderCallback(HttpServletRequest servletRequest) throws UserFlowIdentityProviderResponseException {
        LOG.info("isUserFlowIdentityProviderCallback servletRequest=" + servletRequest);
        try {
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (identityProvider instanceof UserFlowIdentityProvider) {
                UserFlowIdentityProvider userFlowIdentityProvider = (UserFlowIdentityProvider)identityProvider;
                URI postAuthenticationRedirectURI = userFlowIdentityProvider.getPostAuthenticationRedirectUri(servletRequest.getRequestURL().toString());
                Map<String, String> postAuthenticationRedirectURIQueryParams = UriQueryUtil.getQueryParams(postAuthenticationRedirectURI);
                ArrayList parameterNamesList = Collections.list(servletRequest.getParameterNames());
                parameterNamesList.remove("theme");
                parameterNamesList.remove("language");
                if (parameterNamesList.size() >= 2 && parameterNamesList.containsAll(Arrays.asList("error", "state"))) {
                    throw new UserFlowIdentityProviderResponseException(servletRequest.getParameter("error"), servletRequest.getParameter("error_description"), servletRequest.getParameter("error_uri"), servletRequest.getParameter("state"));
                }
                if (parameterNamesList.size() >= postAuthenticationRedirectURIQueryParams.size() + 3 && parameterNamesList.containsAll(Arrays.asList("state", "session_state", "code"))) {
                    LOG.info("isUserFlowIdentityProviderCallback state=" + servletRequest.getParameter("state"));
                    LOG.info("isUserFlowIdentityProviderCallback session_state=" + servletRequest.getParameter("session_state"));
                    LOG.info("isUserFlowIdentityProviderCallback code=" + servletRequest.getParameter("code"));
                    return true;
                }
            }
        }
        catch (UserFlowIdentityProviderResponseException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to check if the servlet request is a from a user flow identity provider callback.", ex);
        }
        return false;
    }

    @Override
    public boolean isUserFlowIdentityProviderInUse() throws ServiceNotFoundException, ModuleNotFoundException {
        LOG.info("isUserFlowIdentityProviderInUse");
        IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
        return identityProvider instanceof UserFlowIdentityProvider;
    }

    @Override
    public String getUserFlowIdentityProviderLoginRedirectUrl(HttpServletRequest servletRequest) throws ServiceNotFoundException, ModuleNotFoundException, IdentityProviderException {
        LOG.info("getUserFlowIdentityProviderLoginRedirectUrl servletRequest=" + servletRequest);
        IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
        if (identityProvider instanceof UserFlowIdentityProvider) {
            String language;
            URI updatedRedirectURI;
            String redirectUri;
            String themeName;
            UserFlowIdentityProvider userFlowIdentityProvider = (UserFlowIdentityProvider)identityProvider;
            URI authenticationRequestURI = userFlowIdentityProvider.createAuthenticationRequestURI(servletRequest.getRequestURL().toString());
            if (servletRequest != null && (themeName = servletRequest.getParameter("theme")) != null) {
                try {
                    redirectUri = UriQueryUtil.getQueryParams(authenticationRequestURI).get("redirect_uri");
                    updatedRedirectURI = new URIBuilder(redirectUri).setParameter("theme", themeName).build();
                    authenticationRequestURI = new URIBuilder(authenticationRequestURI).setParameter("redirect_uri", updatedRedirectURI.toString()).build();
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Failed to set the theme '" + themeName + "'.", ex);
                }
            }
            if (servletRequest != null && !StringUtil.isNullOrEmpty(language = servletRequest.getParameter("language"))) {
                try {
                    redirectUri = UriQueryUtil.getQueryParams(authenticationRequestURI).get("redirect_uri");
                    updatedRedirectURI = new URIBuilder(redirectUri).setParameter("language", language).build();
                    authenticationRequestURI = new URIBuilder(authenticationRequestURI).setParameter("redirect_uri", updatedRedirectURI.toString()).setParameter("ui_locales", language).build();
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Failed to set the language '" + language + "'.", ex);
                }
            }
            return authenticationRequestURI.toString();
        }
        return null;
    }

    @Override
    public Map<String, Object> getThemeConfig(HttpServletRequest servletRequest) throws ServiceNotFoundException, ModuleNotFoundException {
        URL themeConfigUrl;
        LOG.info("getThemeConfig servletRequest=" + servletRequest);
        String themeNameFromQueryParam = null;
        if (servletRequest != null) {
            themeNameFromQueryParam = servletRequest.getParameter("theme");
        }
        String themeName = this.getCoreModule().getConfiguration().getSettingValue("theme_name").asString();
        Bundle themeBundle = null;
        Bundle feCoreBundle = null;
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!BpcBundleUtil.isBpcBundle(bundle)) continue;
            String symbolicName = bundle.getSymbolicName();
            String bundleName = (String)bundle.getHeaders().get("Bundle-Name");
            String bpcBundleId = (String)bundle.getHeaders().get("BPC-Bundle-Id");
            if ("de.virtimo.bpc.bpc-fe-core".equals(symbolicName) || "de.virtimo.bpc-fe-core".equals(symbolicName) || "de.virtimo.bpc.fe.core".equals(symbolicName) || "Core (Frontend)".equals(symbolicName) || "Core (Frontend)".equals(bundleName)) {
                feCoreBundle = bundle;
            }
            if (themeName.equals(bpcBundleId)) {
                themeBundle = bundle;
                if (themeNameFromQueryParam == null) break;
            }
            if (themeNameFromQueryParam == null || !themeNameFromQueryParam.equals(bpcBundleId)) continue;
            themeBundle = bundle;
            break;
        }
        Bundle currentThemeBundle = themeBundle != null ? themeBundle : feCoreBundle;
        Map<Object, Object> themeConfigFileContent = null;
        if (currentThemeBundle != null && (themeConfigUrl = BpcBundleUtil.getFileInBundleAtSpecificFolder(currentThemeBundle, "/resources", "themeConfig.json")) != null) {
            String filePath = themeConfigUrl.getFile();
            themeConfigFileContent = JsonDefaultsUtil.loadJsonFileAsMap(currentThemeBundle, filePath);
        }
        return themeConfigFileContent == null ? new HashMap() : themeConfigFileContent;
    }

    @Override
    public List<BpcTheme> getThemeBundles() {
        ArrayList<BpcTheme> themesList = new ArrayList<BpcTheme>();
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!BpcBundleUtil.isBpcBundle(bundle)) continue;
            String bundleType = (String)bundle.getHeaders().get("BPC-Bundle-Type");
            String bundleId = (String)bundle.getHeaders().get("BPC-Bundle-Id");
            String bundleName = (String)bundle.getHeaders().get("Bundle-Name");
            if (bundleType == null || !bundleType.contains("theme")) continue;
            BpcThemeImpl theme = new BpcThemeImpl(bundleId, bundleName);
            themesList.add(theme);
        }
        return themesList;
    }

    private class CoreModuleLoadedEvent
    extends AbstractBackendModuleLoadedEventHandler {
        private CoreModuleLoadedEvent() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOG.info(this.getClass().getSimpleName() + ".processLoadedModule module=...");
            CoreBundleServiceImpl.this.coreModule = (CoreModule)module;
        }
    }
}

