/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler;
import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.AbstractMaintenanceModeAcknowledgeEventHandler;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.AbstractSettingsUpdatedEventHandler;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BackupSettingFactory;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Checker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.License;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.PaxJdbcConfigurationUpdatedInfo;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.identityManagement.IdentityManager;
import de.virtimo.bpc.api.identityManagement.IdentityManagerPlaceholder;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.backendconnections.BackendConnections;
import de.virtimo.bpc.core.SystemChecker;
import de.virtimo.bpc.core.apikey.APIKeys;
import de.virtimo.bpc.core.apikey.APIKeysChecker;
import de.virtimo.bpc.core.auth.IdentityProviderChecker;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.UnsupportedIdentityProviderOperationsFallbackHandler;
import de.virtimo.bpc.core.auth.idp.IdentityProviderWithUnsupportedOperationsFallbackHandler;
import de.virtimo.bpc.core.auth.jaas.JaasProvider;
import de.virtimo.bpc.core.auth.oidc.KeycloakIdentityProvider;
import de.virtimo.bpc.core.auth.oidc.OidcIdentityProvider;
import de.virtimo.bpc.core.db.DataSourceSettings;
import de.virtimo.bpc.core.es.ModuleManagerImpl;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginManager;
import de.virtimo.bpc.core.es.plugin.response.BroadcastMessage;
import de.virtimo.bpc.core.es.plugin.response.ClusterMessage;
import de.virtimo.bpc.core.es.plugin.response.ConnectedServer;
import de.virtimo.bpc.core.es.plugin.response.ConnectedServers;
import de.virtimo.bpc.core.es.plugin.response.IndexOperation;
import de.virtimo.bpc.core.es.plugin.response.ServerStateInfo;
import de.virtimo.bpc.core.exception.TimestampedException;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.lookupjoins.LookupJoinsManager;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.ListUtil;
import de.virtimo.bpc.util.StringUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.HttpHeaders;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public final class CoreModule
implements Module,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(CoreModule.class.getName());
    public static final String MODULE_ID = "_core";
    public static final String MODULE_NAME = "Core Services";
    public static final String SETTING_REST_BASE_URL = "baseUrl";
    public static final String SETTING_REST_MODULE_URL = "moduleUrl";
    public static final String SETTING_MODULE_NAME = "module_name";
    public static final String SETTING_MODULE_ICON_CLASS = "module_iconCls";
    public static final String SETTING_MODULE_RESTRICTED_ACCESS = "module_restrictInstanceAccess";
    public static final String SETTING_MODULE_FORCE_LOAD = "moduleForceLoad";
    public static final String SETTING_MODULEHEADER_ENABLED = "moduleHeader_enabled";
    public static final String SETTING_MODULEHEADER_DESCRIPTION = "moduleHeader_description";
    public static final String SETTING_LICENCED_MODULES = "licencedModules";
    public static final String SETTING_LICENSE_NOTIFICATIONS = "licenseNotifications";
    public static final String SETTING_THEME_NAME = "theme_name";
    public static final String AVAILABLE_THEMES = "themes_available";
    public static final String SETTING_LOGIN_SHOWTENANT = "login_showTenant";
    public static final String SETTING_LOGIN_TENANT = "login_tenantDefaultValue";
    public static final String SETTING_LOGIN_WELCOMEMSG = "login_welcomeMsg";
    public static final String SETTING_LOGIN_TITLE = "login_title";
    public static final String SETTING_LOGIN_SHOW_PW_RESET = "login_showReset";
    public static final String SETTING_WELCOMENOTIFICATION = "welcomeNotification";
    public static final String SETTING_BROWSER_TITLE = "browser_title";
    public static final String SETTING_BROWSER_FAV_ICON = "gui_favIcon";
    public static final String SETTING_LOGIN_DEFAULTLANGUAGE = "login_defaultLanguage";
    public static final String SETTING_LOGIN_SHOWLANGUAGESELECTOR = "login_showLanguageSelector";
    public static final String SETTING_LOGIN_REDIRECT_URL = "login_redirectUrl";
    public static final String SETTING_CLIENT_PATH = "clientPath";
    public static final String SETTING_CUSTOM_TRANSLATIONS = "customTranslations";
    public static final String SETTING_DEPLOYMENT = "deployment";
    public static final String SETTING_TRANSLATIONS_FALLBACK_LANGUAGE = "translationsFallbackLanguage";
    public static final String SETTING_IDENTITY_PROVIDER_BACKENDCONNECTION = "identityProviderBackendConnection";
    public static final String SETTING_BPC_BASE_URL = "bpcBaseUrl";
    public static final String SETTING_BPC_CONFIGURATION_BACKUP_ON_CHANGES = "bpcConfigurationBackup_onChanges";
    public static final String SETTING_INDEX_CREATION_SETTINGS = "indexCreationSettings";
    public static final String SETTING_INDEX_TEMPLATES = "indexTemplates";
    public static final String SETTING_INDEX_DYNAMIC_TEMPLATES = "indexDynamicTemplates";
    public static final String INDEX_TEMPLATES_NAME_PREFIX = "bpc:";
    public static final String BPC_CONFIGURATION_BACKUP_SETTING_NAME = "bpcConfigurationBackup";
    public static final String SETTING_COOKIE_BANNER_TEXT = "cookie_bannerText";
    public static final String SETTING_COOKIE_SHOW_BANNER = "cookie_showBanner";
    public static final String CSRF_TOKEN_NAME = "X-Csrf-Token";
    public static final String CORE_CONFIGURATION_ENCRYPTION_KEY = "de.virtimo.bpc.core.encryption.key";
    public static final String DEFAULT_ENCRYPTION_KEY = "virtimo_berlin";
    private final BundleContext bundleContext;
    private Bundle moduleBundle;
    private ModuleConfiguration moduleConfiguration;
    private IdentityProvider identityProvider;
    private ModuleManager moduleManager;
    private List<TimestampedException> lastOccurredExceptions;
    private final BpcServicesTracker<LookupJoinsManager> lookupJoinsManagerTracker;
    private final BpcServicesTracker<ReplicationManager> replicationManagerTracker;
    private final BpcServicesTracker<DatabaseManager> databaseManagerTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private final BpcServicesTracker<BackupManager> backupManagerTracker;
    private final BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private final BpcServicesTracker<ElasticsearchBpcPluginManager> elasticsearchBpcPluginManagerTracker;
    private final BpcServicesTracker<LicenseService> licenseServiceTracker;
    private final BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private final EventRegistration eventRegistration;
    private CountDownLatch maintenanceModeLatch;
    private static final Object IDENTITY_PROVIDER_LOCK = new Object();
    private IdentityProviderChecker identityProviderChecker;
    private APIKeysChecker apiKeysChecker;
    private SystemChecker systemChecker;

    public CoreModule(ModuleManager moduleManager, Bundle moduleBundle) {
        LOG.info("CoreModule");
        this.moduleManager = moduleManager;
        this.moduleBundle = moduleBundle;
        this.moduleConfiguration = this.getDefaultConfiguration();
        this.bundleContext = moduleBundle.getBundleContext();
        this.licenseServiceTracker = new BpcServicesTracker<LicenseService>(this.bundleContext, LicenseService.class);
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(this.bundleContext, ElasticsearchService.class);
        this.lookupJoinsManagerTracker = new BpcServicesTracker<LookupJoinsManager>(this.bundleContext, LookupJoinsManager.class);
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(this.bundleContext, ReplicationManager.class);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(this.bundleContext, DatabaseManager.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(this.bundleContext, EventManager.class);
        this.backupManagerTracker = new BpcServicesTracker<BackupManager>(this.bundleContext, BackupManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
        this.elasticsearchBpcPluginManagerTracker = new BpcServicesTracker<ElasticsearchBpcPluginManager>(this.bundleContext, ElasticsearchBpcPluginManager.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        this.eventRegistration = new EventRegistration(this.bundleContext);
        this.eventRegistration.forMaintenanceModeConfigPropertyChangedEvents(new MaintenanceModeConfigPropertyChangedEventHandler());
        this.eventRegistration.forMaintenanceModeAcknowledgeEvents(new MaintenanceModeAcknowlegeEventHandler(this.bundleContext));
        this.eventRegistration.forMaintenanceModeAcknowledgedEvents(new MaintenanceModeAcknowledgedEventHandler());
        this.eventRegistration.forForceLocalIdentityProviderEvents(new ForceLocalIdentityProviderEventHandler());
        this.eventRegistration.forElasticsearchPluginEvents(new ElasticsearchBpcPluginEventHandler());
        this.eventRegistration.forModuleInstanceUpdatedEvents("backendconnection", "data_source", new DataSourceUpdatedEventHandler());
        this.eventRegistration.forModuleInstanceDeletedEvents("backendconnection", "data_source", new DataSourceDeletedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents(MODULE_ID, SETTING_INDEX_TEMPLATES, new ElasticsearchTemplatesSettingUpdatedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents(MODULE_ID, BPC_CONFIGURATION_BACKUP_SETTING_NAME, new BpcConfigurationBackupSettingUpdatedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents(MODULE_ID, SETTING_IDENTITY_PROVIDER_BACKENDCONNECTION, new IdentityProviderBackendConnectionUpdatedEventHandler());
        this.eventRegistration.forModuleInstanceUpdatedEvents("backendconnection", "identity_provider", new IdentityProviderUpdatedEventHandler());
        this.eventRegistration.forModuleInstanceDeletedEvents("backendconnection", "identity_provider", new IdentityProviderDeletedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents(MODULE_ID, SETTING_LICENCED_MODULES, new LicensedModulesSettingUpdatedEventHandler());
        this.eventRegistration.forBackendModuleLoadedAndAutoCreateModuleInstancesDoneEvents("backendconnection", new BackendConnectionsModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler());
        this.eventRegistration.forLicenseChangedEvents(new LicenseChangedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents(MODULE_ID, new FrontendUrlRelatedSettingsUpdatedEventHandler());
        this.eventRegistration.forBackendModuleLoadedEvents(MODULE_ID, new CoreModuleLoadedEventHandler());
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
        Checker.stop(this.identityProviderChecker);
        Checker.stop(this.apiKeysChecker);
        Checker.stop(this.systemChecker);
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
        if (this.identityProvider != null) {
            this.identityProvider.destroy();
        }
        if (this.moduleConfiguration != null) {
            this.moduleConfiguration.removePropertyChangeListener(this);
            this.moduleConfiguration.destroy();
            this.moduleConfiguration = null;
        }
        this.moduleManager = null;
    }

    @Override
    public Bundle getModuleBundle() {
        return this.moduleBundle;
    }

    @Override
    public void setModuleBundle(Bundle moduleBundle) {
        this.moduleBundle = moduleBundle;
    }

    public boolean isForceLocalIdentityProviderEnabled() {
        LOG.fine("isForceLocalIdentityProviderEnabled");
        try {
            return this.coreBundleConfigurationTracker.getService().isForceLocalIdentityProviderEnabled();
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, "Could not get the core configuration to read the force local identity provider value.", ex);
            return Boolean.FALSE;
        }
    }

    public boolean isMaintenanceModeEnabled() {
        LOG.fine("isMaintenanceModeEnabled");
        try {
            return this.coreBundleConfigurationTracker.getService().isMaintenanceModeEnabled();
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, "Could not get the core bundle configuration to read the maintenance mode status.", ex);
            return Boolean.FALSE;
        }
    }

    public boolean isMaintenanceModeUpdateAlreadyRunning() {
        return this.maintenanceModeLatch != null;
    }

    private int getNumberOfModulesSupportingMaintenanceMode() {
        LOG.info("getNumberOfModulesSupportingMaintenanceMode");
        int result = 0;
        try {
            BundleContext bundleContext = this.getModuleBundle().getBundleContext();
            Collection sr = bundleContext.getServiceReferences(EventHandler.class, "(event.topics=de/virtimo/bpc/core/maintenanceMode/acknowledge)");
            if (sr != null) {
                for (ServiceReference serviceReference : sr) {
                    ++result;
                    LOG.info("Found maintenance mode handler: " + bundleContext.getService(serviceReference));
                    bundleContext.ungetService(serviceReference);
                }
            } else {
                LOG.log(Level.SEVERE, "Hey BPC developer, there is an error in your get service references filter (CoreModule.getNumberOfModulesSupportingMaintenanceMode)! ;-)");
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the number of modules supporting the maintenance mode", ex);
            result = 0;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enableMaintenanceMode(boolean writeToConfigIsNecessary) {
        LOG.info("enableMaintenanceMode writeToConfigIsNecessary=" + writeToConfigIsNecessary);
        if (this.maintenanceModeLatch != null) {
            LOG.info("Nothing to do. Still waiting for modules to accept the maintenance mode status update!");
            return;
        }
        if (writeToConfigIsNecessary && this.isMaintenanceModeEnabled()) {
            LOG.info("Nothing to do. The maintenance mode is already enabled!");
            return;
        }
        long startTimeMillis = System.currentTimeMillis();
        try {
            int numberOfModulesSupportingMaintenanceMode = this.getNumberOfModulesSupportingMaintenanceMode();
            this.maintenanceModeLatch = new CountDownLatch(numberOfModulesSupportingMaintenanceMode);
            if (writeToConfigIsNecessary) {
                this.coreBundleConfigurationTracker.getService().setMaintenanceModeEnabled(true);
            }
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/maintenanceMode/acknowledge", "enabled", Boolean.TRUE);
            try {
                LOG.info("Maintenance mode enabled ... now waiting for " + numberOfModulesSupportingMaintenanceMode + " acknowledgement events");
                this.maintenanceModeLatch.await(60L, TimeUnit.SECONDS);
                LOG.info("Maintenance mode enabled ... waited " + (System.currentTimeMillis() - startTimeMillis) + " ms for all acknowledgements");
                this.maintenanceModeLatch = null;
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            finally {
                this.maintenanceModeLatch = null;
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not enable the maintenance mode.", ex);
            return;
        }
        finally {
            try {
                this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/maintenanceMode", "enabled", this.coreBundleConfigurationTracker.getService().isMaintenanceModeEnabled());
            }
            catch (ServiceNotFoundException ex) {
                LOG.log(Level.SEVERE, "Failed to inform the frontends about the maintenance mode state.", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disableMaintenanceMode(boolean writeToConfigIsNecessary) {
        LOG.info("disableMaintenanceMode writeToConfigIsNecessary=" + writeToConfigIsNecessary);
        if (this.maintenanceModeLatch != null) {
            LOG.info("Nothing to do. Still waiting for modules to accept the maintenance mode status update!");
            return;
        }
        if (writeToConfigIsNecessary && !this.isMaintenanceModeEnabled()) {
            LOG.info("Nothing to do. The maintenance mode is not enabled!");
            return;
        }
        long startTimeMillis = System.currentTimeMillis();
        try {
            int numberOfModulesSupportingMaintenanceMode = this.getNumberOfModulesSupportingMaintenanceMode();
            this.maintenanceModeLatch = new CountDownLatch(numberOfModulesSupportingMaintenanceMode);
            if (writeToConfigIsNecessary) {
                this.coreBundleConfigurationTracker.getService().setMaintenanceModeEnabled(false);
            }
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/maintenanceMode/acknowledge", "enabled", Boolean.FALSE);
            try {
                LOG.info("Maintenance mode disabled ... now waiting for " + numberOfModulesSupportingMaintenanceMode + " acknowledgement events");
                this.maintenanceModeLatch.await(60L, TimeUnit.SECONDS);
                LOG.info("Maintenance mode disabled ... waited " + (System.currentTimeMillis() - startTimeMillis) + " ms for all acknowledgements");
                this.maintenanceModeLatch = null;
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            finally {
                this.maintenanceModeLatch = null;
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not disable the maintenance mode.", ex);
            return;
        }
        finally {
            try {
                this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/maintenanceMode", "enabled", this.coreBundleConfigurationTracker.getService().isMaintenanceModeEnabled());
            }
            catch (ServiceNotFoundException ex) {
                LOG.log(Level.SEVERE, "Failed to inform the frontends about the maintenance mode state.", ex);
            }
        }
    }

    public long getMaintenanceModeFileSystemLimitInMB() throws ServiceNotFoundException {
        LOG.info("getMaintenanceModeFileSystemLimitInMB");
        return this.coreBundleConfigurationTracker.getService().getMaintenanceModeFileSystemLimitInMB();
    }

    @Override
    public ModuleConfiguration getDefaultConfiguration() {
        LOG.info("getDefaultConfiguration");
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/core/default_module_settings.json").build();
    }

    @Override
    public String getModuleId() {
        return MODULE_ID;
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public void setConfiguration(ModuleConfiguration moduleConfiguration) {
        LOG.info("setConfiguration");
        ModuleConfiguration oldModuleConfiguration = this.moduleConfiguration;
        if (oldModuleConfiguration != null) {
            oldModuleConfiguration.removePropertyChangeListener(this);
        }
        moduleConfiguration.addPropertyChangeListener(this);
        this.moduleConfiguration = moduleConfiguration;
        this.refreshDataSources();
        this.refreshElasticsearchTemplates(moduleConfiguration);
        this.restartBpcConfigurationIndexBackupJob(moduleConfiguration.getSetting(BPC_CONFIGURATION_BACKUP_SETTING_NAME));
        this.updateLicenseSettingToPreventManipulation();
    }

    @Override
    public ModuleConfiguration getConfiguration() {
        LOG.fine("getConfiguration");
        return this.moduleConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityProvider getIdentityProvider() {
        LOG.finest("getIdentityProvider");
        Object object = IDENTITY_PROVIDER_LOCK;
        synchronized (object) {
            return this.identityProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityManager getIdentityManager() {
        LOG.finest("getIdentityManager");
        Object object = IDENTITY_PROVIDER_LOCK;
        synchronized (object) {
            if (this.identityProvider instanceof IdentityManager) {
                return (IdentityManager)((Object)this.identityProvider);
            }
            return IdentityManagerPlaceholder.getInstance();
        }
    }

    @Override
    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Setting setting;
        Object newValue;
        LOG.info("Got a property change event: " + evt);
        if (evt.getSource() instanceof ModuleConfiguration && "apiKeys".equalsIgnoreCase(evt.getPropertyName()) && (newValue = evt.getNewValue()) instanceof Setting && APIKeys.fixApiKeyIDs(setting = (Setting)newValue)) {
            try {
                this.getConfiguration().updateSetting(setting);
            }
            catch (SettingException ex) {
                LOG.log(Level.SEVERE, "Failed to fix/adjust the IDs of API keys.", ex);
            }
        }
    }

    public List<TimestampedException> getLastOccurredExceptions() {
        return this.lastOccurredExceptions;
    }

    private synchronized void keepAsLastOccurredException(TimestampedException timestampedException) {
        LOG.info("keepAsLastOccurredException timestampedException=" + timestampedException);
        if (this.lastOccurredExceptions == null) {
            this.lastOccurredExceptions = new ArrayList<TimestampedException>();
        }
        this.lastOccurredExceptions.add(timestampedException);
        while (this.lastOccurredExceptions.size() >= 12) {
            this.lastOccurredExceptions.remove(0);
        }
    }

    private void refreshDataSources() {
        LOG.info("refreshDataSources");
        try {
            List<Map<String, Object>> paxJdbcDataSourceConfigurations = DataSourceSettings.getAllPaxJdbcDataSourceConfigurations(this.moduleManager);
            PaxJdbcConfigurationUpdatedInfo configUpdatedInfo = this.databaseManagerTracker.getService().createOrUpdateDataSourcesByUsingPaxJdbcConfigurations(paxJdbcDataSourceConfigurations);
            LOG.info("refreshDataSources result: " + configUpdatedInfo);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Database sources processing failed.", ex);
            this.keepAsLastOccurredException(new TimestampedException(ex));
        }
    }

    private void refreshElasticsearchTemplates(ModuleConfiguration moduleConfiguration) {
        LOG.info("refreshElasticsearchTemplates");
        try {
            this.refreshElasticsearchTemplates(moduleConfiguration.getSetting(SETTING_INDEX_TEMPLATES));
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Elasticsearch templates refreshing failed.", ex);
            this.keepAsLastOccurredException(new TimestampedException(ex));
        }
    }

    private void restartBpcConfigurationIndexBackupJob(Setting bpcConfigurationIndexBackupSetting) {
        LOG.info("restartBpcConfigurationIndexBackupJob bpcConfigurationIndexBackupSetting=" + bpcConfigurationIndexBackupSetting);
        try {
            BackupManager backupManager = this.backupManagerTracker.getService();
            backupManager.stopBackupJob("core:bpc-configuration");
            if (!this.isMaintenanceModeEnabled()) {
                backupManager.scheduleBackupJobWithSettings("core:bpc-configuration", this.getBpcConfigurationIndexBackupSetting(bpcConfigurationIndexBackupSetting));
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Backup jobs processing failed.", ex);
            this.keepAsLastOccurredException(new TimestampedException(ex));
        }
    }

    public static IdentityProviderConfiguration getCurrentIdentityProviderConfiguration(BundleContext bundleContext) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        try (BpcServicesTracker<ModuleManager> moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);){
            CoreModule coreModule = (CoreModule)moduleManagerTracker.getService().getModuleById(MODULE_ID);
            IdentityProviderConfiguration identityProviderConfiguration = coreModule.getCurrentIdentityProviderConfiguration();
            return identityProviderConfiguration;
        }
    }

    public IdentityProviderConfiguration getCurrentIdentityProviderConfiguration() throws ModuleNotFoundException, ModuleInstanceNotFoundException {
        String identityProviderBackendConnectionId = this.moduleConfiguration.getSettingValue(SETTING_IDENTITY_PROVIDER_BACKENDCONNECTION).asString();
        return BackendConnections.getIdentityProviderConfiguration(this.moduleManager, identityProviderBackendConnectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldTryToRefreshIdentityProvider() {
        LOG.info("shouldTryToRefreshIdentityProvider");
        Object object = IDENTITY_PROVIDER_LOCK;
        synchronized (object) {
            block9: {
                if (this.isForceLocalIdentityProviderEnabled()) {
                    LOG.info("shouldTryToRefreshIdentityProvider: Not necessary, forced local identity provider is active");
                    return false;
                }
                if (this.identityProvider == null) {
                    try {
                        String idpBackendConnectionId = (String)this.moduleConfiguration.getSetting(SETTING_IDENTITY_PROVIDER_BACKENDCONNECTION).getValue();
                        if (StringUtil.isNullOrEmpty(idpBackendConnectionId)) {
                            LOG.info("shouldTryToRefreshIdentityProvider: Not necessary, the identity provider backend connection ID is not set.");
                            return false;
                        }
                        IdentityProviderConfiguration idpConfiguration = BackendConnections.getIdentityProviderConfiguration(this.moduleManager, idpBackendConnectionId);
                        if (idpConfiguration == null) {
                            LOG.info("shouldTryToRefreshIdentityProvider: Not necessary, the identity provider backend connection configuration is somehow 'null'.");
                            return false;
                        }
                        break block9;
                    }
                    catch (Exception ex) {
                        LOG.info("shouldTryToRefreshIdentityProvider: Not necessary, failed to get the identity provider backend connection configuration.");
                        return false;
                    }
                }
                LOG.info("shouldTryToRefreshIdentityProvider: Not necessary, a identity provider is already set.");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIdentityProvider() {
        LOG.info("refreshIdentityProvider");
        Object object = IDENTITY_PROVIDER_LOCK;
        synchronized (object) {
            try {
                IdentityProvider idp;
                int idpSessionExpirationMinutes;
                Map<String, Object> idpConfig;
                String idpUrl;
                String idpName;
                IdentityProviderConfiguration idpConfiguration;
                BundleContext bundleContext = this.getModuleBundle().getBundleContext();
                if (this.isForceLocalIdentityProviderEnabled()) {
                    LOG.warning("Forced local identity provider, using JAAS with realm 'karaf'");
                    idpConfiguration = null;
                } else {
                    try {
                        String idpBackendConnectionId = (String)this.moduleConfiguration.getSetting(SETTING_IDENTITY_PROVIDER_BACKENDCONNECTION).getValue();
                        if (!StringUtil.isNullOrEmpty(idpBackendConnectionId)) {
                            idpConfiguration = BackendConnections.getIdentityProviderConfiguration(this.moduleManager, idpBackendConnectionId);
                        } else {
                            LOG.warning("No identity provider backend connection ID set. Going to use the local/karaf IDP as fallback.");
                            idpConfiguration = null;
                        }
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, "Failed to get the identity provider backend connection. Going to use the local/Karaf IDP as fallback.", ex);
                        idpConfiguration = null;
                    }
                }
                if (idpConfiguration == null) {
                    try {
                        idpConfiguration = BackendConnections.getIdentityProviderConfiguration(this.moduleManager, "idp_karaf");
                        if (!"karaf".equalsIgnoreCase(idpConfiguration.getIdentityProviderName())) {
                            idpConfiguration = null;
                        }
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, "Strange, failed to get the automatically created identity provider backend connection 'idp_karaf'. Going to use the local/Karaf IDP as fallback anyway.", ex);
                        idpConfiguration = null;
                    }
                }
                if (idpConfiguration != null) {
                    idpName = idpConfiguration.getIdentityProviderName();
                    idpUrl = idpConfiguration.getIdentityProviderUrl();
                    idpConfig = idpConfiguration.getSpecificConfigurationAsMap();
                    idpSessionExpirationMinutes = idpConfiguration.getSessionExpirationInMinutes();
                } else {
                    idpName = "karaf";
                    idpUrl = null;
                    idpConfig = null;
                    idpSessionExpirationMinutes = 480;
                }
                try {
                    switch (idpName) {
                        case "oidc": {
                            idp = new OidcIdentityProvider(bundleContext, idpUrl, idpConfig, idpSessionExpirationMinutes);
                            break;
                        }
                        case "keycloak": {
                            idp = new KeycloakIdentityProvider(bundleContext, idpUrl, idpConfig, idpSessionExpirationMinutes);
                            break;
                        }
                        default: {
                            String loginContextId = idpName.equalsIgnoreCase("local") ? "karaf" : idpName;
                            LOG.info("Using JAAS with realm '" + loginContextId + "'");
                            if (this.identityProvider instanceof JaasProvider && loginContextId.equals(((JaasProvider)this.identityProvider).getLoginContextId())) {
                                idp = this.identityProvider;
                                ((JaasProvider)this.identityProvider).setSessionExpirationInMinutes(idpSessionExpirationMinutes);
                                break;
                            }
                            idp = new JaasProvider(bundleContext, loginContextId, idpSessionExpirationMinutes);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Failed to initialize the identity provider: '" + idpName + "'. Going to use the local/Karaf IDP as fallback.", ex);
                    idp = null;
                }
                if (idp instanceof IdentityProviderWithUnsupportedOperationsFallbackHandler) {
                    UnsupportedIdentityProviderOperationsFallbackHandler handler = null;
                    if (idpConfiguration != null) {
                        try {
                            handler = new UnsupportedIdentityProviderOperationsFallbackHandler(idpConfiguration.getModuleConfiguration());
                        }
                        catch (Exception ex) {
                            LOG.log(Level.SEVERE, "Failed to initialize the UnsupportedIdentityProviderOperationsFallbackHandler", ex);
                        }
                    }
                    ((IdentityProviderWithUnsupportedOperationsFallbackHandler)((Object)idp)).setUnsupportedIdentityProviderOperationsFallbackHandler(handler);
                }
                if (this.identityProvider != null && this.identityProvider != idp) {
                    this.clientSessionManagerTracker.getService().removeAllSessions(true, this.identityProvider);
                    this.identityProvider.destroy();
                }
                if (idp instanceof JaasProvider) {
                    JaasProvider jaasProvider = (JaasProvider)idp;
                    jaasProvider.replaceDefaultPasswordsOfShippedUsers("default_virtimo_password", ListUtil.listOf("bpcadmin", "root", "virtimo"));
                }
                this.identityProvider = idp;
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Identity provider processing failed.", ex);
                this.keepAsLastOccurredException(new TimestampedException(ex));
            }
        }
    }

    private void updateLicenseSettingToPreventManipulation() {
        LOG.info("updateLicenseSettingToPreventManipulation");
        try {
            this.updateLicenceSetting(this.licenseServiceTracker.getService().getLicense());
        }
        catch (ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Updating core license setting failed.", ex);
            this.keepAsLastOccurredException(new TimestampedException(ex));
        }
    }

    private void updateLicenceSetting(License license) {
        LOG.info("updateLicenceSetting license=" + license);
        try {
            Map oldLicencedSettingValue = (Map)this.getConfiguration().getSetting(SETTING_LICENCED_MODULES).getValue();
            HashMap<String, Object> newLicenseSettingValue = oldLicencedSettingValue == null ? new HashMap<String, Object>() : new HashMap(oldLicencedSettingValue);
            Map<String, Object> licenseDetails = this.licenseServiceTracker.getService().getLicenseDetails(license);
            if (licenseDetails != null) {
                newLicenseSettingValue.putAll(licenseDetails);
            }
            if (oldLicencedSettingValue == null || !newLicenseSettingValue.equals(oldLicencedSettingValue)) {
                SimpleSettingImpl newLicenceSetting = new SimpleSettingImpl(this.getConfiguration().getSetting(SETTING_LICENCED_MODULES));
                newLicenceSetting.setValue(newLicenseSettingValue);
                this.getConfiguration().updateSetting(newLicenceSetting, true);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Updating core license setting failed.", ex);
            this.keepAsLastOccurredException(new TimestampedException(ex));
        }
    }

    public void refreshElasticsearchTemplates(Setting esTemplatesSetting) throws ServiceNotFoundException, ElasticsearchRelatedException {
        LOG.info("refreshElasticsearchTemplates esTemplatesSetting=" + esTemplatesSetting);
        if (!esTemplatesSetting.getName().equals(SETTING_INDEX_TEMPLATES)) {
            return;
        }
        Map newTemplates = (Map)esTemplatesSetting.getValue();
        ElasticsearchService es = this.elasticsearchServiceTracker.getService();
        Set<String> oldTemplateNames = es.getTemplateNamesWithPrefix(INDEX_TEMPLATES_NAME_PREFIX);
        HashSet<String> newTemplateNames = new HashSet<String>();
        for (String templateName : newTemplates.keySet()) {
            if (!templateName.startsWith(INDEX_TEMPLATES_NAME_PREFIX)) continue;
            newTemplateNames.add(templateName);
        }
        for (String oldTemplateName : oldTemplateNames) {
            if (newTemplateNames.contains(oldTemplateName)) continue;
            es.deleteTemplate(oldTemplateName);
        }
        for (String templateName : newTemplateNames) {
            es.createTemplate(templateName, (Map)newTemplates.get(templateName));
        }
    }

    public boolean isBpcConfigurationIndexBackupOnChangesEnabled() {
        LOG.info("isBpcConfigurationIndexBackupOnChangesEnabled");
        return (Boolean)this.getConfiguration().getSetting(SETTING_BPC_CONFIGURATION_BACKUP_ON_CHANGES).getValue();
    }

    public boolean isBpcConfigurationIndexBackupNecessary(List<Setting> settings) {
        LOG.info("isBpcConfigurationIndexBackupNecessary settings=...");
        if (settings == null || settings.isEmpty()) {
            return false;
        }
        Iterator<Setting> iterator = settings.iterator();
        if (iterator.hasNext()) {
            Setting setting = iterator.next();
            return true;
        }
        return false;
    }

    public void createBpcConfigurationSnapshot(UserSession userSession) {
        LOG.info("createBpcConfigurationSnapshot userSession=...");
        try {
            BackupSnapshotInfo snapshotInfo = this.backupManagerTracker.getService().createBackup(this.getBpcConfigurationIndexBackupSetting());
            UserAuditLog.info(userSession, "BackupCreated", "Backup with the snapshot name '" + snapshotInfo.getName() + "' created");
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to create the 'bpc-configuration' index snapshot/backup.", ex);
            UserAuditLog.warning(userSession, "BackupFailed", "Backup of the 'bpc-configuration' index failed. Please be sure that 'path.repo' is set in the Elasticsearch configuration.");
        }
    }

    public BackupSetting getBpcConfigurationIndexBackupSetting() {
        LOG.info("getBpcConfigurationIndexBackupSetting");
        return this.getBpcConfigurationIndexBackupSetting(this.getConfiguration().getSetting(BPC_CONFIGURATION_BACKUP_SETTING_NAME));
    }

    private BackupSetting getBpcConfigurationIndexBackupSetting(Setting bpcConfigurationIndexBackupSetting) {
        LOG.info("getBpcConfigurationIndexBackupSetting bpcConfigurationIndexBackupSetting=" + bpcConfigurationIndexBackupSetting);
        return BackupSettingFactory.createFrom(bpcConfigurationIndexBackupSetting, new String[]{"bpc-configuration"});
    }

    public String getBpcFrontendUrl() {
        String bpcBaseUrl = this.getConfiguration().getSettingValue(SETTING_BPC_BASE_URL).asString("http://localhost:8181");
        String bpcClientPath = this.getConfiguration().getSettingValue(SETTING_CLIENT_PATH).asString("/");
        return StringUtil.glue(bpcBaseUrl, bpcClientPath, '/');
    }

    public static boolean isRequestFromOtherBpcServer(HttpHeaders hh, CoreBundleConfiguration coreBundleConfiguration, ElasticsearchBpcPluginManager elasticsearchBpcPluginManager) throws ServiceNotFoundException {
        ConnectedServers connectedServers;
        String callingServerUUID;
        if (hh != null && !StringUtil.isNullOrEmpty(callingServerUUID = hh.getHeaderString("X-Active-Active")) && !callingServerUUID.equals(coreBundleConfiguration.getServerUUID()) && (connectedServers = elasticsearchBpcPluginManager.getConnectedServers()) != null) {
            ConnectedServer connectedServer = connectedServers.getConnectedServerByUUID(callingServerUUID);
            return connectedServer != null;
        }
        return false;
    }

    private class MaintenanceModeConfigPropertyChangedEventHandler
    extends AbstractEventHandler {
        private MaintenanceModeConfigPropertyChangedEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            Boolean maintenanceModeEnabled = (Boolean)event.getProperty("enabled");
            LOG.fine("maintenanceModeEnabled? " + maintenanceModeEnabled);
            if (maintenanceModeEnabled.booleanValue()) {
                CoreModule.this.enableMaintenanceMode(false);
            } else {
                CoreModule.this.disableMaintenanceMode(false);
            }
        }
    }

    private class MaintenanceModeAcknowlegeEventHandler
    extends AbstractMaintenanceModeAcknowledgeEventHandler {
        public MaintenanceModeAcknowlegeEventHandler(BundleContext bundleContext) {
            super(bundleContext, CoreModule.MODULE_ID);
        }

        @Override
        public void processNewMaintenanceMode(boolean maintenanceModeEnabled) {
            LOG.info(this.getClass().getSimpleName() + ".processNewMaintenanceMode enabled=" + maintenanceModeEnabled);
            try {
                CoreModule.this.restartBpcConfigurationIndexBackupJob(CoreModule.this.moduleConfiguration.getSetting(CoreModule.BPC_CONFIGURATION_BACKUP_SETTING_NAME));
                ReplicationManager replicationManager = CoreModule.this.replicationManagerTracker.getService();
                CoreBundleConfiguration coreBundleConfiguration = CoreModule.this.coreBundleConfigurationTracker.getService();
                ServerStateInfo serverStateInfo = ServerStateInfo.create(maintenanceModeEnabled, replicationManager.isReplicationEnabled(), coreBundleConfiguration.getServerUUID(), coreBundleConfiguration.getBpcName(), CoreModule.this.getBpcFrontendUrl());
                CoreModule.this.eventManagerTracker.getService().fireEvent("de/virtimo/es-bpc-plugin-send-state-info-message", "msg", serverStateInfo);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to process the maintenance mode changed event.", ex);
            }
        }
    }

    private class MaintenanceModeAcknowledgedEventHandler
    extends AbstractEventHandler {
        private MaintenanceModeAcknowledgedEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            if (CoreModule.this.maintenanceModeLatch != null) {
                LOG.info("Received an maintenance mode enabled acknowledgement from module '" + event.getProperty("moduleId") + "' handler: " + event.getProperty("handler"));
                CoreModule.this.maintenanceModeLatch.countDown();
            } else {
                LOG.info("Ignoring event ... there core does not wait for maintenance mode enabled acknowledgements");
            }
        }
    }

    private class ForceLocalIdentityProviderEventHandler
    extends AbstractEventHandler {
        private ForceLocalIdentityProviderEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            Boolean forceLocalIdentityProviderEnabled = (Boolean)event.getProperty("enabled");
            LOG.fine("forceLocalIdentityProviderEnabled? " + forceLocalIdentityProviderEnabled);
            CoreModule.this.refreshIdentityProvider();
        }
    }

    private class ElasticsearchBpcPluginEventHandler
    extends AbstractEventHandler {
        private ElasticsearchBpcPluginEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            try {
                IndexOperation indexOperation;
                ClusterMessage clusterMessage;
                ServerStateInfo serverStateInfo;
                ReplicationManager replicationManager = CoreModule.this.replicationManagerTracker.getService();
                final LookupJoinsManager lookupJoinsManager = CoreModule.this.lookupJoinsManagerTracker.getService();
                EventManager eventManager = CoreModule.this.eventManagerTracker.getService();
                CoreBundleConfiguration coreBundleConfiguration = CoreModule.this.coreBundleConfigurationTracker.getService();
                ElasticsearchBpcPluginManager elasticsearchBpcPluginManager = CoreModule.this.elasticsearchBpcPluginManagerTracker.getService();
                String thisServerUUID = CoreModule.this.coreBundleConfigurationTracker.getService().getServerUUID();
                if (Arrays.asList(event.getPropertyNames()).contains("WebsocketState")) {
                    ElasticsearchBpcPluginManager.WebsocketState websocketState = (ElasticsearchBpcPluginManager.WebsocketState)((Object)event.getProperty("WebsocketState"));
                    if (ElasticsearchBpcPluginManager.WebsocketState.CONNECTED.equals((Object)websocketState)) {
                        serverStateInfo = ServerStateInfo.create(CoreModule.this.isMaintenanceModeEnabled(), replicationManager.isReplicationEnabled(), coreBundleConfiguration.getServerUUID(), coreBundleConfiguration.getBpcName(), CoreModule.this.getBpcFrontendUrl());
                        eventManager.fireEvent("de/virtimo/es-bpc-plugin-send-state-info-message", "msg", serverStateInfo);
                    }
                    if (ElasticsearchBpcPluginManager.WebsocketState.DISCONNECTED.equals((Object)websocketState) && replicationManager.isReplicationEnabled()) {
                        replicationManager.setReplicationEnabled(false);
                        elasticsearchBpcPluginManager.unregisterAllFilters(CoreModule.this.elasticsearchServiceTracker.getService());
                        replicationManager.stop();
                        lookupJoinsManager.stop();
                        SystemAuditLog.info("ReplicationJobsStopped", "Replication jobs stopped. Because the websocket connection to the 'es-bpc-plugin' was closed.");
                    }
                }
                if (Arrays.asList(event.getPropertyNames()).contains("ClusterMessage") && (clusterMessage = (ClusterMessage)event.getProperty("ClusterMessage")).getAction().equals("SetAsMaster")) {
                    if (clusterMessage.getServerUUID().equals(thisServerUUID)) {
                        try {
                            if (!replicationManager.isReplicationEnabled()) {
                                LOG.warning("Setting this server with the UUID '" + thisServerUUID + "' as master. Replication must be enabled.");
                                replicationManager.setReplicationEnabled(true);
                                replicationManager.startReplication();
                                lookupJoinsManager.registerForElasticsearchChanges();
                                SystemAuditLog.info("ReplicationJobsStarted", "Replication jobs started. Because this server has become the 'master'.");
                            } else {
                                LOG.warning("Setting this server with the UUID '" + thisServerUUID + "' as master. Replication is already enabled.");
                            }
                            eventManager.fireEvent("de/virtimo/bpc/core/serverModeChanged", "serverMode", "master");
                        }
                        catch (ServiceNotFoundException ex) {
                            LOG.log(Level.SEVERE, "Failed to register for Elasticsearch changes", ex);
                        }
                    }
                    if (!clusterMessage.getServerUUID().equals(thisServerUUID)) {
                        if (replicationManager.isReplicationEnabled()) {
                            LOG.warning("Setting this server with the UUID '" + thisServerUUID + "' as slave. Replication must be disabled.");
                            replicationManager.setReplicationEnabled(false);
                            elasticsearchBpcPluginManager.unregisterAllFilters(CoreModule.this.elasticsearchServiceTracker.getService());
                            replicationManager.stop();
                            lookupJoinsManager.stop();
                            SystemAuditLog.info("ReplicationJobsStopped", "Replication jobs stopped. Because this server is no longer the 'master'.");
                        } else {
                            LOG.warning("Setting this server with the UUID '" + thisServerUUID + "' as slave. Replication is already disabled.");
                        }
                        eventManager.fireEvent("de/virtimo/bpc/core/serverModeChanged", "serverMode", "slave");
                    }
                    serverStateInfo = ServerStateInfo.create(CoreModule.this.isMaintenanceModeEnabled(), replicationManager.isReplicationEnabled(), coreBundleConfiguration.getServerUUID(), coreBundleConfiguration.getBpcName(), CoreModule.this.getBpcFrontendUrl());
                    eventManager.fireEvent("de/virtimo/es-bpc-plugin-send-state-info-message", "msg", serverStateInfo);
                }
                if (Arrays.asList(event.getPropertyNames()).contains("IndexOperation") && !(indexOperation = (IndexOperation)event.getProperty("IndexOperation")).getIndexAndAliasNames().contains("bpc-configuration") && replicationManager.isReplicationEnabled()) {
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            try {
                                lookupJoinsManager.handleElasticsearchBpcPluginIndexOperation(indexOperation);
                            }
                            catch (ServiceNotFoundException ex) {
                                LOG.log(Level.SEVERE, "Failed to handle Elasticsearch index operation", ex);
                            }
                        }
                    }, 1500L);
                }
                if (Arrays.asList(event.getPropertyNames()).contains("BroadcastMessage")) {
                    final BroadcastMessage broadcastMessage = (BroadcastMessage)event.getProperty("BroadcastMessage");
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (CoreModule.this.moduleManager instanceof ModuleManagerImpl) {
                                ((ModuleManagerImpl)CoreModule.this.moduleManager).handleElasticsearchBpcPluginBroadcastMessage(broadcastMessage);
                            }
                        }
                    }, 1500L);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to process the event=" + event, ex);
            }
        }
    }

    private class DataSourceUpdatedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        private DataSourceUpdatedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return this.isModuleUpdatedEventOfSettings(event, Arrays.asList("driverName", "url", "user", "password", "configuration"));
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            CoreModule.this.refreshDataSources();
        }
    }

    private class DataSourceDeletedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        private DataSourceDeletedEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            CoreModule.this.refreshDataSources();
        }
    }

    private class ElasticsearchTemplatesSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private ElasticsearchTemplatesSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting esTemplatesSetting) {
            LOG.info(this.getClass().getSimpleName() + ".processSetting esTemplatesSetting=...");
            try {
                CoreModule.this.refreshElasticsearchTemplates(esTemplatesSetting);
            }
            catch (ElasticsearchRelatedException | ServiceNotFoundException ex) {
                LOG.log(Level.SEVERE, "Failed to set the elasticsearch templates.", ex);
            }
        }
    }

    private class BpcConfigurationBackupSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private BpcConfigurationBackupSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting bpcConfigurationBackupSetting) {
            LOG.info(this.getClass().getSimpleName() + ".processSetting bpcConfigurationBackupSetting=...");
            CoreModule.this.restartBpcConfigurationIndexBackupJob(bpcConfigurationBackupSetting);
        }
    }

    private class IdentityProviderBackendConnectionUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private IdentityProviderBackendConnectionUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting setting) {
            LOG.info(this.getClass().getSimpleName() + ".processSetting setting=...");
            if (CoreModule.this.moduleManager.getModule("backendconnection") != null) {
                CoreModule.this.refreshIdentityProvider();
            }
        }
    }

    private class IdentityProviderUpdatedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        private final List<String> mandatorySettingNames = Arrays.asList("identityProvider", "identityProvider.url", "identityProvider_mappings", "identityProvider_configuration", "identityProvider_sessionExpirationMinutes");
        private final List<String> dynamicallyReadSettingNames = Arrays.asList("identityProvider_ussUrl", "identityProvider_pwdValidationRegExp");
        private final List<String> fetchAdditionalInfoSettingNames = Arrays.asList("identityProvider.additionalInfoUrl", "identityProvider.additionalInfoEnabled", "identityProvider.additionalInfoEntriesPrefix", "identityProvider.additionalInfoUrlBasicAuthUsername", "identityProvider.additionalInfoUrlBasicAuthPassword");

        private IdentityProviderUpdatedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            ArrayList<String> allIdpSettingNames = new ArrayList<String>();
            allIdpSettingNames.addAll(this.mandatorySettingNames);
            allIdpSettingNames.addAll(this.dynamicallyReadSettingNames);
            allIdpSettingNames.addAll(this.fetchAdditionalInfoSettingNames);
            return this.isModuleUpdatedEventOfSettings(event, allIdpSettingNames);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onUpdateOfIdentityProviderMappings(String idpInstanceId) throws ModuleNotFoundException, ModuleInstanceNotFoundException {
            LOG.info("onUpdateOfIdentityProviderMappings idpInstanceId=" + idpInstanceId);
            Object object = IDENTITY_PROVIDER_LOCK;
            synchronized (object) {
                ModuleConfiguration idpModuleConfiguration;
                if (CoreModule.this.identityProvider instanceof IdentityProviderWithUnsupportedOperationsFallbackHandler && (idpModuleConfiguration = BackendConnections.getModuleConfigurationOfIdentityProvider(CoreModule.this.moduleManager, idpInstanceId)) != null) {
                    IdentityProviderWithUnsupportedOperationsFallbackHandler idp = (IdentityProviderWithUnsupportedOperationsFallbackHandler)((Object)CoreModule.this.identityProvider);
                    idp.getUnsupportedIdentityProviderOperationsFallbackHandler().initialize(idpModuleConfiguration);
                }
            }
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            try {
                String idpInstanceId;
                String eventInstanceId;
                IdentityProviderConfiguration idpConfiguration = CoreModule.this.getCurrentIdentityProviderConfiguration();
                if (idpConfiguration != null && (eventInstanceId = (String)event.getProperty("moduleInstanceId")).equals(idpInstanceId = idpConfiguration.getInstanceId())) {
                    if (this.isModuleUpdatedEventOfSettings(event, this.fetchAdditionalInfoSettingNames)) {
                        LOG.info("Identity provider must not be refreshed due to a 'fetchAdditionalInfo' setting updated event: " + event);
                    } else if (this.isModuleUpdatedEventOfSettings(event, this.dynamicallyReadSettingNames)) {
                        LOG.info("Identity provider must not be refreshed due to a 'dynamicallyRead' setting updated event: " + event);
                    } else if (this.isModuleUpdatedEventOfSettings(event, Arrays.asList("identityProvider_mappings"))) {
                        this.onUpdateOfIdentityProviderMappings(idpInstanceId);
                    } else {
                        CoreModule.this.refreshIdentityProvider();
                    }
                }
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, this.getClass().getSimpleName() + ": Failed to get the configuration of the currently used identity provider.", ex);
            }
        }
    }

    private class IdentityProviderDeletedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        private IdentityProviderDeletedEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            try {
                String idpInstanceId;
                String eventInstanceId;
                IdentityProviderConfiguration idpConfiguration = CoreModule.this.getCurrentIdentityProviderConfiguration();
                if (idpConfiguration != null && (eventInstanceId = (String)event.getProperty("moduleInstanceId")).equals(idpInstanceId = idpConfiguration.getInstanceId())) {
                    CoreModule.this.refreshIdentityProvider();
                }
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, this.getClass().getSimpleName() + ": Failed to get the configuration of the currently used identity provider.", ex);
            }
        }
    }

    private class LicensedModulesSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private LicensedModulesSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting setting) {
            LOG.info(this.getClass().getSimpleName() + ".processSetting setting=...");
            CoreModule.this.updateLicenseSettingToPreventManipulation();
        }
    }

    private class BackendConnectionsModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler
    extends AbstractBackendModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler {
        private BackendConnectionsModuleLoadedAndAutoCreateModuleInstancesDoneEventHandler() {
        }

        @Override
        public void processModule(Module module) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            CoreModule.this.refreshIdentityProvider();
        }
    }

    private class LicenseChangedEventHandler
    extends AbstractEventHandler {
        private LicenseChangedEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            License license = (License)event.getProperty("license");
            CoreModule.this.updateLicenceSetting(license);
        }
    }

    private class FrontendUrlRelatedSettingsUpdatedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        private FrontendUrlRelatedSettingsUpdatedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return this.isModuleUpdatedEventOfSettings(event, Arrays.asList(CoreModule.SETTING_BPC_BASE_URL, CoreModule.SETTING_CLIENT_PATH));
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            try {
                ReplicationManager replicationManager = CoreModule.this.replicationManagerTracker.getService();
                CoreBundleConfiguration coreBundleConfiguration = CoreModule.this.coreBundleConfigurationTracker.getService();
                EventManager eventManager = CoreModule.this.eventManagerTracker.getService();
                ServerStateInfo serverStateInfo = ServerStateInfo.create(CoreModule.this.isMaintenanceModeEnabled(), replicationManager.isReplicationEnabled(), coreBundleConfiguration.getServerUUID(), coreBundleConfiguration.getBpcName(), CoreModule.this.getBpcFrontendUrl());
                eventManager.fireEvent("de/virtimo/es-bpc-plugin-send-state-info-message", "msg", serverStateInfo);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, this.getClass().getSimpleName() + ": Failed to inform the 'es-bpc-plugin' about my new server state..", ex);
            }
        }
    }

    private class CoreModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private CoreModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOG.info(this.getClass().getSimpleName() + ".processLoadedModule module=...");
            CoreModule coreModule = (CoreModule)module;
            if (coreModule.equals(CoreModule.this)) {
                CoreModule.this.identityProviderChecker = new IdentityProviderChecker(coreModule);
                CoreModule.this.identityProviderChecker.startChecker();
                CoreModule.this.apiKeysChecker = new APIKeysChecker(CoreModule.this.bundleContext, coreModule);
                CoreModule.this.apiKeysChecker.startChecker();
                try {
                    CoreModule.this.systemChecker = new SystemChecker(CoreModule.this.bundleContext, coreModule, CoreModule.this.coreBundleConfigurationTracker.getService().getSystemCheckerIntervalInSeconds());
                    CoreModule.this.systemChecker.startChecker();
                }
                catch (ServiceNotFoundException ex) {
                    LOG.log(Level.SEVERE, "Failed to start the system checker. The CoreBundleConfiguration service was not found.", ex);
                }
            }
        }
    }
}

