/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.core.GeneralMetricsCollector;
import de.virtimo.bpc.core.auth.ClientSessionsMetricsCollector;
import de.virtimo.bpc.core.backup.BackupsMetricsCollector;
import de.virtimo.bpc.core.db.DatabaseConnectionPoolCollector;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginCollector;
import de.virtimo.bpc.core.replicator.ReplicationMetricsCollector;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class PrometheusExports {
    private static final Logger LOG = Logger.getLogger(PrometheusExports.class.getName());
    private static boolean initialized = false;
    private static GeneralMetricsCollector generalMetricsCollector;
    private static ClientSessionsMetricsCollector clientSessionsMetricsCollector;
    private static ReplicationMetricsCollector replicationMetricsCollector;
    private static BackupsMetricsCollector backupsMetricsCollector;
    private static ElasticsearchBpcPluginCollector elasticsearchBpcPluginCollector;
    private static DatabaseConnectionPoolCollector databaseConnectionPoolCollector;

    public static synchronized void register(BundleContext bundleContext) {
        LOG.info("register bundleContext=" + bundleContext);
        if (!initialized) {
            generalMetricsCollector = new GeneralMetricsCollector(bundleContext);
            generalMetricsCollector.register();
            clientSessionsMetricsCollector = new ClientSessionsMetricsCollector(bundleContext);
            clientSessionsMetricsCollector.register();
            replicationMetricsCollector = new ReplicationMetricsCollector(bundleContext);
            replicationMetricsCollector.register();
            backupsMetricsCollector = new BackupsMetricsCollector(bundleContext);
            backupsMetricsCollector.register();
            elasticsearchBpcPluginCollector = new ElasticsearchBpcPluginCollector(bundleContext);
            elasticsearchBpcPluginCollector.register();
            databaseConnectionPoolCollector = new DatabaseConnectionPoolCollector(bundleContext);
            databaseConnectionPoolCollector.register();
            initialized = true;
        }
    }

    public static synchronized void unregister() {
        LOG.info("unregister");
        if (initialized) {
            generalMetricsCollector.unregister();
            generalMetricsCollector = null;
            clientSessionsMetricsCollector.unregister();
            clientSessionsMetricsCollector = null;
            replicationMetricsCollector.unregister();
            replicationMetricsCollector = null;
            backupsMetricsCollector.unregister();
            backupsMetricsCollector = null;
            elasticsearchBpcPluginCollector.unregister();
            elasticsearchBpcPluginCollector = null;
            databaseConnectionPoolCollector.unregister();
            databaseConnectionPoolCollector = null;
            initialized = false;
        }
    }
}

