/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Checker;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class SystemChecker
implements Checker {
    private static final Logger LOG = Logger.getLogger(SystemChecker.class.getName());
    public static final String INTERVAL_IN_SECONDS_PROPERTY_NAME = "de.virtimo.bpc.core.systemchecker.interval";
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> checkerHandle;
    private final BundleContext bundleContext;
    private CoreModule coreModule;
    private final int systemCheckerIntervalInSeconds;
    private BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;

    public SystemChecker(BundleContext bundleContext, CoreModule coreModule, int systemCheckerIntervalInSeconds) {
        this.bundleContext = bundleContext;
        this.coreModule = coreModule;
        this.systemCheckerIntervalInSeconds = systemCheckerIntervalInSeconds;
    }

    @Override
    public void startChecker() {
        LOG.info("startChecker");
        if (this.checkerHandle != null) {
            LOG.warning("System checker is already running");
            return;
        }
        BpcServicesTracker.stopAll(this);
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(this.bundleContext, ElasticsearchService.class);
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-systemchecker"));
        this.checkerHandle = this.executorService.scheduleWithFixedDelay(this.createCheckerRunnable(), 15L, this.systemCheckerIntervalInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void stopChecker() {
        LOG.info("stopChecker");
        if (this.checkerHandle != null) {
            if (this.checkerHandle.cancel(true)) {
                LOG.info("Running system checker cancelled");
            } else {
                LOG.warning("Could not cancel the running system checker");
            }
            this.checkerHandle = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        BpcServicesTracker.stopAll(this);
        this.coreModule = null;
    }

    private Runnable createCheckerRunnable() {
        LOG.info("createCheckerRunnable");
        return new Runnable(){

            @Override
            public void run() {
                try {
                    ElasticsearchService es = SystemChecker.this.elasticsearchServiceTracker.getService();
                    long maintenanceModeDiscLimitInMB = SystemChecker.this.coreModule.getMaintenanceModeFileSystemLimitInMB();
                    boolean fileSystemLimitReached = false;
                    Map<String, Object> fsStats = es.getFilesystemStats();
                    Map nodes = (Map)fsStats.get("nodes");
                    for (String nodeUUID : nodes.keySet()) {
                        Map nodeAttrs = (Map)nodes.get(nodeUUID);
                        String nodeName = (String)nodeAttrs.get("name");
                        Map total = (Map)((Map)nodeAttrs.get("fs")).get("total");
                        long discTotalInMB = (Long)total.get("total_in_bytes") / 1000L / 1000L;
                        long discFreeInMB = (Long)total.get("free_in_bytes") / 1000L / 1000L;
                        long discAvailableInMB = (Long)total.get("available_in_bytes") / 1000L / 1000L;
                        float availableDiskPercent = discAvailableInMB * 100L / discTotalInMB;
                        LOG.info(nodeName + " - Disc Total: " + discTotalInMB + " MB, Free: " + discFreeInMB + " MB, Avail: " + discAvailableInMB + " MB (" + availableDiskPercent + " %), Limit: " + maintenanceModeDiscLimitInMB + " MB to activate the maintenance mode");
                        if (discAvailableInMB > maintenanceModeDiscLimitInMB) continue;
                        fileSystemLimitReached = true;
                    }
                    if (fileSystemLimitReached) {
                        LOG.log(Level.SEVERE, "Reached the file system limit of " + maintenanceModeDiscLimitInMB + " MB ... activating the maintenance mode.");
                        if (!SystemChecker.this.coreModule.isMaintenanceModeEnabled()) {
                            SystemAuditLog.warning("MaintenanceModeEnabled", "Requested while reaching the file system limit of " + maintenanceModeDiscLimitInMB + " MB");
                        }
                        SystemChecker.this.coreModule.enableMaintenanceMode(true);
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Failed to perform the system check.", t);
                }
            }
        };
    }
}

