/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.util.MapUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class ViewConfigurationValidator
implements SettingValidator {
    private static final Logger LOG = Logger.getLogger(ViewConfigurationValidator.class.getName());
    private ArrayList<String> viewItemIds = new ArrayList();

    @Override
    public void destroy() {
    }

    @Override
    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        return moduleId.equalsIgnoreCase("_core");
    }

    @Override
    public boolean canValidate(Setting setting) {
        List<String> settingsToValidate = Arrays.asList("viewConfiguration");
        return settingsToValidate.contains(setting.getName());
    }

    @Override
    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        LOG.info("validate setting:" + setting);
        if (setting.getName().equalsIgnoreCase("viewConfiguration")) {
            Object viewConfigurationObject = setting.getValue();
            if (!(viewConfigurationObject instanceof Map)) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "viewConfiguration must be a map", MapUtil.mapOf("field", "viewConfiguration"));
            }
            Map viewConfiguration = (Map)viewConfigurationObject;
            ArrayList views = (ArrayList)viewConfiguration.get("views");
            this.viewItemIds = new ArrayList();
            for (Object view : views) {
                Map currentView = (Map)view;
                this.checkViewItemId(currentView);
            }
        }
        return null;
    }

    @Override
    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String instanceType, Map<String, Setting> settings) throws ValidationException {
        LOG.info("validate moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId + ", instanceType=" + instanceType + ", settings:...");
        return null;
    }

    void checkInViewItems(ArrayList items) throws ValidationException {
        for (Object item : items) {
            if (!(item instanceof Map)) continue;
            this.checkViewItemId((Map)item);
        }
    }

    void checkViewItemId(Map view) throws ValidationException {
        for (Map.Entry o : view.entrySet()) {
            Map.Entry item = o;
            if (!Objects.equals("viewItemId", (String)item.getKey())) continue;
            if (!this.viewItemIds.contains(item.getValue())) {
                if (item.getValue() instanceof Integer) {
                    this.viewItemIds.add(Integer.toString((Integer)item.getValue()));
                    continue;
                }
                if (!(item.getValue() instanceof String) || item.getValue().equals("null") || item.getValue().equals("")) continue;
                this.viewItemIds.add((String)item.getValue());
                continue;
            }
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "viewItemId " + item.getValue() + " is defined multiple times ", MapUtil.mapOf("field", "viewConfiguration"));
        }
        if (view.containsKey("items")) {
            this.checkInViewItems((ArrayList)view.get("items"));
        }
    }
}

