/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.apikey;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Checker;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.MaintenanceModeEnabledException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.apikey.APIKey;
import de.virtimo.bpc.core.apikey.APIKeys;
import de.virtimo.bpc.core.notification.ExpirationNotificationEvaluator;
import de.virtimo.bpc.core.notification.ExpirationNotificationSettings;
import de.virtimo.bpc.core.notification.Notification;
import de.virtimo.bpc.core.notification.NotificationException;
import de.virtimo.bpc.core.notification.NotificationManager;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class APIKeysChecker
implements Checker {
    private static final Logger LOG = Logger.getLogger(APIKeysChecker.class.getName());
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> checkerHandle;
    private final BundleContext bundleContext;
    private CoreModule coreModule;
    private BpcServicesTracker<NotificationManager> notificationManagerTracker;

    public APIKeysChecker(BundleContext bundleContext, CoreModule coreModule) {
        this.bundleContext = bundleContext;
        this.coreModule = coreModule;
    }

    @Override
    public void startChecker() {
        LOG.info("startChecker");
        if (this.checkerHandle != null) {
            LOG.info("API key checker is already running");
            return;
        }
        BpcServicesTracker.stopAll(this);
        this.notificationManagerTracker = new BpcServicesTracker<NotificationManager>(this.bundleContext, NotificationManager.class);
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-apikeyschecker"));
        this.checkerHandle = this.executorService.scheduleWithFixedDelay(this.createCheckerRunnable(), 0L, 60L, TimeUnit.SECONDS);
    }

    @Override
    public void stopChecker() {
        LOG.info("stopChecker");
        if (this.checkerHandle != null) {
            if (this.checkerHandle.cancel(true)) {
                LOG.info("Running api key checker cancelled");
            } else {
                LOG.warning("Could not cancel the running api key checker");
            }
            this.checkerHandle = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        BpcServicesTracker.stopAll(this);
        this.coreModule = null;
    }

    private Runnable createCheckerRunnable() {
        LOG.info("createCheckerRunnable");
        return new Runnable(){

            @Override
            public void run() {
                LOG.info("APIKeysChecker running ...");
                try {
                    NotificationManager notificationManager = APIKeysChecker.this.notificationManagerTracker.getService();
                    ExpirationNotificationSettings apiKeysExpirationNotificationSettings = ExpirationNotificationSettings.of(APIKeysChecker.this.coreModule.getConfiguration().getSetting("apiKeysNotifications"));
                    APIKeys apiKeys = APIKeys.of(APIKeysChecker.this.coreModule.getConfiguration().getSetting("apiKeys"));
                    for (APIKey apiKey : apiKeys) {
                        APIKeysChecker.this.check(apiKey, apiKeysExpirationNotificationSettings, notificationManager);
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Failed to check for API keys expiring soon. Unexpected exception occurred.", t);
                }
            }
        };
    }

    private void check(APIKey apiKey, ExpirationNotificationSettings apiKeysExpirationNotificationSettings, NotificationManager notificationManager) throws MaintenanceModeEnabledException, ServiceNotFoundException, NotificationException, ElasticsearchRelatedException {
        LOG.info("check apiKey=..., apiKeysExpirationNotificationSettings=..., notificationManager=...");
        if (apiKey == null) {
            return;
        }
        if (!apiKey.isValid()) {
            LOG.warning("The API key with the ID '" + apiKey.getId() + "' is invalid and gets ignored for the expiration check.");
            return;
        }
        if (apiKey.isNotActive()) {
            LOG.info("The API key with the ID '" + apiKey.getId() + "' is is not active yet and gets ignored for the expiration check.");
            return;
        }
        if (apiKey.isExpired()) {
            LOG.info("The API key with the ID '" + apiKey.getId() + "' is already expired and gets ignored for the expiration check.");
            return;
        }
        ExpirationNotificationEvaluator expirationNotificationEvaluator = new ExpirationNotificationEvaluator(apiKey.getExpiresOnAsDate().toLocalDate(), apiKeysExpirationNotificationSettings);
        if (expirationNotificationEvaluator.isTimeToNotify()) {
            LOG.info("The API key with the ID '" + apiKey.getId() + "' will expire soon. Adding a expires soon notification.");
            notificationManager.addNotification(this.createApiKeyWillExpireSoonNotification(apiKey, expirationNotificationEvaluator));
        } else {
            LOG.info("The API key with the ID '" + apiKey.getId() + "' will expire in " + expirationNotificationEvaluator.getExpiresInDays() + " days on " + apiKey.getExpirationDate() + ", but no notification must be added for now.");
        }
    }

    private Notification createApiKeyWillExpireSoonNotification(APIKey apiKey, ExpirationNotificationEvaluator expirationNotificationEvaluator) {
        LOG.info("createApiKeyWillExpireSoonNotification apiKey=..., expirationNotificationEvaluator=...");
        return new Notification.Builder().originator("_core").type("link", Map.of("targetModule", "_core", "route", List.of("_core", "apiKeys", "api", apiKey.getId()))).subject("API key expires in " + expirationNotificationEvaluator.getExpiresInDays() + " days").message("The API key with the ID " + apiKey.getId() + " expires on " + apiKey.getExpirationDate() + " (" + expirationNotificationEvaluator.getExpiresInPeriod().getYears() + " years, " + expirationNotificationEvaluator.getExpiresInPeriod().getMonths() + " months and " + expirationNotificationEvaluator.getExpiresInPeriod().getDays() + " days)").recipients(SetUtil.setOf("bpcadmin"), "role").priority(Notification.Priority.SILENT).build();
    }
}

