/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auditlog;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.AbstractMaintenanceModeAcknowledgeEventHandler;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.auditlog.AuditLogLevel;
import de.virtimo.bpc.api.auditlog.AuditLogger;
import de.virtimo.bpc.api.auditlog.AuditLoggerException;
import de.virtimo.bpc.api.es.BpcIndexCreateCallable;
import de.virtimo.bpc.api.es.BpcIndexState;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.service.IndexCleanupService;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class ElasticsearchAuditLogger
implements AuditLogger {
    private static final Logger LOG = Logger.getLogger(ElasticsearchAuditLogger.class.getName());
    public static final String INDEX_NAME = "bpc-auditlog";
    public static final boolean DEFAULT_BACKUP_ENABLED = true;
    public static final long DEFAULT_BACKUP_INTERVAL_IN_SECONDS = 86400L;
    public static final long DEFAULT_KEEP_BACKUPS_DURATION_IN_SECONDS = 2592000L;
    private ScheduledExecutorService executorService;
    private final int cleanupPeriodInMinutes;
    private final String deleteEntriesOlderThan;
    private final boolean backupEnabled;
    private final long backupIntervalInSeconds;
    private final long keepBackupsDurationInSeconds;
    private final BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private final BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private final BpcServicesTracker<BackupManager> backupManagerTracker;
    private final BpcServicesTracker<IndexCleanupService> indexCleanupServiceTracker;
    private final EventRegistration eventRegistration;
    private boolean bpcAuditlogIndexRestoreInProgress = false;

    public ElasticsearchAuditLogger(BundleContext bundleContext, CoreBundleConfiguration coreBundleConfiguration) {
        this.cleanupPeriodInMinutes = coreBundleConfiguration.getSystemPropertyValueAsInt(ElasticsearchAuditLogger.class.getName() + ".auditlog.cleanupPeriodInMinutes", -1);
        this.deleteEntriesOlderThan = coreBundleConfiguration.getSystemPropertyValueAsString(ElasticsearchAuditLogger.class.getName() + ".auditlog.deleteEntriesOlderThan", null);
        this.backupEnabled = coreBundleConfiguration.getSystemPropertyValueAsBoolean(ElasticsearchAuditLogger.class.getName() + ".auditlog.backupEnabled", true);
        this.backupIntervalInSeconds = coreBundleConfiguration.getSystemPropertyValueAsLong(ElasticsearchAuditLogger.class.getName() + ".auditlog.backupIntervalInSeconds", 86400L);
        this.keepBackupsDurationInSeconds = coreBundleConfiguration.getSystemPropertyValueAsLong(ElasticsearchAuditLogger.class.getName() + ".auditlog.keepBackupsDurationInSeconds", 2592000L);
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(bundleContext, ElasticsearchService.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.backupManagerTracker = new BpcServicesTracker<BackupManager>(bundleContext, BackupManager.class);
        this.indexCleanupServiceTracker = new BpcServicesTracker<IndexCleanupService>(bundleContext, IndexCleanupService.class);
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-auditlog-elasticsearch"));
        this.restartBackupJob();
        this.startAuditLoggerIndexCleanupTask();
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forMaintenanceModeAcknowledgeEvents(new MaintenanceModeChangedEventHandler(bundleContext));
        this.eventRegistration.forIndexRestoreFromBackupStartEvents(new IndexBackupRestoreStartEventHandler());
        this.eventRegistration.forIndexRestoredFromBackupDoneEvents(new IndexBackupRestoreDoneEventHandler());
    }

    @Override
    public AuditLogLevel getDefaultAuditLogLevel() {
        return AuditLogLevel.INFO;
    }

    @Override
    public void stop() {
        LOG.info("stop");
        this.stopBackupJob();
        this.stopAuditLoggerIndexCleanupTask();
        if (this.executorService != null) {
            try {
                this.executorService.shutdownNow();
                this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
                this.executorService = null;
            }
            catch (InterruptedException | RuntimeException ex) {
                LOG.log(Level.SEVERE, "Could not shutdown the audit log cleanup task");
            }
        }
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
    }

    private synchronized ElasticsearchService getElasticsearchServiceWithPreparedAuditLogIndex() throws AuditLoggerException {
        LOG.info("getElasticsearchServiceWithPreparedAuditLogIndex");
        try {
            ElasticsearchService es = this.elasticsearchServiceTracker.getService();
            BpcIndexState bpcAuditLogIndexState = es.getIndexState(INDEX_NAME);
            bpcAuditLogIndexState.prepareUsing(new BpcIndexCreateCallable(){

                @Override
                public String createIndex(ElasticsearchService es) throws ElasticsearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                    return es.getManagedIndicesHandler().createManagedIndex(ElasticsearchAuditLogger.INDEX_NAME);
                }
            });
            return es;
        }
        catch (ServiceNotFoundException ex) {
            throw new AuditLoggerException((ErrorCode)CoreErrorCode.AUDIT_LOGGER_LOGGING_FAILED, "Elasticsearch service is not registered.");
        }
        catch (Exception ex) {
            throw new AuditLoggerException((ErrorCode)CoreErrorCode.AUDIT_LOGGER_LOGGING_FAILED, (Throwable)ex);
        }
    }

    @Override
    public FutureTask<Exception> log(List<Map<String, Object>> logEntries) throws AuditLoggerException {
        LOG.info("log logEntries=...");
        if (logEntries == null || logEntries.isEmpty()) {
            return null;
        }
        if (this.bpcAuditlogIndexRestoreInProgress) {
            LOG.warning("Audit logging is ignored while a audit log backup gets restored.");
            return null;
        }
        final ElasticsearchService es = this.getElasticsearchServiceWithPreparedAuditLogIndex();
        try {
            RestHighLevelClient esClient = es.getClient();
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (Map<String, Object> logEntry : logEntries) {
                bulkRequest.add(new IndexRequest(INDEX_NAME).source(logEntry, XContentType.JSON));
            }
            final BulkResponse bulkResponse = esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                throw new AuditLoggerException((ErrorCode)CoreErrorCode.AUDIT_LOGGER_LOGGING_FAILED, "Audit log indexing failed: ${error}", MapUtil.mapOf("error", bulkResponse.buildFailureMessage()));
            }
            return new FutureTask<Exception>(new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        ElasticsearchAuditLogger.this.percolatorsManagerTracker.getService().informClientsAboutReplicatedData(es, ElasticsearchAuditLogger.INDEX_NAME, bulkResponse);
                        return null;
                    }
                    catch (ServiceNotFoundException ex) {
                        LOG.log(Level.WARNING, "Failed to inform clients about new log entry. Can be ignored when a shutdown is in progress.");
                        return ex;
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                        return ex;
                    }
                }
            });
        }
        catch (IOException | ElasticsearchException ex) {
            throw new AuditLoggerException((ErrorCode)CoreErrorCode.AUDIT_LOGGER_LOGGING_FAILED, "Audit log indexing failed: ${error}", MapUtil.mapOf("error", ex.getMessage()));
        }
    }

    private void stopBackupJob() {
        LOG.info("stopBackupJob");
        try {
            this.backupManagerTracker.getService().stopBackupJob("core:audit-logger");
        }
        catch (ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Failed to get the backup manager service to stop the audit logger backup job.");
        }
    }

    private void restartBackupJob() {
        LOG.info("restartBackupJob");
        try {
            this.stopBackupJob();
            BackupSetting backupSetting = new BackupSetting(this.backupEnabled, this.backupIntervalInSeconds, this.keepBackupsDurationInSeconds, new String[]{INDEX_NAME});
            this.backupManagerTracker.getService().scheduleBackupJobWithSettings("core:audit-logger", backupSetting);
        }
        catch (ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Failed to get the backup manager service to schedule the audit logger backup job.");
        }
    }

    private void stopAuditLoggerIndexCleanupTask() {
        LOG.info("stopAuditLoggerIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().cancelAndRemoveScheduledDeleteTask(INDEX_NAME);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to stop/cancel the running cleanup task for the index 'bpc-auditlog'.", ex);
        }
    }

    private void startAuditLoggerIndexCleanupTask() {
        LOG.info("startAuditLoggerIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().scheduleDeleteTask(INDEX_NAME, "timestamp", this.deleteEntriesOlderThan, this.cleanupPeriodInMinutes, TimeUnit.MINUTES);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to schedule the index cleanup task for the index 'bpc-auditlog'.", ex);
        }
    }

    private class MaintenanceModeChangedEventHandler
    extends AbstractMaintenanceModeAcknowledgeEventHandler {
        public MaintenanceModeChangedEventHandler(BundleContext bundleContext) {
            super(bundleContext, "_core");
        }

        @Override
        public void processNewMaintenanceMode(boolean maintenanceModeEnabled) {
            LOG.info(this.getClass().getSimpleName() + ".processNewMaintenanceMode enabled=" + maintenanceModeEnabled);
            try {
                if (maintenanceModeEnabled) {
                    ElasticsearchAuditLogger.this.stopBackupJob();
                } else {
                    ElasticsearchAuditLogger.this.restartBackupJob();
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to process the maintenance mode changed event.", ex);
            }
        }
    }

    private class IndexBackupRestoreStartEventHandler
    extends AbstractEventHandler {
        private IndexBackupRestoreStartEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            Object aliases;
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            if (event != null && (aliases = event.getProperty("aliases")) instanceof List && ((List)aliases).contains(ElasticsearchAuditLogger.INDEX_NAME)) {
                ElasticsearchAuditLogger.this.bpcAuditlogIndexRestoreInProgress = true;
            }
        }
    }

    private class IndexBackupRestoreDoneEventHandler
    extends AbstractEventHandler {
        private IndexBackupRestoreDoneEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            Object aliases;
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            if (event != null && (aliases = event.getProperty("aliases")) instanceof List && ((List)aliases).contains(ElasticsearchAuditLogger.INDEX_NAME)) {
                ElasticsearchAuditLogger.this.bpcAuditlogIndexRestoreInProgress = false;
            }
        }
    }
}

