/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.auth.InactiveOrganisation;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.core.auth.BasicHttpAuthenticationFeature;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RightFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.utils.RestWebServiceClientFactory;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class IdentityProviderAdditionalInfoApplyer {
    private static final Logger LOG = Logger.getLogger(IdentityProviderAdditionalInfoApplyer.class.getName());
    private final Set<Organisation> organisations;
    private final Set<InactiveOrganisation> inactiveOrganisations;
    private final Set<Role> roles;
    private final Set<Right> rights;

    public IdentityProviderAdditionalInfoApplyer(Set<Organisation> organisations, Set<InactiveOrganisation> inactiveOrganisations, Set<Role> roles, Set<Right> rights) {
        this.organisations = organisations == null ? new HashSet() : organisations;
        this.inactiveOrganisations = inactiveOrganisations == null ? new HashSet() : inactiveOrganisations;
        this.roles = roles == null ? new HashSet() : roles;
        this.rights = rights == null ? new HashSet() : rights;
    }

    public void apply(IdentityProviderConfiguration idpConfiguration, String loginName) {
        try {
            Map<String, Object> additionalInfos = this.fetchAdditionalInfos(idpConfiguration, loginName);
            if (additionalInfos != null) {
                String[] additionalRights;
                String[] additionalRoles;
                String[] additionalInactiveOrganisations;
                String additionEntriesPrefix = idpConfiguration.getFetchAdditionalInfoEntriesPrefix();
                String[] additionalOrganisations = MapUtil.getValueAsStringArray(additionalInfos, "organisations", null);
                if (additionalOrganisations != null) {
                    for (String additionalOrganisation : additionalOrganisations) {
                        String organizationName = additionEntriesPrefix + additionalOrganisation;
                        this.organisations.add(OrganisationFactory.getOrganisation(organizationName));
                    }
                }
                if ((additionalInactiveOrganisations = MapUtil.getValueAsStringArray(additionalInfos, "inactiveOrganisations", null)) != null) {
                    for (String additionalInactiveOrganisation : additionalInactiveOrganisations) {
                        String organizationName = additionEntriesPrefix + additionalInactiveOrganisation;
                        this.inactiveOrganisations.add(OrganisationFactory.getInactiveOrganisation(organizationName));
                    }
                }
                if ((additionalRoles = MapUtil.getValueAsStringArray(additionalInfos, "roles", null)) != null) {
                    for (String additionalRole : additionalRoles) {
                        String roleName = additionEntriesPrefix + additionalRole;
                        if ("bpcadmin".equalsIgnoreCase(roleName)) {
                            LOG.log(Level.WARNING, "adding role {0} by additionalUserInfo is forbidden, role is ignored", new Object[]{roleName});
                            continue;
                        }
                        LOG.log(Level.FINEST, "add additional role {0}", new Object[]{roleName});
                        this.roles.add(RolesFactory.getRole(roleName));
                    }
                }
                if ((additionalRights = MapUtil.getValueAsStringArray(additionalInfos, "rights", null)) != null) {
                    for (String additionalRight : additionalRights) {
                        String rightName = additionEntriesPrefix + additionalRight;
                        LOG.log(Level.FINEST, "add additional right {0}", new Object[]{rightName});
                        this.rights.add(RightFactory.getRight(rightName));
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to fetch and add additional orgs, roles and rights to user session", ex);
        }
    }

    private Map<String, Object> fetchAdditionalInfos(IdentityProviderConfiguration idpConfiguration, String loginName) throws IdentityProviderException {
        LOG.info("fetchAdditionalInfos idpConfiguration=..., loginName=" + loginName);
        if (idpConfiguration == null) {
            return null;
        }
        String additionalInfoUrl = idpConfiguration.getFetchAdditionalInfoUrl();
        if (StringUtil.isNullOrEmpty(additionalInfoUrl)) {
            LOG.warning("Not able to fetch additional infos. The URL is not set.");
            return null;
        }
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("username", loginName);
        postData.put("organisations", this.organisations);
        postData.put("inactiveOrganisations", this.inactiveOrganisations);
        postData.put("roles", this.roles);
        postData.put("rights", this.rights);
        try (Client client = null;){
            Response response;
            client = RestWebServiceClientFactory.newClient(false);
            String additionalInfoUrlBasicAuthUsername = idpConfiguration.getFetchAdditionalInfoUrlBasicAuthUsername();
            String additionalInfoUrlBasicAuthPassword = idpConfiguration.getFetchAdditionalInfoUrlBasicAuthPassword();
            if (!StringUtil.isNullOrEmpty(additionalInfoUrlBasicAuthUsername) && !StringUtil.isNullOrEmpty(additionalInfoUrlBasicAuthPassword)) {
                client.register((Object)new BasicHttpAuthenticationFeature(additionalInfoUrlBasicAuthUsername, additionalInfoUrlBasicAuthPassword));
            }
            if ((response = ((Client)client.register(JacksonJsonProvider.class)).target(new URI(additionalInfoUrl)).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)JsonUtil.getInstance().convertPojoToJsonString(postData), (MediaType)MediaType.APPLICATION_JSON_TYPE))).getStatus() != Response.Status.OK.getStatusCode()) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNEXPECTED_STATUS_CODE, "Bad status code at fetching additional infos during login: '${statusCode}' (expected ${expectedStatusCode})", MapUtil.mapOf("statusCode", response.getStatus(), "expectedStatusCode", Response.Status.OK.getStatusCode(), "url", additionalInfoUrl));
            }
            String responseString = (String)response.readEntity(String.class);
            if (StringUtil.isNullOrEmpty(responseString)) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_RESPONSE_MISSING, "Getting JSON from additional infos URL failed. Did not received a response from '${url}'", MapUtil.mapOf("url", additionalInfoUrl));
            }
            Map<String, Object> map = JsonUtil.getInstance().jsonStringAsMap(responseString);
            return map;
        }
    }
}

