/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.core.auth.IdentityProviderMappings;
import de.virtimo.bpc.core.es.ModuleConfigurationImpl;
import java.util.Map;
import java.util.logging.Logger;

public class IdentityProviderConfiguration {
    private static final Logger LOG = Logger.getLogger(IdentityProviderConfiguration.class.getName());
    private final ModuleConfiguration moduleConfiguration;

    public IdentityProviderConfiguration(ModuleConfiguration moduleConfiguration) {
        this.moduleConfiguration = moduleConfiguration;
    }

    public String getInstanceId() {
        if (this.moduleConfiguration instanceof ModuleConfigurationImpl) {
            return ((ModuleConfigurationImpl)this.moduleConfiguration).getInstanceId();
        }
        return null;
    }

    public ModuleConfiguration getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    public String getIdentityProviderName() {
        return this.moduleConfiguration.getSettingValue("identityProvider").asString("karaf");
    }

    public String getIdentityProviderUrl() {
        return this.moduleConfiguration.getSettingValue("identityProvider.url").asString(null);
    }

    public int getSessionExpirationInMinutes() {
        return this.moduleConfiguration.getSettingValue("identityProvider_sessionExpirationMinutes").asInt(480);
    }

    public IdentityProviderMappings getIdentityProviderMappings() {
        Map identityProviderMappingsMap = this.moduleConfiguration.getSettingValue("identityProvider_mappings").asMap(null);
        return identityProviderMappingsMap == null ? null : new IdentityProviderMappings(identityProviderMappingsMap);
    }

    public Map<String, Object> getSpecificConfigurationAsMap() {
        return this.moduleConfiguration.getSettingValue("identityProvider_configuration").asMap(null);
    }

    public String getUserSelfServiceUrl() {
        return this.moduleConfiguration.getSettingValue("identityProvider_ussUrl").asString(null);
    }

    public String getPasswordValidationRegExp() {
        return this.moduleConfiguration.getSettingValue("identityProvider_pwdValidationRegExp").asString(null);
    }

    public boolean isFetchAdditionalInfoEnabled() {
        return this.moduleConfiguration.getSettingValue("identityProvider.additionalInfoEnabled").asBoolean(false);
    }

    public String getFetchAdditionalInfoEntriesPrefix() {
        return this.moduleConfiguration.getSettingValue("identityProvider.additionalInfoEntriesPrefix").asString();
    }

    public String getFetchAdditionalInfoUrl() {
        return this.moduleConfiguration.getSettingValue("identityProvider.additionalInfoUrl").asString(null);
    }

    public String getFetchAdditionalInfoUrlBasicAuthUsername() {
        return this.moduleConfiguration.getSettingValue("identityProvider.additionalInfoUrlBasicAuthUsername").asString(null);
    }

    public String getFetchAdditionalInfoUrlBasicAuthPassword() {
        return this.moduleConfiguration.getSettingValue("identityProvider.additionalInfoUrlBasicAuthPassword").asString(null);
    }
}

