/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas.jdbc;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.util.DictionaryUtil;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class JDBCJaasOptions {
    private static final Logger LOG = Logger.getLogger(JDBCJaasOptions.class.getName());
    private static final String PID_VIRTIMO_JDBC_JAAS = "de.virtimo.bpc.core.auth.jaas.jdbc";
    private static final String PID_KARAF_JAAS = "org.apache.karaf.jaas";

    public static Map<String, Object> updatedOptions(Map<String, ?> options) {
        Dictionary<String, Object> virtimoJaasJdbcProps;
        HashMap<String, Object> updatedOptions = new HashMap<String, Object>();
        if (options != null) {
            updatedOptions.putAll(options);
        }
        if ((virtimoJaasJdbcProps = JDBCJaasOptions.loadConfig(PID_VIRTIMO_JDBC_JAAS)) != null) {
            updatedOptions.putAll(DictionaryUtil.convertToMap(virtimoJaasJdbcProps));
        } else {
            Dictionary<String, Object> karafJaasProps = JDBCJaasOptions.loadConfig(PID_KARAF_JAAS);
            if (karafJaasProps != null) {
                updatedOptions.putAll(DictionaryUtil.convertToMap(karafJaasProps));
            }
        }
        return updatedOptions;
    }

    private static Dictionary<String, Object> loadConfig(String pid) {
        BundleContext bundleContext = FrameworkUtil.getBundle(JDBCJaasOptions.class).getBundleContext();
        BpcServicesTracker<ConfigurationAdmin> configurationAdminTracker = new BpcServicesTracker<ConfigurationAdmin>(bundleContext, ConfigurationAdmin.class);
        try {
            Configuration conf = configurationAdminTracker.getService().getConfiguration(pid);
            Dictionary dictionary = conf.getProcessedProperties(null);
            configurationAdminTracker.close();
            return dictionary;
        }
        catch (Throwable throwable) {
            try {
                try {
                    configurationAdminTracker.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                LOG.warning("Failed to load the configuration of PID: " + pid);
                return null;
            }
        }
    }
}

