/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.oidc;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.core.auth.oidc.KeycloakAdminClientBuilder;
import de.virtimo.bpc.core.auth.oidc.KeycloakException;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.utils.RestWebServiceClientFactory;
import de.virtimo.bpc.core.utils.RestWebServiceClientInitException;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public class KeycloakAdminClient {
    private static final Logger LOG = Logger.getLogger(KeycloakAdminClient.class.getName());
    private final String serverUrl;
    private final String realm;
    private final String clientId;
    private final String username;
    private final String password;
    private final boolean allowUntrustedConnections;
    private final long connectionTimeoutInSeconds;
    private Tokens tokens;
    private static final Object KEYCLOAK_CALLS_LOCK = new Object();

    public KeycloakAdminClient(String serverUrl, String realm, String clientId, String username, String password, boolean allowUntrustedConnections, long connectionTimeoutInSeconds) {
        this.serverUrl = serverUrl;
        this.realm = realm;
        this.clientId = clientId;
        this.username = username;
        this.password = password;
        this.allowUntrustedConnections = allowUntrustedConnections;
        this.connectionTimeoutInSeconds = connectionTimeoutInSeconds;
        this.tokens = null;
    }

    public void close() {
    }

    public void validate() throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("validate");
        this._fetchTokens();
    }

    private synchronized String getAccessToken() throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getAccessToken");
        try {
            if (this.tokens == null || this.tokens.getRefreshToken().isExpired()) {
                this.tokens = this._fetchTokens();
            } else if (this.tokens.getAccessToken().isExpired()) {
                this.tokens = this._fetchRefreshedTokens();
            }
            return this.tokens.getAccessToken().getValue();
        }
        catch (Exception ex) {
            this.tokens = null;
            throw ex;
        }
    }

    private Tokens _fetchTokens() throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("_fetchTokens");
        try (Client client = null;){
            client = RestWebServiceClientFactory.newClient(this.allowUntrustedConnections);
            long requestTime = System.currentTimeMillis();
            Form form = new Form().param("username", this.username).param("password", this.password).param("grant_type", "password").param("client_id", this.clientId);
            WebTarget target = client.target(this.serverUrl + "/realms/" + this.realm + "/protocol/openid-connect/token");
            Future response = target.request(new String[]{"application/x-www-form-urlencoded"}).accept(new String[]{"application/json"}).buildPost(Entity.form((Form)form)).submit(Response.class);
            Response r = (Response)response.get(this.connectionTimeoutInSeconds, TimeUnit.SECONDS);
            if (r.getStatus() == Response.Status.OK.getStatusCode()) {
                Tokens tokens = new Tokens(requestTime, r);
                return tokens;
            }
            try {
                if (r.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                    throw new IOException("Not found: " + target.getUri());
                }
                String respAsString = (String)r.readEntity(String.class);
                Map<String, Object> errorRespMap = JsonUtil.getInstance().jsonStringAsMap(respAsString);
                throw new KeycloakException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_TOKEN_ERROR, "CORE_ERROR_IDENTITY_PROVIDER_KEYCLOAK_GRANT_ACCESS_TOKEN", errorRespMap);
            }
            catch (ExecutionException ex) {
                Throwable causedExecutionException = ex.getCause();
                if (causedExecutionException instanceof ProcessingException) {
                    ProcessingException processingException = (ProcessingException)causedExecutionException;
                    Throwable causedProcessingException = processingException.getCause();
                    if (causedProcessingException instanceof IOException) {
                        throw (IOException)causedProcessingException;
                    }
                    if (causedProcessingException instanceof IllegalArgumentException) {
                        throw (IllegalArgumentException)causedProcessingException;
                    }
                }
                throw ex;
            }
        }
    }

    private Tokens _fetchRefreshedTokens() throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("_fetchRefreshedTokens");
        try (Client client = null;){
            client = RestWebServiceClientFactory.newClient(this.allowUntrustedConnections);
            long requestTime = System.currentTimeMillis();
            Form form = new Form().param("grant_type", "refresh_token").param("refresh_token", this.tokens.getRefreshToken().getValue()).param("client_id", this.clientId);
            WebTarget target = client.target(this.serverUrl + "/realms/" + this.realm + "/protocol/openid-connect/token");
            Future response = target.request(new String[]{"application/x-www-form-urlencoded"}).accept(new String[]{"application/json"}).buildPost(Entity.form((Form)form)).submit(Response.class);
            Response r = (Response)response.get(this.connectionTimeoutInSeconds, TimeUnit.SECONDS);
            if (r.getStatus() == Response.Status.OK.getStatusCode()) {
                Tokens tokens = new Tokens(requestTime, r);
                return tokens;
            }
            String respAsString = (String)r.readEntity(String.class);
            Map<String, Object> errorRespMap = JsonUtil.getInstance().jsonStringAsMap(respAsString);
            throw new KeycloakException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_TOKEN_ERROR, "CORE_ERROR_IDENTITY_PROVIDER_KEYCLOAK_REFRESH_ACCESS_TOKEN", errorRespMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJsonStringResponse(String endpointUri, Map<String, Object> queryParams) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getJsonStringResponse endpointUri=" + endpointUri + ", queryParams=" + queryParams);
        Object object = KEYCLOAK_CALLS_LOCK;
        synchronized (object) {
            String string;
            block9: {
                Client client = null;
                try {
                    client = RestWebServiceClientFactory.newClient(this.allowUntrustedConnections);
                    UriBuilder uriBuilder = UriBuilder.fromUri((String)endpointUri);
                    if (queryParams != null) {
                        for (String queryParamName : queryParams.keySet()) {
                            Object queryParamValue = queryParams.get(queryParamName);
                            uriBuilder.queryParam(queryParamName, new Object[]{queryParamValue});
                        }
                    }
                    WebTarget target = client.target(uriBuilder);
                    Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
                    invocationBuilder.accept(new String[]{"application/json"});
                    invocationBuilder.header("Authorization", (Object)("Bearer " + this.getAccessToken()));
                    Future response = invocationBuilder.buildGet().submit(Response.class);
                    Response r = (Response)response.get(this.connectionTimeoutInSeconds, TimeUnit.SECONDS);
                    string = (String)r.readEntity(String.class);
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    if (client != null) {
                        client.close();
                    }
                    throw throwable;
                }
                client.close();
            }
            return string;
        }
    }

    private List<Map<String, Object>> getJsonListResponse(String endpointUri, Map<String, Object> queryParams) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getJsonListResponse endpointUri=" + endpointUri + ", queryParams=" + queryParams);
        String respAsString = this.getJsonStringResponse(endpointUri, queryParams);
        return JsonUtil.getInstance().jsonStringAsList(respAsString);
    }

    private Map<String, Object> getJsonMapResponse(String endpointUri, Map<String, Object> queryParams) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getJsonMapResponse endpointUri=" + endpointUri + ", queryParams=" + queryParams);
        String respAsString = this.getJsonStringResponse(endpointUri, queryParams);
        return JsonUtil.getInstance().jsonStringAsMap(respAsString);
    }

    private Map<String, Object> extractError(Response r) {
        String respAsString = (String)r.readEntity(String.class);
        try {
            return JsonUtil.getInstance().jsonStringAsMap(respAsString);
        }
        catch (Exception ex) {
            return MapUtil.mapOf("error", "unexpected", "error_description", respAsString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> putJson(String endpointUri, String jsonBody) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("putJson endpointUri=" + endpointUri + ", jsonBody=...");
        Object object = KEYCLOAK_CALLS_LOCK;
        synchronized (object) {
            try (Client client = null;){
                client = RestWebServiceClientFactory.newClient(this.allowUntrustedConnections);
                WebTarget target = client.target(endpointUri);
                Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
                invocationBuilder.accept(new String[]{"application/json"});
                invocationBuilder.header("Authorization", (Object)("Bearer " + this.getAccessToken()));
                Future response = invocationBuilder.buildPut(Entity.json((Object)jsonBody)).submit(Response.class);
                Response r = (Response)response.get(this.connectionTimeoutInSeconds, TimeUnit.SECONDS);
                if (Response.Status.Family.familyOf((int)r.getStatus()).equals((Object)Response.Status.Family.SUCCESSFUL)) {
                    Map<String, Object> map2 = null;
                    return map2;
                }
                Map<String, Object> map = this.extractError(r);
                return map;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> call(String httpMethod, String endpointUri) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("call httpMethod=" + httpMethod + ", endpointUri=" + endpointUri);
        Object object = KEYCLOAK_CALLS_LOCK;
        synchronized (object) {
            try (Client client = null;){
                client = RestWebServiceClientFactory.newClient(this.allowUntrustedConnections);
                WebTarget target = client.target(endpointUri);
                Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
                invocationBuilder.accept(new String[]{"application/json"});
                invocationBuilder.header("Authorization", (Object)("Bearer " + this.getAccessToken()));
                Future response = invocationBuilder.build(httpMethod).submit(Response.class);
                Response r = (Response)response.get(this.connectionTimeoutInSeconds, TimeUnit.SECONDS);
                if (Response.Status.Family.familyOf((int)r.getStatus()).equals((Object)Response.Status.Family.SUCCESSFUL)) {
                    Map<String, Object> map2 = null;
                    return map2;
                }
                Map<String, Object> map = this.extractError(r);
                return map;
            }
        }
    }

    public List<Map<String, Object>> getRealms() throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getRealms");
        return this.getJsonListResponse(this.serverUrl + "/admin/realms", null);
    }

    public Map<String, Object> getRealm(String realm) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getRealm realm=" + realm);
        return this.getJsonMapResponse(this.serverUrl + "/admin/realms/" + realm, null);
    }

    public List<Map<String, Object>> getClients(String realm) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getClients realm=" + realm);
        return this.getJsonListResponse(this.serverUrl + "/admin/realms/" + realm + "/clients", null);
    }

    public Map<String, Object> getClient(String realm, String clientId) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getClient realm=" + realm + ", clientId=" + clientId);
        List<Map<String, Object>> foundClients = this.getJsonListResponse(this.serverUrl + "/admin/realms/" + realm + "/clients", MapUtil.mapOf("clientId", clientId));
        return foundClients != null && foundClients.size() == 1 ? foundClients.get(0) : null;
    }

    public List<Map<String, Object>> getUsers(String realm) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getUsers realm=" + realm);
        return this.getJsonListResponse(this.serverUrl + "/admin/realms/" + realm + "/users", MapUtil.mapOf("max", Integer.MAX_VALUE));
    }

    public Map<String, Object> getUserByUserName(String realm, String username) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getUserByUserName realm=" + realm + ", username=" + username);
        username = username != null ? username.toLowerCase() : null;
        List<Map<String, Object>> foundUsers = this.getJsonListResponse(this.serverUrl + "/admin/realms/" + realm + "/users", MapUtil.mapOf("username", username, "max", Integer.MAX_VALUE, "exact", true));
        ArrayList<Map<String, Object>> onlyUsersWithTheExactUsername = new ArrayList<Map<String, Object>>();
        if (foundUsers != null) {
            for (Map<String, Object> foundUser : foundUsers) {
                if (!username.equals(foundUser.get("username"))) continue;
                onlyUsersWithTheExactUsername.add(foundUser);
            }
        }
        return onlyUsersWithTheExactUsername.size() == 1 ? (Map)onlyUsersWithTheExactUsername.get(0) : null;
    }

    public List<Map<String, Object>> getGroups(String realm) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getGroups realm=" + realm);
        return this.getJsonListResponse(this.serverUrl + "/admin/realms/" + realm + "/groups", MapUtil.mapOf("max", Integer.MAX_VALUE));
    }

    public List<Map<String, Object>> getUserGroups(String realm, String userId) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getUserGroups realm=" + realm + ", userId=" + userId);
        return this.getJsonListResponse(this.serverUrl + "/admin/realms/" + realm + "/users/" + userId + "/groups", MapUtil.mapOf("max", Integer.MAX_VALUE));
    }

    public List<Map<String, Object>> getRoles(String realm) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getRoles realm=" + realm);
        return this.getJsonListResponse(this.serverUrl + "/admin/realms/" + realm + "/roles", null);
    }

    public List<Map<String, Object>> getRoles(String realm, String clientId) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getRoles realm=" + realm + ", clientId=" + clientId);
        return this.getJsonListResponse(this.serverUrl + "/admin/realms/" + realm + "/clients/" + clientId + "/roles", null);
    }

    public List<Map<String, Object>> getUserRealmRoles(String realm, String userId) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getUserRealmRoles realm=" + realm + ", userId=" + userId);
        return this.getJsonListResponse(this.serverUrl + "/admin/realms/" + realm + "/users/" + userId + "/role-mappings/realm/composite", null);
    }

    public List<Map<String, Object>> getUserClientRoles(String realm, String userId, String clientId) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("getUserClientRoles realm=" + realm + ", userId=" + userId + ", clientId=" + clientId);
        return this.getJsonListResponse(this.serverUrl + "/admin/realms/" + realm + "/users/" + userId + "/role-mappings/clients/" + clientId + "/composite", null);
    }

    public Map<String, Object> updateUserPassword(String realm, String userId, String password) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("updateUserPassword realm=" + realm + ", userId=" + userId + ", password=...");
        String jsonBody = JsonUtil.getInstance().convertPojoToJsonString(MapUtil.mapOf("type", "password", "temporary", false, "value", password));
        return this.putJson(this.serverUrl + "/admin/realms/" + realm + "/users/" + userId + "/reset-password", jsonBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> checkUserPassword(String realm, String clientId, String clientSecret, String username, String password) throws InterruptedException, ExecutionException, TimeoutException, IOException, RestWebServiceClientInitException {
        LOG.info("checkUserPassword realm=" + realm + ", clientId=" + clientId + ", clientSecret=..., username=" + username + ", password=...");
        try (Client client = null;){
            client = RestWebServiceClientFactory.newClient(this.allowUntrustedConnections);
            Form form = new Form();
            form.param("username", username);
            form.param("password", password);
            form.param("grant_type", "password");
            form.param("client_id", clientId);
            if (clientSecret != null) {
                form.param("client_secret", clientSecret);
            }
            WebTarget target = client.target(this.serverUrl + "/realms/" + realm + "/protocol/openid-connect/token");
            Future response = target.request(new String[]{"application/x-www-form-urlencoded"}).accept(new String[]{"application/json"}).buildPost(Entity.form((Form)form)).submit(Response.class);
            Response r = (Response)response.get(this.connectionTimeoutInSeconds, TimeUnit.SECONDS);
            Map<String, Object> map = Response.Status.Family.familyOf((int)r.getStatus()).equals((Object)Response.Status.Family.SUCCESSFUL) ? null : JsonUtil.getInstance().jsonStringAsMap((String)r.readEntity(String.class));
            return map;
        }
    }

    public Map<String, Object> removeUserSession(String realm, String sessionId) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("removeUserSession realm=" + realm + ", sessionId=" + sessionId);
        return this.call("DELETE", this.serverUrl + "/admin/realms/" + realm + "/sessions/" + sessionId);
    }

    public Map<String, Object> logoutUser(String realm, String userId) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("logoutUser realm=" + realm + ", userId=" + userId);
        return this.call("POST", this.serverUrl + "/admin/realms/" + realm + "/users/" + userId + "/logout");
    }

    public Map<String, Object> logoutAll(String realm) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("logoutAll realm=" + realm);
        return this.call("POST", this.serverUrl + "/admin/realms/" + realm + "/logout-all");
    }

    public Map<String, Object> updateUserLanguage(String realm, String userId, String language) throws InterruptedException, ExecutionException, TimeoutException, IOException, KeycloakException, RestWebServiceClientInitException {
        LOG.info("updateUserLanguage realm=" + realm + ", userId=" + userId + ", language=" + language);
        String jsonBody = JsonUtil.getInstance().convertPojoToJsonString(MapUtil.mapOf("attributes", MapUtil.mapOf("locale", language)));
        return this.putJson(this.serverUrl + "/admin/realms/" + realm + "/users/" + userId, jsonBody);
    }

    public static void main(String[] args) {
        try {
            KeycloakAdminClient keycloakAdminClient = KeycloakAdminClientBuilder.builder().serverUrl("http://dev06.virtimo.net:8091/auth").realm("master").clientId("admin-cli").username("admin").password("bpcadmin").build();
            List<Map<String, Object>> realms = keycloakAdminClient.getRealms();
            System.out.println("\nrealms = " + realms);
            for (Map<String, Object> realm : realms) {
                System.out.println(realm.get("id"));
            }
            List<Map<String, Object>> clients = keycloakAdminClient.getClients("bpc");
            System.out.println("\n'bpc' realm clients = " + clients);
            String idOfBpcCore = null;
            for (Map<String, Object> client : clients) {
                System.out.println(client.get("clientId") + " - " + client.get("id"));
                if (!"bpc-core".equalsIgnoreCase((String)client.get("clientId"))) continue;
                idOfBpcCore = (String)client.get("id");
            }
            Map<String, Object> bpcCoreClient = keycloakAdminClient.getClient("bpc", "bpc-core");
            System.out.println("\n'bpc-core' client = " + bpcCoreClient);
            String idOfOliver = null;
            List<Map<String, Object>> users = keycloakAdminClient.getUsers("bpc");
            System.out.println("\n'bpc' realm users = " + users);
            for (Map<String, Object> user : users) {
                System.out.println(user.get("username") + " - " + user.get("firstName") + " " + user.get("lastName") + " - " + user.get("email") + " - " + user.get("id"));
                if (!"of".equalsIgnoreCase((String)user.get("username"))) continue;
                idOfOliver = (String)user.get("id");
            }
            Map<String, Object> oliver = keycloakAdminClient.getUserByUserName("bpc", "of");
            System.out.println("\noliver = " + oliver);
            List<Map<String, Object>> groups = keycloakAdminClient.getGroups("bpc");
            System.out.println("\n'bpc' realm groups = " + groups);
            for (Map<String, Object> map : groups) {
                System.out.println(map.get("name") + " - " + map.get("id") + " - " + map.get("subGroups"));
            }
            List<Map<String, Object>> userGroups = keycloakAdminClient.getUserGroups("bpc", idOfOliver);
            System.out.println("\ngroups 'of' user = " + userGroups);
            for (Map<String, Object> map : userGroups) {
                System.out.println(map.get("name") + " - " + map.get("id") + " - " + map.get("subGroups"));
            }
            List<Map<String, Object>> list = keycloakAdminClient.getRoles("bpc");
            System.out.println("\n'bpc' realm roles = " + list);
            for (Map<String, Object> map : list) {
                System.out.println(map.get("name") + " - " + map.get("id"));
            }
            List<Map<String, Object>> list2 = keycloakAdminClient.getRoles("bpc", idOfBpcCore);
            System.out.println("\n'bpc-core' roles in 'bpc' realm = " + list2);
            for (Map<String, Object> map : list2) {
                System.out.println(map.get("name") + " - " + map.get("id"));
            }
            List<Map<String, Object>> list3 = keycloakAdminClient.getUserRealmRoles("bpc", idOfOliver);
            for (Map<String, Object> map : list3) {
                System.out.println(map.get("name") + " - " + map.get("id"));
            }
            List<Map<String, Object>> list4 = keycloakAdminClient.getUserClientRoles("bpc", idOfOliver, idOfBpcCore);
            for (Map<String, Object> map : list4) {
                System.out.println(map.get("name") + " - " + map.get("id"));
            }
            Map<String, Object> map = keycloakAdminClient.checkUserPassword("bpc", "bpc-core", "3313b742-facd-4300-8ba6-b4793c203ce9", "of", "1234567890_abc");
            if (map == null) {
                System.out.println("Passwort passt");
            } else {
                System.out.println("Falsches Passwort: " + map);
            }
            Map<String, Object> map2 = keycloakAdminClient.checkUserPassword("bpc", "bpc-core", "3313b742-facd-4300-8ba6-b4793c203ce9", "of", "abcdefg");
            if (map2 == null) {
                System.out.println("Passwort passt");
            } else {
                System.out.println("Falsches Passwort: " + map2);
            }
            Map<String, Object> updateUserPasswordErrorResp = keycloakAdminClient.updateUserPassword("bpc", idOfOliver, "1234567890_abc");
            if (updateUserPasswordErrorResp == null) {
                System.out.println("Passwort ge\u00e4ndert");
            } else {
                System.out.println("Passwort wurde nicht ge\u00e4ndert: " + updateUserPasswordErrorResp);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class Tokens {
        private final Token accessToken;
        private final Token refreshToken;

        public Tokens(long requestTime, Response r) throws IOException {
            String respAsString = (String)r.readEntity(String.class);
            Map<String, Object> respMap = JsonUtil.getInstance().jsonStringAsMap(respAsString);
            this.accessToken = new Token((String)respMap.get("access_token"), requestTime + ((Number)respMap.get("expires_in")).longValue() * 1000L);
            this.refreshToken = new Token((String)respMap.get("refresh_token"), requestTime + ((Number)respMap.get("refresh_expires_in")).longValue() * 1000L);
        }

        public Token getAccessToken() {
            return this.accessToken;
        }

        public Token getRefreshToken() {
            return this.refreshToken;
        }
    }

    private static class Token {
        private final String value;
        private final long expirationTimeInMillis;

        public Token(String value, long expirationTimeInMillis) {
            this.value = value;
            this.expirationTimeInMillis = expirationTimeInMillis;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() + 15000L >= this.expirationTimeInMillis;
        }
    }
}

