/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.exception.BackupRepositoryNotFoundException;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.backup.Snapshotter;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.SetUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class BackupJob
implements Runnable {
    private static final Logger LOG = Logger.getLogger(BackupJob.class.getName());
    private final BundleContext bundleContext;
    private final String backupJobIdentifier;
    private final BackupSetting backupSetting;

    public BackupJob(BundleContext bundleContext, String backupJobIdentifier, BackupSetting backupSetting) {
        this.bundleContext = bundleContext;
        this.backupJobIdentifier = backupJobIdentifier;
        this.backupSetting = backupSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block26: {
            LOG.info(this.backupJobIdentifier + ": BackupJob start");
            long startTime = System.currentTimeMillis();
            try {
                if (!this.backupSetting.isEnabled()) {
                    LOG.info(this.backupJobIdentifier + ": Skipping backup job execution ... job is disabled.");
                    break block26;
                }
                try (BpcServicesTracker<ModuleManager> moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);){
                    CoreModule coreModule = moduleManagerTracker.getService().getModuleByClass(CoreModule.class);
                    if (coreModule.isMaintenanceModeEnabled()) {
                        LOG.info(this.backupJobIdentifier + ": Skipping backup job execution due to enabled maintenance mode");
                        break block26;
                    }
                    BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(this.bundleContext, ElasticsearchService.class);
                    BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
                    try (BpcServicesTracker<ElasticsearchService> bpcServicesTracker = elasticsearchServiceTracker;
                         BpcServicesTracker<ClientSessionManager> bpcServicesTracker2 = clientSessionManagerTracker;){
                        this.createSnapshotBackup(elasticsearchServiceTracker.getService(), clientSessionManagerTracker.getService());
                    }
                }
            }
            catch (ServiceNotFoundException ex) {
                LOG.log(Level.SEVERE, this.backupJobIdentifier + ": Failed to perform the backup job without the required services.", ex);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, this.backupJobIdentifier + ": Failed to perform the backup job.", ex);
            }
            finally {
                LOG.info(this.backupJobIdentifier + ": BackupJob finished in " + (System.currentTimeMillis() - startTime) + " ms");
            }
        }
    }

    private void createSnapshotBackup(ElasticsearchService es, ClientSessionManager clientSessionManager) throws BackupRepositoryNotFoundException, ElasticsearchRelatedException {
        LOG.info(this.backupJobIdentifier + ": createSnapshotBackup");
        Snapshotter snapshotter = new Snapshotter(es);
        try {
            if (!snapshotter.existsBackupRepository("bpc_backup")) {
                snapshotter.createBackupRepository("bpc_backup", "bpc_backup");
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, this.backupJobIdentifier + ": No backup possible, the backup repository could not be created. " + ex.getMessage());
            return;
        }
        List<BackupSnapshotInfo> snapshots = snapshotter.getAllSnapshotsWithPrefix("bpc_backup", this.backupSetting.getSnapshotNamePrefix());
        boolean timeToCreateASnapshot = false;
        if (snapshots == null || snapshots.isEmpty()) {
            LOG.info(this.backupJobIdentifier + ": No snapshots exist");
            timeToCreateASnapshot = true;
        } else {
            long timestampOfLatestBackup = snapshotter.getTimestampOfLatestSnapshot(snapshots);
            LOG.info(this.backupJobIdentifier + ": Snapshots exist; date of latest:" + new Date(timestampOfLatestBackup));
            if (timestampOfLatestBackup < System.currentTimeMillis() - this.backupSetting.getIntervalInSeconds() * 1000L) {
                timeToCreateASnapshot = true;
            }
        }
        if (timeToCreateASnapshot) {
            LOG.info(this.backupJobIdentifier + ": Snapshot must be created");
            BackupSnapshotInfo snapshotInfo = snapshotter.createSnapshot("bpc_backup", this.backupSetting.getNewSnapshotName(), this.backupSetting.getIndicesToBackup());
            if (snapshotInfo != null) {
                SystemAuditLog.info("BackupCreated", "Backup with the snapshot name '" + snapshotInfo.getName() + "' created");
                clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), "de/virtimo/bpc/core/backup/backupCreated", JsonUtil.getInstance().convertPojoToMap(snapshotInfo));
            }
        } else {
            LOG.info(this.backupJobIdentifier + ": Creating a snapshot is not necessary at the moment");
        }
        List<BackupSnapshotInfo> deletedSnapshots = snapshotter.deleteOldSnapshots("bpc_backup", snapshots, this.backupSetting.getKeepBackupsDurationInSeconds());
        if (!deletedSnapshots.isEmpty()) {
            ArrayList<Map<String, Object>> websocketMessageInfos = new ArrayList<Map<String, Object>>();
            for (BackupSnapshotInfo deletedSnapshot : deletedSnapshots) {
                SystemAuditLog.info("BackupDeleted", "Backup with the snapshot name '" + deletedSnapshot.getName() + "' deleted");
                websocketMessageInfos.add(JsonUtil.getInstance().convertPojoToMap(deletedSnapshot));
            }
            clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), "de/virtimo/bpc/core/backup/backupDeleted", websocketMessageInfos);
        }
    }
}

