/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BpcServicesTracker;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class BackupsMetricsCollector
extends Collector {
    private static final Logger LOG = Logger.getLogger(BackupsMetricsCollector.class.getName());
    private final BpcServicesTracker<BackupManager> backupManagerTracker;

    public BackupsMetricsCollector(BundleContext bundleContext) {
        this.backupManagerTracker = new BpcServicesTracker<BackupManager>(bundleContext, BackupManager.class);
    }

    public void unregister() {
        LOG.info("unregister");
        CollectorRegistry.defaultRegistry.unregister((Collector)this);
        BpcServicesTracker.stopAll((Object)this);
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_backups_scheduled_jobs", "Number of scheduled backup jobs", (double)this.backupManagerTracker.getService().getNumberOfScheduledBackupJobs()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mfs;
    }
}

