/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.exception.BackupIndexNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupRepositoryNotFoundException;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.backup.BackupSnapshotInfoImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.jetbrains.annotations.NotNull;

public class Snapshotter {
    private static final Logger LOG = Logger.getLogger(Snapshotter.class.getName());
    private final ElasticsearchService es;

    public Snapshotter(ElasticsearchService es) {
        this.es = es;
    }

    private void throwConvertedElasticsearchException(ElasticsearchException ex, String repositoryName) throws BackupRepositoryNotFoundException, ElasticsearchRelatedException {
        if (ex instanceof ElasticsearchStatusException) {
            if (RestStatus.NOT_FOUND.getStatus() == ex.status().getStatus() && ex.getMessage().contains("repository_missing_exception")) {
                Throwable cause = ex.getCause();
                if (cause instanceof ElasticsearchException) {
                    throw new BackupRepositoryNotFoundException(repositoryName, (ElasticsearchException)cause);
                }
                throw new BackupRepositoryNotFoundException(repositoryName, ex);
            }
            throw new ElasticsearchRelatedException(ex);
        }
        throw new ElasticsearchRelatedException(ex);
    }

    public boolean existsBackupRepository(String repositoryName) throws ElasticsearchRelatedException {
        LOG.info("existsBackupRepository: repositoryName=" + repositoryName);
        try {
            GetRepositoriesRequest req = new GetRepositoriesRequest();
            GetRepositoriesResponse resp = this.es.getClient().snapshot().getRepository(req, RequestOptions.DEFAULT);
            for (RepositoryMetadata repository : resp.repositories()) {
                if (!repository.name().equalsIgnoreCase(repositoryName)) continue;
                LOG.info("existsBackupRepository: YES");
                return true;
            }
            LOG.info("existsBackupRepository: NO");
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        return false;
    }

    public void createBackupRepository(String repositoryName, String backupFolderName) throws ElasticsearchRelatedException {
        LOG.info("createBackupRepository: repositoryName=" + repositoryName + ", backupFolderName=" + backupFolderName);
        try {
            Settings settings = Settings.builder().put("location", backupFolderName).put("compress", true).build();
            PutRepositoryRequest req = new PutRepositoryRequest(repositoryName).type("fs").settings(settings);
            this.es.getClient().snapshot().createRepository(req, RequestOptions.DEFAULT);
        }
        catch (ElasticsearchStatusException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ElasticsearchException) {
                throw new ElasticsearchRelatedException((ElasticsearchException)cause);
            }
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    public List<BackupSnapshotInfo> getAllSnapshots(String repositoryName) throws BackupRepositoryNotFoundException, ElasticsearchRelatedException {
        LOG.info("getAllSnapshots repositoryName=" + repositoryName);
        try {
            GetSnapshotsRequest req = new GetSnapshotsRequest(repositoryName);
            GetSnapshotsResponse resp = this.es.getClient().snapshot().get(req, RequestOptions.DEFAULT);
            List<SnapshotInfo> snapshotInfos = resp.getSnapshots();
            if (snapshotInfos != null) {
                ArrayList<BackupSnapshotInfo> result = new ArrayList<BackupSnapshotInfo>();
                for (SnapshotInfo snapshotInfo : snapshotInfos) {
                    result.add(new BackupSnapshotInfoImpl(snapshotInfo));
                }
                return result;
            }
        }
        catch (ElasticsearchException ex) {
            this.throwConvertedElasticsearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        return null;
    }

    public List<BackupSnapshotInfo> getAllSnapshotsWithPrefix(String repositoryName, String snapshotNamePrefix) throws BackupRepositoryNotFoundException, ElasticsearchRelatedException {
        LOG.info("getAllSnapshotsWithPrefix repositoryName=" + repositoryName + ", snapshotNamePrefix=" + snapshotNamePrefix);
        List<BackupSnapshotInfo> allSnapshots = this.getAllSnapshots(repositoryName);
        ArrayList<BackupSnapshotInfo> result = new ArrayList<BackupSnapshotInfo>();
        for (BackupSnapshotInfo snapshot : allSnapshots) {
            if (!snapshot.getName().startsWith(snapshotNamePrefix)) continue;
            result.add(snapshot);
        }
        return result;
    }

    public BackupSnapshotInfo getSnapshot(String repositoryName, String snapshot) throws BackupRepositoryNotFoundException, ElasticsearchRelatedException {
        BackupSnapshotInfoImpl result;
        block5: {
            LOG.info("getSnapshot repositoryName=" + repositoryName + ", snapshot:" + snapshot);
            result = null;
            try {
                GetSnapshotsRequest req = new GetSnapshotsRequest(repositoryName).snapshots(new String[]{snapshot});
                GetSnapshotsResponse resp = this.es.getClient().snapshot().get(req, RequestOptions.DEFAULT);
                List<SnapshotInfo> snapshotInfos = resp.getSnapshots();
                if (snapshotInfos != null && snapshotInfos.size() == 1) {
                    result = new BackupSnapshotInfoImpl(snapshotInfos.get(0));
                }
            }
            catch (IOException ex) {
                throw new ElasticsearchRelatedException(ex);
            }
            catch (SnapshotMissingException ex) {
            }
            catch (ElasticsearchException ex) {
                if (RestStatus.NOT_FOUND.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot_missing_exception")) break block5;
                this.throwConvertedElasticsearchException(ex, repositoryName);
            }
        }
        return result;
    }

    public long getTimestampOfLatestSnapshot(List<BackupSnapshotInfo> snapshots) {
        LOG.info("getTimestampOfLatestSnapshot snapshots=...");
        long result = 0L;
        for (BackupSnapshotInfo snapshot : snapshots) {
            if (snapshot.getStartTimeInMillis() <= result) continue;
            result = snapshot.getStartTimeInMillis();
        }
        return result;
    }

    @NotNull
    public List<BackupSnapshotInfo> deleteOldSnapshots(@NotNull String repositoryName, List<BackupSnapshotInfo> snapshots, long keepBackupsDurationInSeconds) throws BackupRepositoryNotFoundException, ElasticsearchRelatedException {
        LOG.info("deleteOldSnapshots repositoryName=" + repositoryName + ", snapshots=..., keepBackupsDurationInSeconds=" + keepBackupsDurationInSeconds);
        ArrayList<BackupSnapshotInfo> result = new ArrayList<BackupSnapshotInfo>();
        if (snapshots != null) {
            for (BackupSnapshotInfo snapshot : snapshots) {
                if (snapshot.getStartTimeInMillis() >= System.currentTimeMillis() - keepBackupsDurationInSeconds * 1000L) continue;
                try {
                    this.deleteSnapshot(repositoryName, snapshot.getName());
                    result.add(snapshot);
                }
                catch (BackupNotFoundException backupNotFoundException) {}
            }
        }
        return result;
    }

    public void deleteSnapshot(@NotNull String repositoryName, String snapshotName) throws BackupRepositoryNotFoundException, BackupNotFoundException, ElasticsearchRelatedException {
        LOG.info("deleteSnapshot: repositoryName=" + repositoryName + ", snapshotName=" + snapshotName);
        try {
            DeleteSnapshotRequest req = new DeleteSnapshotRequest(repositoryName, snapshotName);
            this.es.getClient().snapshot().delete(req, RequestOptions.DEFAULT);
        }
        catch (ElasticsearchException ex) {
            if (RestStatus.NOT_FOUND.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot_missing_exception")) {
                throw new BackupNotFoundException(repositoryName, snapshotName);
            }
            this.throwConvertedElasticsearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    public BackupSnapshotInfo createSnapshot(String repositoryName, String snapshotName, Set<String> indices) throws BackupRepositoryNotFoundException, ElasticsearchRelatedException {
        LOG.info("createSnapshot: repositoryName=" + repositoryName + ", snapshotName=" + snapshotName + ", indices=" + indices);
        try {
            HashSet<String> existingIndices = new HashSet<String>();
            for (String index : indices) {
                if (this.es.existsIndex(index)) {
                    existingIndices.add(index);
                    continue;
                }
                LOG.log(Level.WARNING, "The index '" + index + "' to backup does not exist. It will not be in the Elasticsearch snapshot '" + snapshotName + "'.");
            }
            if (!existingIndices.isEmpty()) {
                CreateSnapshotRequest req = new CreateSnapshotRequest(repositoryName, snapshotName).waitForCompletion(true).indices(existingIndices.toArray(new String[0]));
                CreateSnapshotResponse resp = this.es.getClient().snapshot().create(req, RequestOptions.DEFAULT);
                LOG.info("Snapshot created: " + resp.status());
                SnapshotInfo snapshotInfo = resp.getSnapshotInfo();
                return snapshotInfo == null ? null : new BackupSnapshotInfoImpl(snapshotInfo);
            }
            LOG.log(Level.WARNING, "Failed to create the snapshot '" + snapshotName + "'. None of the indices to backup exists: " + indices);
        }
        catch (ElasticsearchException ex) {
            this.throwConvertedElasticsearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        return null;
    }

    public void restoreSnapshotIndices(String repositoryName, String snapshotName, String renamePattern, String renameReplacement, boolean includeAlias) throws BackupRepositoryNotFoundException, BackupNotFoundException, ElasticsearchRelatedException {
        LOG.info("restoreSnapshotIndices repositoryName=" + repositoryName + ", snapshotName=" + snapshotName + ", renamePattern=" + renamePattern + ", renameReplacement=" + renameReplacement + ", includeAlias=" + includeAlias);
        try {
            RestoreSnapshotRequest req = new RestoreSnapshotRequest(repositoryName, snapshotName).renamePattern(renamePattern).renameReplacement(renameReplacement).includeAliases(includeAlias).waitForCompletion(true);
            RestoreSnapshotResponse resp = this.es.getClient().snapshot().restore(req, RequestOptions.DEFAULT);
            LOG.info("Snapshot restored: " + resp.status());
        }
        catch (ElasticsearchException ex) {
            if (RestStatus.INTERNAL_SERVER_ERROR.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot does not exist")) {
                throw new BackupNotFoundException(repositoryName, snapshotName);
            }
            this.throwConvertedElasticsearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    public void restoreSingleSnapshotIndex(String repositoryName, String snapshotName, String snapshotIndexName, String newIndexName, boolean includeAlias) throws BackupRepositoryNotFoundException, BackupNotFoundException, BackupIndexNotFoundException, ElasticsearchRelatedException {
        LOG.info("restoreSingleSnapshotIndex repositoryName=" + repositoryName + ", snapshotName=" + snapshotName + ", snapshotIndexName=" + snapshotIndexName + ", newIndexName=" + newIndexName + ", includeAlias=" + includeAlias);
        try {
            RestoreSnapshotRequest req = new RestoreSnapshotRequest(repositoryName, snapshotName).indices(snapshotIndexName).renamePattern(snapshotIndexName).renameReplacement(newIndexName).includeAliases(includeAlias).waitForCompletion(true);
            RestoreSnapshotResponse resp = this.es.getClient().snapshot().restore(req, RequestOptions.DEFAULT);
            LOG.info("Snapshot restored: " + resp.status());
        }
        catch (ElasticsearchException ex) {
            if (RestStatus.INTERNAL_SERVER_ERROR.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot does not exist")) {
                throw new BackupNotFoundException(repositoryName, snapshotName);
            }
            if (RestStatus.NOT_FOUND.getStatus() == ex.status().getStatus() && ex.getMessage().contains("index_not_found_exception")) {
                throw new BackupIndexNotFoundException(repositoryName, snapshotName, snapshotIndexName);
            }
            this.throwConvertedElasticsearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    public void restoreAllSnapshotIndices(String repositoryName, String snapshotName, boolean includeAlias) throws BackupRepositoryNotFoundException, BackupNotFoundException, ElasticsearchRelatedException {
        LOG.info("restoreAllSnapshotIndices repositoryName=" + repositoryName + ", snapshotName=" + snapshotName + ", includeAlias=" + includeAlias);
        try {
            RestoreSnapshotRequest req = new RestoreSnapshotRequest(repositoryName, snapshotName).includeAliases(includeAlias).waitForCompletion(true);
            RestoreSnapshotResponse resp = this.es.getClient().snapshot().restore(req, RequestOptions.DEFAULT);
            LOG.info("Snapshot restored: " + resp.status());
        }
        catch (ElasticsearchException ex) {
            if (RestStatus.INTERNAL_SERVER_ERROR.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot does not exist")) {
                throw new BackupNotFoundException(repositoryName, snapshotName);
            }
            this.throwConvertedElasticsearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }
}

