/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.datalock;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.datalock.DataLockService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.MapUtil;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.osgi.framework.BundleContext;

public class DataLockServiceImpl
implements DataLockService,
BpcService {
    private static final Logger LOG = Logger.getLogger(DataLockServiceImpl.class.getName());
    private static final String INDEX_NAME = "bpc-datalock";
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;

    public DataLockServiceImpl(BundleContext bundleContext) {
        LOG.info("DataLockServiceImpl bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(bundleContext, ElasticsearchService.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public SearchResponse getAllItems(Integer start, Integer limit) throws ServiceNotFoundException, ElasticsearchRelatedException, SystemException {
        SearchResponse searchResponse;
        LOG.info("getAllItems start=" + start + ", limit=" + limit);
        try {
            RestHighLevelClient esClient = this.elasticsearchServiceTracker.getService().getClient();
            SearchRequest searchRequest = new SearchRequest().indices(INDEX_NAME).source(new SearchSourceBuilder().from(start).size(limit));
            searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new SystemException((ErrorCode)CoreErrorCode.DATA_LOCK_INDEX_NOT_FOUND, "Did not find the data lock index '${indexName}'.", MapUtil.mapOf("indexName", INDEX_NAME));
            }
            LOG.log(Level.SEVERE, "Unhandled exception in getAllItems(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            throw new ElasticsearchRelatedException(ex);
        }
        return searchResponse;
    }

    @Override
    public GetResponse getItem(String itemId) throws ServiceNotFoundException, ElasticsearchRelatedException, SystemException {
        GetResponse response;
        LOG.info("getItem itemId=" + itemId);
        try {
            RestHighLevelClient esClient = this.elasticsearchServiceTracker.getService().getClient();
            GetRequest getRequest = ((GetRequest)new GetRequest().index(INDEX_NAME)).id(itemId);
            response = esClient.get(getRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new SystemException((ErrorCode)CoreErrorCode.DATA_LOCK_INDEX_NOT_FOUND, "Did not find the data lock index '${indexName}'.", MapUtil.mapOf("indexName", INDEX_NAME));
            }
            LOG.log(Level.SEVERE, "Unhandled exception in getItem(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            throw new ElasticsearchRelatedException(ex);
        }
        if (response.isExists()) {
            return response;
        }
        throw new SystemException((ErrorCode)CoreErrorCode.DATA_LOCK_ITEM_NOT_FOUND, "Did not find the data lock item '${itemId}' in the index '${indexName}'.", MapUtil.mapOf("itemId", itemId, "indexName", INDEX_NAME));
    }

    @Override
    public void createItem(String itemId, String jsonData) throws ServiceNotFoundException, ElasticsearchRelatedException, SystemException {
        LOG.info("createItem itemId=" + itemId + ", jsonData=" + jsonData);
        try {
            RestHighLevelClient esClient = this.elasticsearchServiceTracker.getService().getClient();
            IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest().index(INDEX_NAME)).id(itemId).source(jsonData, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            esClient.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new SystemException((ErrorCode)CoreErrorCode.DATA_LOCK_INDEX_NOT_FOUND, "Did not find the data lock index '${indexName}'.", MapUtil.mapOf("indexName", INDEX_NAME));
            }
            LOG.log(Level.SEVERE, "Unhandled exception in createItem(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public void updateItem(String itemId, String jsonData) throws ServiceNotFoundException, ElasticsearchRelatedException, SystemException {
        LOG.info("updateItem itemId=" + itemId + ", jsonData=" + jsonData);
        try {
            RestHighLevelClient esClient = this.elasticsearchServiceTracker.getService().getClient();
            IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest().index(INDEX_NAME)).id(itemId).source(jsonData, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            esClient.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (MapperParsingException ex) {
            LOG.warning("bpc-datalock: Elasticsearch mapping mismatch while indexing the data lock value: " + jsonData);
            throw ex;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new SystemException((ErrorCode)CoreErrorCode.DATA_LOCK_INDEX_NOT_FOUND, "Did not find the data lock index '${indexName}'.", MapUtil.mapOf("indexName", INDEX_NAME));
            }
            LOG.log(Level.SEVERE, "Unhandled exception in updateItem(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @Override
    public void deleteItem(String itemId) throws ServiceNotFoundException, ElasticsearchRelatedException, SystemException {
        DeleteResponse deleteResponse;
        LOG.info("deleteItem itemId=" + itemId);
        try {
            RestHighLevelClient esClient = this.elasticsearchServiceTracker.getService().getClient();
            DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(INDEX_NAME)).id(itemId);
            deleteResponse = esClient.delete(deleteRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new SystemException((ErrorCode)CoreErrorCode.DATA_LOCK_INDEX_NOT_FOUND, "Did not find the data lock index '${indexName}'.", MapUtil.mapOf("indexName", INDEX_NAME));
            }
            LOG.log(Level.SEVERE, "Unhandled exception in deleteItem(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            throw new ElasticsearchRelatedException(ex);
        }
        if (deleteResponse.status() == RestStatus.NOT_FOUND) {
            throw new SystemException((ErrorCode)CoreErrorCode.DATA_LOCK_ITEM_NOT_FOUND, "Did not find the data lock item '${itemId}' in the index '${indexName}'.", MapUtil.mapOf("itemId", itemId, "indexName", INDEX_NAME));
        }
    }
}

