/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class DeploymentBundlesDiffer {
    private static final Logger LOG = Logger.getLogger(DeploymentBundlesDiffer.class.getName());
    private final List<Map<String, Object>> sourceBundles;
    private final List<Map<String, Object>> targetBundles;

    public DeploymentBundlesDiffer(Map<String, Object> sourceDeploymentSystemStatus, Map<String, Object> targetDeploymentSystemStatus) {
        this.sourceBundles = this.extractBundles(sourceDeploymentSystemStatus);
        this.targetBundles = this.extractBundles(targetDeploymentSystemStatus);
    }

    public List<Map<String, Object>> getSourceBundles() {
        return this.sourceBundles;
    }

    public List<Map<String, Object>> getTargetBundles() {
        return this.targetBundles;
    }

    public boolean isSourceAndTargetEqual() {
        LOG.info("isSourceAndTargetEqual");
        return this.sourceBundles.equals(this.targetBundles);
    }

    public Map<String, Object> getBundlesDiff() {
        LOG.info("getBundlesDiff");
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.isSourceAndTargetEqual()) {
            result.put("missingBundlesOnTarget", this.evalIDsOfMissingBundles(this.sourceBundles, this.targetBundles));
            result.put("missingBundlesOnSource", this.evalIDsOfMissingBundles(this.targetBundles, this.sourceBundles));
            result.put("differentBundles", this.evalIDsOfDifferentBundles(this.sourceBundles, this.targetBundles));
            result.put("undeployableBundles", this.evalIDsOfUndeployableBundles(this.sourceBundles, this.targetBundles));
        }
        return result;
    }

    private List<Map<String, Object>> extractBundles(Map<String, Object> deploymentSystemStatus) {
        LOG.info("extractBundles deploymentSystemStatus=...");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Object moduleObject : (List)deploymentSystemStatus.get("allBpcModules")) {
            Map module = (Map)moduleObject;
            HashMap version = new HashMap();
            version.put("major", ((Map)module.get("version")).get("major"));
            version.put("minor", ((Map)module.get("version")).get("minor"));
            version.put("micro", ((Map)module.get("version")).get("micro"));
            version.put("qualifier", ((Map)module.get("version")).get("qualifier"));
            HashMap bundleInfo = new HashMap();
            bundleInfo.put("id", module.get("id"));
            bundleInfo.put("name", module.get("name"));
            if (module.get("filename") != null) {
                bundleInfo.put("filename", module.get("filename"));
            }
            if (module.get("symbolicName") != null) {
                String symbolicName = (String)module.get("symbolicName");
                bundleInfo.put("symbolicName", symbolicName);
                bundleInfo.put("artifactId", this.extractArtifactIdFromSymbolicName(symbolicName));
            }
            bundleInfo.put("state", module.get("state"));
            bundleInfo.put("build", module.get("build"));
            bundleInfo.put("version", version);
            result.add(bundleInfo);
        }
        return result;
    }

    private String extractArtifactIdFromSymbolicName(String symbolicName) {
        if (symbolicName != null && symbolicName.lastIndexOf(46) != -1) {
            return symbolicName.substring(symbolicName.lastIndexOf(46) + 1);
        }
        return null;
    }

    @NotNull
    private Set<Long> evalIDsOfMissingBundles(List<Map<String, Object>> sourceBundles, List<Map<String, Object>> targetBundles) {
        HashSet<Long> result = new HashSet<Long>();
        for (Map<String, Object> sourceBundle : sourceBundles) {
            String bundleName;
            boolean bundleFoundByFilename = false;
            boolean bundleFoundByName = false;
            String filename = (String)sourceBundle.get("filename");
            if (filename != null) {
                boolean bl = bundleFoundByFilename = this.getBundleInfoByFilename(filename, targetBundles) != null;
            }
            if (!bundleFoundByFilename && (bundleName = (String)sourceBundle.get("name")) != null) {
                boolean bl = bundleFoundByName = this.getBundleInfoByBundlename(bundleName, targetBundles) != null;
            }
            if (bundleFoundByFilename || bundleFoundByName) continue;
            Number bundleId = (Number)sourceBundle.get("id");
            result.add(bundleId.longValue());
        }
        return result;
    }

    private Set<Long> evalIDsOfDifferentBundles(List<Map<String, Object>> sourceBundles, List<Map<String, Object>> targetBundles) {
        HashSet<Long> result = new HashSet<Long>();
        for (Map<String, Object> sourceBundle : sourceBundles) {
            String filename = (String)sourceBundle.get("filename");
            String bundlename = (String)sourceBundle.get("name");
            Map<String, Object> targetBundle = null;
            if (filename != null) {
                targetBundle = this.getBundleInfoByFilename(filename, targetBundles);
            }
            if (targetBundle == null) {
                targetBundle = this.getBundleInfoByBundlename(bundlename, targetBundles);
            }
            if (targetBundle == null) continue;
            String sourceBuild = (String)sourceBundle.get("build");
            String targetBuild = (String)targetBundle.get("build");
            if (sourceBuild == null || targetBuild == null || sourceBuild.equals(targetBuild)) continue;
            Number bundleId = (Number)sourceBundle.get("id");
            result.add(bundleId.longValue());
        }
        return result;
    }

    private Set<Long> evalIDsOfUndeployableBundles(List<Map<String, Object>> sourceBundles, List<Map<String, Object>> targetBundles) {
        HashSet<Long> result = new HashSet<Long>();
        for (Map<String, Object> sourceBundle : sourceBundles) {
            String filename = (String)sourceBundle.get("filename");
            String bundlename = (String)sourceBundle.get("name");
            if (filename == null) {
                Number bundleId = (Number)sourceBundle.get("id");
                result.add(bundleId.longValue());
                continue;
            }
            Map<String, Object> targetBundle = this.getBundleInfoByFilename(filename, targetBundles);
            if (targetBundle != null || (targetBundle = this.getBundleInfoByBundlename(bundlename, targetBundles)) == null) continue;
            Number bundleId = (Number)sourceBundle.get("id");
            result.add(bundleId.longValue());
        }
        return result;
    }

    private Map<String, Object> getBundleInfoByFilename(String filename, List<Map<String, Object>> bundles) {
        if (filename != null && bundles != null) {
            for (Map<String, Object> bundle : bundles) {
                if (!filename.equals(bundle.get("filename"))) continue;
                return bundle;
            }
        }
        return null;
    }

    private Map<String, Object> getBundleInfoByBundlename(String bundlename, List<Map<String, Object>> bundles) {
        if (bundlename != null && bundles != null) {
            for (Map<String, Object> bundle : bundles) {
                if (!bundlename.equals(bundle.get("name"))) continue;
                return bundle;
            }
        }
        return null;
    }
}

