/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment;

import de.virtimo.bpc.api.es.IndexInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DeploymentIndicesDiffer {
    private static final Logger LOG = Logger.getLogger(DeploymentIndicesDiffer.class.getName());
    private final Map<String, IndexInfo> sourceIndices;
    private final Map<String, IndexInfo> targetIndices;

    public DeploymentIndicesDiffer(Map<String, IndexInfo> sourceIndices, Map<String, IndexInfo> targetIndices) {
        this.sourceIndices = this.filterDeployableIndices(sourceIndices);
        this.targetIndices = this.filterDeployableIndices(targetIndices);
    }

    public Map<String, IndexInfo> getSourceIndices() {
        return this.sourceIndices;
    }

    public Map<String, IndexInfo> getTargetIndices() {
        return this.targetIndices;
    }

    public boolean isSourceAndTargetEqual() {
        LOG.info("isSourceAndTargetEqual");
        return this.sourceIndices.equals(this.targetIndices);
    }

    public Map<String, Object> getIndicesDiff() {
        LOG.info("getIndicesDiff");
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.isSourceAndTargetEqual()) {
            result.put("missingIndicesOnTarget", this.evalNamesOfMissingIndices(this.sourceIndices, this.targetIndices));
            result.put("missingIndicesOnSource", this.evalNamesOfMissingIndices(this.targetIndices, this.sourceIndices));
            result.put("differentIndices", this.evalNamesOfDifferentIndices(this.sourceIndices, this.targetIndices));
        }
        return result;
    }

    private Set<String> evalNamesOfMissingIndices(Map<String, IndexInfo> sourceIndices, Map<String, IndexInfo> targetIndices) {
        LOG.info("evalNamesOfMissingIndices sourceIndices=..., targetIndices=...");
        HashSet<String> result = new HashSet<String>();
        for (String sourceIndexName : sourceIndices.keySet()) {
            if (targetIndices.containsKey(sourceIndexName)) continue;
            IndexInfo sourceIndexInfo = sourceIndices.get(sourceIndexName);
            for (String sourceAlias : sourceIndexInfo.getAliases()) {
                String targetIndexName = this.getIndexNameForAlias(sourceAlias, targetIndices);
                if (targetIndexName != null) continue;
                result.add(sourceIndexName);
            }
        }
        return result;
    }

    private String getIndexNameForAlias(String sourceAlias, Map<String, IndexInfo> targetIndices) {
        if (sourceAlias != null && targetIndices != null) {
            for (String targetIndexName : targetIndices.keySet()) {
                IndexInfo targetIndexInfo = targetIndices.get(targetIndexName);
                for (String targetAlias : targetIndexInfo.getAliases()) {
                    if (!targetAlias.equals(sourceAlias)) continue;
                    return targetIndexName;
                }
            }
        }
        return null;
    }

    private Set<String> evalNamesOfDifferentIndices(Map<String, IndexInfo> sourceIndices, Map<String, IndexInfo> targetIndices) {
        LOG.info("evalNamesOfDifferentIndices sourceIndices=..., targetIndices=...");
        HashSet<String> result = new HashSet<String>();
        Map<String, String> sameIndices = this.getIndicesThatExistOnBothSystems(sourceIndices, targetIndices);
        for (String sourceIndexName : sameIndices.keySet()) {
            String targetIndexName = sameIndices.get(sourceIndexName);
            IndexInfo sourceIndexInfo = sourceIndices.get(sourceIndexName);
            IndexInfo targetIndexInfo = targetIndices.get(targetIndexName);
            if (sourceIndexInfo.getDocsCount() == targetIndexInfo.getDocsCount()) continue;
            result.add(sourceIndexName);
        }
        return result;
    }

    private Map<String, String> getIndicesThatExistOnBothSystems(Map<String, IndexInfo> sourceIndices, Map<String, IndexInfo> targetIndices) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String sourceIndexName : sourceIndices.keySet()) {
            if (targetIndices.containsKey(sourceIndexName)) {
                result.put(sourceIndexName, sourceIndexName);
                continue;
            }
            IndexInfo sourceIndexInfo = sourceIndices.get(sourceIndexName);
            for (String sourceAlias : sourceIndexInfo.getAliases()) {
                String targetIndexName = this.getIndexNameForAlias(sourceAlias, targetIndices);
                if (targetIndexName == null) continue;
                result.put(sourceIndexName, targetIndexName);
            }
        }
        return result;
    }

    private Map<String, IndexInfo> filterDeployableIndices(Map<String, IndexInfo> indices) {
        HashMap<String, IndexInfo> result = new HashMap<String, IndexInfo>();
        for (String indexName : indices.keySet()) {
            IndexInfo indexInfo = indices.get(indexName);
            if (indexInfo.isHidden() || !indexInfo.isInState("open") || !indexInfo.isBpcConform()) continue;
            result.put(indexName, indexInfo);
        }
        return result;
    }
}

