/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.deployment.DeploymentSide;
import de.virtimo.bpc.api.deployment.MimeMultipartData;
import de.virtimo.bpc.api.deployment.exception.DeploymentSystemException;
import de.virtimo.bpc.api.deployment.resource.DeploymentData;
import de.virtimo.bpc.api.es.IndexInfo;
import de.virtimo.bpc.core.deployment.GZipContentUtil;
import de.virtimo.bpc.core.deployment.MimeMultipartDataImpl;
import de.virtimo.bpc.core.deployment.resource.DeploymentIndexData;
import de.virtimo.bpc.core.deployment.resource.DeploymentIndexInfo;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.utils.RestWebServiceClientFactory;
import de.virtimo.bpc.core.utils.RestWebServiceClientInitException;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.StreamUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;

public class DeploymentSystem {
    private static final Logger LOG = Logger.getLogger(DeploymentSystem.class.getName());
    private final DeploymentSide deploymentSide;
    private final String serverUrl;
    private final String apiKey;
    private Map<String, Object> additionalHttpHeaders;
    private UserSession userSession;
    private Client restWebServiceClient;

    public DeploymentSystem(DeploymentSide deploymentSide, ModuleConfiguration backendConnectionConfig) throws DeploymentSystemException {
        this(deploymentSide, backendConnectionConfig.getSettingValue("url").asString(), backendConnectionConfig.getSettingValue("api_key").asString(), backendConnectionConfig.getSettingValue("allowUntrustedConnections").asBoolean());
    }

    public DeploymentSystem(DeploymentSide deploymentSide, String serverUrl, String apiKey, boolean allowUntrustedConnections) throws DeploymentSystemException {
        this.deploymentSide = deploymentSide;
        this.serverUrl = serverUrl;
        this.apiKey = apiKey;
        this.additionalHttpHeaders = null;
        this.userSession = null;
        try {
            this.restWebServiceClient = RestWebServiceClientFactory.newClient(allowUntrustedConnections);
        }
        catch (RestWebServiceClientInitException ex) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, deploymentSide, "CORE_ERROR_DEPLOYMENT_CREATE_HTTP_CLIENT", MapUtil.mapOf("error", ex.getMessage()), (Throwable)ex);
        }
    }

    public void destroy() throws DeploymentSystemException {
        LOG.info("destroy");
        this.userSession = null;
        if (this.restWebServiceClient != null) {
            this.restWebServiceClient.close();
            this.restWebServiceClient = null;
        }
    }

    public void setAdditionalHttpHeaders(Map<String, Object> additionalHttpHeaders) {
        this.additionalHttpHeaders = additionalHttpHeaders;
    }

    public UserSession getUserSession() {
        return this.userSession;
    }

    private Invocation.Builder createInvocationBuilder(WebTarget target, Map<String, Object> additionalHeaders) {
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        invocationBuilder.accept(new String[]{"application/json"});
        invocationBuilder.header("X-APIKey", (Object)this.apiKey);
        if (additionalHeaders != null) {
            for (String headerName : additionalHeaders.keySet()) {
                invocationBuilder.header(headerName, additionalHeaders.get(headerName));
            }
        }
        return invocationBuilder;
    }

    private String httpMethodFromEndpoint(String method, String endpoint, Map<String, Object> queryParams, Map<String, Object> additionalHeaders, int expectedStatusCode, boolean responseIsMandatory) throws DeploymentSystemException {
        LOG.info("httpMethodFromEndpoint method=" + method + ", endpoint=" + endpoint + ", queryParams=" + queryParams + ", additionalHeaders=" + additionalHeaders + ", expectedStatusCode=" + expectedStatusCode + ", responseIsMandatory=" + responseIsMandatory);
        String targetUrl = this.serverUrl.trim() + endpoint;
        try {
            WebTarget target = this.restWebServiceClient.target(targetUrl);
            target = this.setQueryParams(target, queryParams);
            Invocation.Builder invocationBuilder = this.createInvocationBuilder(target, additionalHeaders);
            invocationBuilder.acceptEncoding(new String[]{"gzip"});
            Future response = invocationBuilder.build(method).submit(Response.class);
            Response r = (Response)response.get(60L, TimeUnit.SECONDS);
            String respString = GZipContentUtil.getContentAsString(r);
            if (r.getStatus() != expectedStatusCode) {
                SystemException targetSystemException = ErrorResponse.reconstructSystemException(r, CoreErrorCode.class);
                if (targetSystemException != null) {
                    throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_STATUS_CODE, this.deploymentSide, targetSystemException.getMessage(), targetSystemException.getProperties());
                }
                throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_STATUS_CODE, this.deploymentSide, "CORE_ERROR_DEPLOYMENT_UNEXPECTED_HTTP_GET_STATUS_CODE", MapUtil.mapOf("endpoint", targetUrl, "statusCode", r.getStatus(), "expectedStatusCode", expectedStatusCode, "response", respString));
            }
            if (responseIsMandatory && StringUtil.isNullOrEmpty(respString)) {
                throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_RESPONSE_MISSING, this.deploymentSide, "CORE_ERROR_DEPLOYMENT_UNEXPECTED_HTTP_GET_EMPTY_RESPONSE", MapUtil.mapOf("endpoint", targetUrl));
            }
            return respString;
        }
        catch (DeploymentSystemException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, this.deploymentSide, "CORE_ERROR_DEPLOYMENT_UNEXPECTED_HTTP_GET_EXCEPTION", MapUtil.mapOf("endpoint", targetUrl, "error", ex.getMessage()), (Throwable)ex);
        }
    }

    private WebTarget setQueryParams(WebTarget target, Map<String, Object> queryParams) {
        if (queryParams != null) {
            for (String key : queryParams.keySet()) {
                target = target.queryParam(key, new Object[]{queryParams.get(key)});
            }
        }
        return target;
    }

    private String httpPostJsonToEndpoint(String endpoint, Map<String, Object> queryParams, Map<String, Object> additionalHeaders, String jsonBody, int expectedStatusCode, boolean zipped) throws DeploymentSystemException {
        LOG.info("httpPostJsonToEndpoint endpoint=" + endpoint + ", queryParams=" + queryParams + ", additionalHeaders=" + additionalHeaders + ", jsonBody=..., expectedStatusCode=" + expectedStatusCode + ", zipped=" + zipped);
        String targetUrl = this.serverUrl.trim() + endpoint;
        try {
            WebTarget target = this.restWebServiceClient.target(targetUrl);
            target = this.setQueryParams(target, queryParams);
            Invocation.Builder invocationBuilder = this.createInvocationBuilder(target, additionalHeaders);
            Entity entity = zipped ? Entity.entity((Object)StreamUtil.gzip(jsonBody), (Variant)new Variant(MediaType.APPLICATION_JSON_TYPE, (String)null, "gzip")) : Entity.json((Object)jsonBody);
            Future response = invocationBuilder.buildPost(entity).submit(Response.class);
            Response r = (Response)response.get(60L, TimeUnit.SECONDS);
            String respString = (String)r.readEntity(String.class);
            if (r.getStatus() != expectedStatusCode) {
                SystemException targetSystemException = ErrorResponse.reconstructSystemException(r, CoreErrorCode.class);
                if (targetSystemException != null) {
                    throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_STATUS_CODE, this.deploymentSide, targetSystemException.getMessage(), targetSystemException.getProperties());
                }
                throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_STATUS_CODE, this.deploymentSide, "CORE_ERROR_DEPLOYMENT_UNEXPECTED_HTTP_POST_STATUS_CODE", MapUtil.mapOf("endpoint", targetUrl, "statusCode", r.getStatus(), "expectedStatusCode", expectedStatusCode, "response", respString));
            }
            return respString;
        }
        catch (DeploymentSystemException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, this.deploymentSide, "CORE_ERROR_DEPLOYMENT_UNEXPECTED_HTTP_POST_EXCEPTION", MapUtil.mapOf("endpoint", targetUrl, "error", ex.getMessage()), (Throwable)ex);
        }
    }

    private String httpPostToEndpoint(String endpoint, Map<String, Object> additionalHeaders, MimeMultipartData mimeMultipartData, int expectedStatusCode) throws DeploymentSystemException {
        LOG.info("httpPostJsonToEndpoint endpoint=" + endpoint + ", additionalHeaders=" + additionalHeaders + ", mimeMultipartData=..., expectedStatusCode=" + expectedStatusCode);
        String targetUrl = this.serverUrl.trim() + endpoint;
        try {
            WebTarget target = this.restWebServiceClient.target(targetUrl);
            Invocation.Builder invocationBuilder = this.createInvocationBuilder(target, additionalHeaders);
            Entity entity = Entity.entity((Object)mimeMultipartData.getBodyBytes(), (String)mimeMultipartData.getContentType());
            Future response = invocationBuilder.buildPost(entity).submit(Response.class);
            Response r = (Response)response.get(60L, TimeUnit.SECONDS);
            String respString = (String)r.readEntity(String.class);
            if (r.getStatus() != expectedStatusCode) {
                SystemException targetSystemException = ErrorResponse.reconstructSystemException(r, CoreErrorCode.class);
                if (targetSystemException != null) {
                    throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_STATUS_CODE, this.deploymentSide, targetSystemException.getMessage(), targetSystemException.getProperties());
                }
                throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_STATUS_CODE, this.deploymentSide, "CORE_ERROR_DEPLOYMENT_UNEXPECTED_HTTP_POST_STATUS_CODE", MapUtil.mapOf("endpoint", targetUrl, "statusCode", r.getStatus(), "expectedStatusCode", expectedStatusCode, "response", respString));
            }
            return respString;
        }
        catch (DeploymentSystemException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, this.deploymentSide, "CORE_ERROR_DEPLOYMENT_UNEXPECTED_HTTP_POST_EXCEPTION", MapUtil.mapOf("endpoint", targetUrl, "error", ex.getMessage()), (Throwable)ex);
        }
    }

    public Map<String, Object> getStatus() throws DeploymentSystemException, IOException {
        LOG.info("getStatus");
        String resp = this.httpMethodFromEndpoint("GET", "/cxf/bpc-core/status", null, this.additionalHttpHeaders, 200, true);
        return JsonUtil.getInstance().jsonStringAsMap(resp);
    }

    public Map<String, Object> getModuleConfigurations() throws DeploymentSystemException, IOException {
        LOG.info("getModuleConfigurations");
        String resp = this.httpMethodFromEndpoint("GET", "/cxf/bpc-core/configuration", null, this.additionalHttpHeaders, 200, true);
        return JsonUtil.getInstance().jsonStringAsMap(resp);
    }

    public Map<String, Object> getModuleConfigurationsFromBackup(String snapshotName) throws DeploymentSystemException, IOException {
        LOG.info("getModuleConfigurationsFromBackup snapshotName=" + snapshotName);
        String resp = this.httpMethodFromEndpoint("GET", "/cxf/bpc-core/configuration/backups/export/" + snapshotName, null, this.additionalHttpHeaders, 200, true);
        return JsonUtil.getInstance().jsonStringAsMap(resp);
    }

    public String uploadDeploymentData(DeploymentData deploymentData, boolean enableMaintenanceMode, boolean validate) throws JsonProcessingException, DeploymentSystemException {
        LOG.info("uploadDeploymentData deploymentData=..., enableMaintenanceMode=" + enableMaintenanceMode + ", validate=" + validate);
        return this.httpPostJsonToEndpoint("/cxf/bpc-deployment/deployment/import", MapUtil.mapOf("enableMaintenanceMode", enableMaintenanceMode, "validate", validate), this.additionalHttpHeaders, JsonUtil.getInstance().convertPojoToJsonString(deploymentData), 200, false);
    }

    public String migrateModulesConfig(Map<String, Object> modulesConfigToMigrate) throws JsonProcessingException, DeploymentSystemException {
        LOG.info("migrateModulesConfig modulesConfigToMigrate=...");
        return this.httpPostJsonToEndpoint("/cxf/bpc-deployment/deployment/migrate", null, this.additionalHttpHeaders, JsonUtil.getInstance().convertPojoToJsonString(modulesConfigToMigrate), 200, false);
    }

    public MimeMultipartData downloadBundles(List<Number> bundleIDs) throws IOException, DeploymentSystemException {
        LOG.info("downloadBundles bundleIDs=" + bundleIDs);
        String downloadedBundles = this.httpPostJsonToEndpoint("/cxf/bpc-deployment/deployment/bundles/download", null, this.additionalHttpHeaders, JsonUtil.getInstance().convertPojoToJsonString(bundleIDs), 200, false);
        return JsonUtil.getInstance().convertJsonStringToPojo(downloadedBundles, MimeMultipartDataImpl.class);
    }

    public String uploadBundles(MimeMultipartData bundlesAsMultipartData) throws DeploymentSystemException {
        LOG.info("uploadBundles bundlesAsMultipartData=...");
        return this.httpPostToEndpoint("/cxf/bpc-deployment/deployment/bundles/import", this.additionalHttpHeaders, bundlesAsMultipartData, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, IndexInfo> getIndexInfos() throws DeploymentSystemException, JsonProcessingException {
        LOG.info("getIndexInfos");
        String resp = this.httpMethodFromEndpoint("GET", "/cxf/bpc-deployment/deployment/indices", null, this.additionalHttpHeaders, 200, true);
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Map map = (Map)mapper.readValue(resp, (TypeReference)new TypeReference<Map<String, IndexInfo>>(){});
            return map;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentIndexInfo getDeploymentIndexInfo(String indexName) throws DeploymentSystemException, JsonProcessingException {
        LOG.info("getDeploymentIndexInfo indexName=" + indexName);
        String resp = this.httpMethodFromEndpoint("GET", "/cxf/bpc-deployment/deployment/index/" + URLEncoder.encode(indexName, StandardCharsets.UTF_8) + "/info", null, this.additionalHttpHeaders, 200, true);
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            DeploymentIndexInfo deploymentIndexInfo = (DeploymentIndexInfo)mapper.readValue(resp, (TypeReference)new TypeReference<DeploymentIndexInfo>(){});
            return deploymentIndexInfo;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    public void prepareIndex(String alias, DeploymentIndexInfo indexInfo, boolean deleteExistingIndex) throws DeploymentSystemException, JsonProcessingException {
        LOG.info("prepareIndex alias=" + alias + ", indexInfo=" + indexInfo + ", deleteExistingIndex=" + deleteExistingIndex);
        this.httpPostJsonToEndpoint("/cxf/bpc-deployment/deployment/index/" + URLEncoder.encode(alias, StandardCharsets.UTF_8) + "/prepare", Map.of("delete_existing", deleteExistingIndex), this.additionalHttpHeaders, JsonUtil.getInstance().convertPojoToJsonString(indexInfo), 200, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentIndexData downloadFirstIndexBlock(String indexNameOrAlias, int blockSize) throws DeploymentSystemException, JsonProcessingException {
        LOG.info("downloadFirstIndexBlock indexNameOrAlias=" + indexNameOrAlias + ", blockSize=" + blockSize);
        String resp = this.httpMethodFromEndpoint("GET", "/cxf/bpc-deployment/deployment/index/" + URLEncoder.encode(indexNameOrAlias, StandardCharsets.UTF_8) + "/download", MapUtil.mapOf("blocksize", blockSize), this.additionalHttpHeaders, 200, true);
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            DeploymentIndexData deploymentIndexData = (DeploymentIndexData)mapper.readValue(resp, (TypeReference)new TypeReference<DeploymentIndexData>(){});
            return deploymentIndexData;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentIndexData downloadSubsequentIndexBlock(String indexNameOrAlias, String scrollId) throws DeploymentSystemException, JsonProcessingException {
        LOG.info("downloadSubsequentIndexBlock indexNameOrAlias=" + indexNameOrAlias + ", scrollId=" + scrollId);
        String resp = this.httpMethodFromEndpoint("GET", "/cxf/bpc-deployment/deployment/index/" + URLEncoder.encode(indexNameOrAlias, StandardCharsets.UTF_8) + "/download/" + scrollId, null, this.additionalHttpHeaders, 200, true);
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            DeploymentIndexData deploymentIndexData = (DeploymentIndexData)mapper.readValue(resp, (TypeReference)new TypeReference<DeploymentIndexData>(){});
            return deploymentIndexData;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    public void releaseScrollId(String indexNameOrAlias, String scrollId) throws DeploymentSystemException {
        LOG.info("releaseScrollId indexNameOrAlias=" + indexNameOrAlias + ", scrollId=" + scrollId);
        this.httpMethodFromEndpoint("DELETE", "/cxf/bpc-deployment/deployment/index/" + URLEncoder.encode(indexNameOrAlias, StandardCharsets.UTF_8) + "/download/" + scrollId, null, this.additionalHttpHeaders, 200, false);
    }

    public void uploadIndexData(String indexNameOrAlias, DeploymentIndexData indexData) throws DeploymentSystemException, JsonProcessingException {
        LOG.info("uploadIndexData indexNameOrAlias=" + indexNameOrAlias + ", indexData=...");
        this.httpPostJsonToEndpoint("/cxf/bpc-deployment/deployment/index/" + URLEncoder.encode(indexNameOrAlias, StandardCharsets.UTF_8) + "/upload", null, this.additionalHttpHeaders, JsonUtil.getInstance().convertPojoToJsonString(indexData.getData()), 200, true);
    }

    public void testConnection() throws DeploymentSystemException {
        this.httpMethodFromEndpoint("GET", "/cxf/bpc-core/configuration", null, this.additionalHttpHeaders, 200, true);
    }

    public String toString() {
        return "DeploymentSystem{deploymentSide=" + this.deploymentSide + ", serverUrl='" + this.serverUrl + "', apiKey='******', additionalHttpHeaders=" + this.additionalHttpHeaders + "}";
    }
}

