/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es;

import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.es.Broadcast;
import de.virtimo.bpc.core.es.plugin.response.BroadcastMessage;
import de.virtimo.bpc.util.MapUtil;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.logging.Logger;

public class BroadcastImpl
implements Broadcast {
    private static final Logger LOG = Logger.getLogger(BroadcastImpl.class.getName());
    private final EventManager eventManager;
    private final String serverUUID;

    public BroadcastImpl(EventManager eventManager, String serverUUID) {
        this.eventManager = eventManager;
        this.serverUUID = serverUUID;
    }

    private void broadcastConfigChangeMessage(BroadcastMessage.BroadcastType bpcConfigurationType, Map<String, Object> data) {
        LOG.info("broadcastConfigChangeMessage bpcConfigurationType=" + bpcConfigurationType + ", data=...");
        BroadcastMessage broadcastMessage = new BroadcastMessage();
        broadcastMessage.setSender(this.serverUUID);
        broadcastMessage.setSendedAt(LocalDateTime.now());
        broadcastMessage.setType(bpcConfigurationType.name());
        broadcastMessage.setData(data);
        this.eventManager.fireEvent("de/virtimo/es-bpc-plugin-send-broadcast-message", "msg", broadcastMessage);
    }

    @Override
    public void moduleInstanceCreated(String moduleId, String instanceId, String instanceType) {
        LOG.info("moduleInstanceCreated moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType);
        this.broadcastConfigChangeMessage(BroadcastMessage.BroadcastType.ModuleInstanceCreated, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType));
    }

    @Override
    public void moduleUpdated(String moduleId) {
        LOG.info("moduleUpdated moduleId=" + moduleId);
        this.broadcastConfigChangeMessage(BroadcastMessage.BroadcastType.ModuleUpdated, MapUtil.mapOf("moduleId", moduleId));
    }

    @Override
    public void moduleInstanceUpdated(String moduleId, String instanceId, String instanceType) {
        LOG.info("moduleInstanceUpdated moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType);
        this.broadcastConfigChangeMessage(BroadcastMessage.BroadcastType.ModuleInstanceUpdated, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType));
    }

    @Override
    public void moduleInstanceDeleted(String moduleId, String instanceId) {
        LOG.info("moduleInstanceDeleted moduleId=" + moduleId + ", instanceId=" + instanceId);
        this.broadcastConfigChangeMessage(BroadcastMessage.BroadcastType.ModuleInstanceDeleted, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId));
    }

    @Override
    public void moduleSettingDeleted(String moduleId, String settingName) {
        LOG.info("moduleSettingDeleted moduleId=" + moduleId + ", settingName=" + settingName);
        this.broadcastConfigChangeMessage(BroadcastMessage.BroadcastType.ModuleUpdated, MapUtil.mapOf("moduleId", moduleId));
    }

    @Override
    public void moduleInstanceSettingDeleted(String moduleId, String instanceId, String instanceType, String settingName) {
        LOG.info("moduleInstanceSettingDeleted moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType + ", settingName=" + settingName);
        this.broadcastConfigChangeMessage(BroadcastMessage.BroadcastType.ModuleInstanceUpdated, MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType));
    }

    @Override
    public void clientEvent(Map<String, Object> clientEvent) {
        LOG.info("clientEvent clientEvent=" + clientEvent);
        this.broadcastConfigChangeMessage(BroadcastMessage.BroadcastType.ClientEvent, clientEvent);
    }
}

