/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es;

import de.virtimo.bpc.api.es.ManagedIndicesHandler;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.util.StringUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ManagedIndicesHandlerImpl
implements ManagedIndicesHandler {
    private static final Logger LOG = Logger.getLogger(ManagedIndicesHandlerImpl.class.getName());
    private final BundleContext bundleContext;
    private final ElasticsearchService es;

    public ManagedIndicesHandlerImpl(BundleContext bundleContext, ElasticsearchService es) {
        this.bundleContext = bundleContext;
        this.es = es;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public Map<String, Map<String, Object>> getManagedIndexConfigsFromAllBpcBackendBundles() {
        LOG.info("getManagedIndexConfigsFromAllBpcBackendBundles");
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        if (this.bundleContext != null) {
            for (Bundle bundle : this.bundleContext.getBundles()) {
                Set<URL> urlsToManagedIndicesFiles;
                if (!BpcBundleUtil.isBpcBackendBundle(bundle) || (urlsToManagedIndicesFiles = BpcBundleUtil.getFilesInBundle(bundle, "managed_indices.json")).isEmpty()) continue;
                for (URL urlToManagedIndicesFile : urlsToManagedIndicesFiles) {
                    String filePath = urlToManagedIndicesFile.getFile();
                    Map<String, Object> managedIndicesConfigMap = JsonDefaultsUtil.loadJsonFileAsMap(bundle, filePath);
                    if (managedIndicesConfigMap == null || !managedIndicesConfigMap.containsKey("managedIndices")) continue;
                    List managedIndices = (List)managedIndicesConfigMap.get("managedIndices");
                    for (Map indexConfiguration : managedIndices) {
                        String indexAlias = (String)indexConfiguration.get("name");
                        if (indexAlias == null) continue;
                        result.put(indexAlias, indexConfiguration);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> getManagedIndexConfigFromAllBpcBackendBundles(String indexAliasName) {
        LOG.info("getManagedIndexConfigFromAllBpcBackendBundles indexAliasName=" + indexAliasName);
        if (StringUtil.isNullOrEmpty(indexAliasName)) {
            return null;
        }
        for (Bundle bundle : this.bundleContext.getBundles()) {
            Set<URL> urlsToManagedIndicesFiles;
            if (!BpcBundleUtil.isBpcBackendBundle(bundle) || (urlsToManagedIndicesFiles = BpcBundleUtil.getFilesInBundle(bundle, "managed_indices.json")).isEmpty()) continue;
            for (URL urlToManagedIndicesFile : urlsToManagedIndicesFiles) {
                String filePath = urlToManagedIndicesFile.getFile();
                Map<String, Object> managedIndicesConfigMap = JsonDefaultsUtil.loadJsonFileAsMap(bundle, filePath);
                Map<String, Object> managedIndexConfigMap = this.getManagedIndexConfig(indexAliasName, managedIndicesConfigMap);
                if (managedIndexConfigMap == null) continue;
                return managedIndexConfigMap;
            }
        }
        return null;
    }

    private Map<String, Object> getManagedIndexConfig(String indexAliasName, Map<String, Object> managedIndicesConfigMap) {
        LOG.info("getManagedIndexConfig indexAliasName=" + indexAliasName + ", managedIndicesConfigMap=...");
        if (managedIndicesConfigMap != null && managedIndicesConfigMap.containsKey("managedIndices")) {
            List managedIndices = (List)managedIndicesConfigMap.get("managedIndices");
            for (Map indexConfiguration : managedIndices) {
                String name = (String)indexConfiguration.get("name");
                if (name == null || !name.equalsIgnoreCase(indexAliasName)) continue;
                return indexConfiguration;
            }
        }
        return null;
    }

    private Map<String, Object> getManagedIndexConfigFromCoreBundle(String indexAliasName) {
        LOG.info("getManagedIndexConfigFromCoreBundle indexAliasName=" + indexAliasName);
        Map<String, Object> managedIndicesConfigMap = JsonDefaultsUtil.loadJsonFileAsMap("managed_indices.json");
        return this.getManagedIndexConfig(indexAliasName, managedIndicesConfigMap);
    }

    @Override
    public boolean isManagedIndex(String indexAliasName) {
        Map<String, Object> indexConfiguration = this.getManagedIndexConfigFromCoreBundle(indexAliasName);
        return indexConfiguration != null;
    }

    @Override
    public String createManagedIndex(String indexAliasName) throws ElasticsearchRelatedException {
        LOG.info("createManagedIndex indexAliasName=" + indexAliasName);
        return this.createManagedIndex(indexAliasName, null, true);
    }

    @Override
    public String createManagedIndex(String indexAliasName, String indexName, boolean addAlias) throws ElasticsearchRelatedException {
        LOG.info("createManagedIndexWithoutAlias indexAliasName=" + indexAliasName + ", indexName=" + indexName + ", addAlias=" + addAlias);
        Map<String, Object> indexConfiguration = this.getManagedIndexConfigFromCoreBundle(indexAliasName);
        Map settings = null;
        if (indexConfiguration != null && indexConfiguration.containsKey("settings")) {
            settings = (Map)indexConfiguration.get("settings");
        }
        if (settings == null) {
            settings = this.es.getDefaultIndexCreationSettings();
        }
        Map mappings = null;
        if (indexConfiguration != null && indexConfiguration.containsKey("mappings")) {
            mappings = (Map)indexConfiguration.get("mappings");
        }
        return this.es.createIndex(addAlias ? indexAliasName : null, indexName, settings, mappings);
    }

    @Override
    public void prepareManagedIndices(Map<String, Object> managedIndicesConfigMap) throws ElasticsearchRelatedException {
        LOG.info("prepareManagedIndices managedIndicesConfigMap=...");
        if (managedIndicesConfigMap != null && managedIndicesConfigMap.containsKey("managedIndices")) {
            List managedIndices = (List)managedIndicesConfigMap.get("managedIndices");
            for (Map indexConfiguration : managedIndices) {
                if (indexConfiguration.containsKey("create_on_start") && !indexConfiguration.get("create_on_start").equals(Boolean.TRUE)) continue;
                String aliasName = (String)indexConfiguration.get("name");
                if (aliasName != null && !this.es.existsIndex(aliasName) && this.es.getIndexNamesWithAlias(aliasName).size() == 0) {
                    LOG.finest("No index or alias with name " + aliasName + " found. Create index now.");
                    Map mappings = (Map)indexConfiguration.get("mappings");
                    Map settings = (Map)indexConfiguration.get("settings");
                    this.es.createIndex(aliasName, settings, mappings);
                    continue;
                }
                LOG.info("Skip creation of existing index or alias " + aliasName);
            }
        }
    }
}

