/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.es.BpcIndexCreateCallable;
import de.virtimo.bpc.api.es.BpcIndexState;
import de.virtimo.bpc.api.es.BpcIndexStateException;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.SettingFactory;
import de.virtimo.bpc.core.es.PasswordEncryptorService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.jetbrains.annotations.NotNull;

public class ModuleConfigurationPersistenceHandler {
    private static final Logger LOG = Logger.getLogger(ModuleConfigurationPersistenceHandler.class.getName());
    private final ElasticsearchService es;
    private final PasswordEncryptorService passwordEncryptorService;
    private static final Object PREPARE_BPC_CONFIGURATION_INDEX_LOCK = new Object();

    public ModuleConfigurationPersistenceHandler(ElasticsearchService es, PasswordEncryptorService passwordEncryptorService) {
        this.es = es;
        this.passwordEncryptorService = passwordEncryptorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareIndex() throws BpcIndexStateException, ElasticsearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
        LOG.fine("prepareIndex es=...");
        Object object = PREPARE_BPC_CONFIGURATION_INDEX_LOCK;
        synchronized (object) {
            BpcIndexState bpcConfigurationIndexState = this.es.getIndexState("bpc-configuration");
            bpcConfigurationIndexState.prepareUsing(new BpcIndexCreateCallable(){

                @Override
                public String createIndex(ElasticsearchService es) throws ElasticsearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                    return es.getManagedIndicesHandler().createManagedIndex("bpc-configuration");
                }
            });
        }
    }

    public static boolean settingsAreDifferent(Setting previousSetting, Setting currentSetting) throws SettingException {
        byte[] previousSettingBytes = previousSetting == null ? null : ModuleConfigurationPersistenceHandler.convertSetting(previousSetting);
        byte[] currentSettingBytes = ModuleConfigurationPersistenceHandler.convertSetting(currentSetting);
        return previousSettingBytes == null || !Arrays.equals(previousSettingBytes, currentSettingBytes);
    }

    private static byte[] convertSetting(Setting s) throws SettingException {
        LOG.finest("convertSetting: " + s);
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            byte[] byArray = mapper.writeValueAsBytes((Object)s);
            return byArray;
        }
        catch (IOException ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "Failed to convert the Setting with the ID '${settingId}' to a byte array.", MapUtil.mapOf("settingId", s.getId()), (Throwable)ex);
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    private Set<String> getSettingIDs(Collection<Setting> settings) {
        HashSet<String> result = new HashSet<String>();
        if (settings != null && !settings.isEmpty()) {
            for (Setting setting : settings) {
                if (setting.getId() == null) continue;
                result.add(setting.getId());
            }
        }
        return result;
    }

    private boolean isPasswordSetting(Setting setting) {
        return setting != null && "password".equalsIgnoreCase(setting.getType());
    }

    private Setting preparedSettingForSave(Setting settingToSave) {
        LOG.finest("preparedSettingForSave settingToSave=...");
        if (this.isPasswordSetting(settingToSave)) {
            String encryptedPassword = this.passwordEncryptorService.encrypt((String)settingToSave.getValue());
            SimpleSettingImpl passwordEncryptedSetting = new SimpleSettingImpl(settingToSave);
            passwordEncryptedSetting.setValue(encryptedPassword);
            return passwordEncryptedSetting;
        }
        return settingToSave;
    }

    private Setting preparedSettingAfterLoad(Setting loadedSetting) {
        LOG.finest("preparedSettingAfterLoad loadedSetting=...");
        if (this.isPasswordSetting(loadedSetting)) {
            String decryptedPassword = this.passwordEncryptorService.decrypt((String)loadedSetting.getValue());
            SimpleSettingImpl passwordDecryptedSetting = new SimpleSettingImpl(loadedSetting);
            passwordDecryptedSetting.setValue(decryptedPassword);
            return passwordDecryptedSetting;
        }
        return loadedSetting;
    }

    public boolean saveSetting(Setting setting) throws SettingException {
        LOG.info("saveSetting setting:" + setting);
        if (setting == null || setting.getId() == null) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "Failed to save module setting. At least one mandatory field of the setting is not set: ${setting}", MapUtil.mapOf("setting", "" + setting));
        }
        long saveSettingTime = System.currentTimeMillis();
        try {
            this.prepareIndex();
            RestHighLevelClient esClient = this.es.getClient();
            Setting previousSetting = this.readModuleSetting(esClient, setting.getId());
            if (ModuleConfigurationPersistenceHandler.settingsAreDifferent(previousSetting, setting)) {
                LOG.finest(setting.getId() + ": modified and gets saved");
                Setting settingToSave = this.preparedSettingForSave(setting);
                esClient.index(((IndexRequest)new IndexRequest().index("bpc-configuration")).id(settingToSave.getId()).source(ModuleConfigurationPersistenceHandler.convertSetting(settingToSave), XContentType.JSON), RequestOptions.DEFAULT);
                boolean bl = true;
                return bl;
            }
            LOG.finest(setting.getId() + ": not modified and must not be saved!");
            boolean bl = false;
            return bl;
        }
        catch (ElasticsearchRelatedException | IOException | ElasticsearchException ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "Failed to save the setting with the ID '${settingId}' due to an Elasticsearch error: ${error}", MapUtil.mapOf("settingId", setting.getId(), "error", ex.getMessage()), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "Failed to save the setting with the ID '${settingId}'.", MapUtil.mapOf("settingId", setting.getId(), "error", ex.getMessage()), (Throwable)ex);
        }
        finally {
            LOG.info(setting.getId() + ": saveSetting done in " + (System.currentTimeMillis() - saveSettingTime) + " ms");
        }
    }

    protected void saveSettings(Collection<Setting> settings) throws SettingException {
        LOG.info("saveSettings settings=...");
        if (settings == null || settings.isEmpty()) {
            return;
        }
        for (Setting setting : settings) {
            if (setting != null && setting.getId() != null) continue;
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "Failed to save settings. At least one mandatory field of a setting is not set: ${setting}", MapUtil.mapOf("setting", "" + setting));
        }
        long saveSettingsTime = System.currentTimeMillis();
        try {
            BulkResponse bulkResponse;
            this.prepareIndex();
            RestHighLevelClient esClient = this.es.getClient();
            Map<String, Setting> previousSettings = this.readModuleSettings(esClient, this.getSettingIDs(settings));
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (Setting setting : settings) {
                try {
                    Setting previousSetting = previousSettings.get(setting.getId());
                    if (ModuleConfigurationPersistenceHandler.settingsAreDifferent(previousSetting, setting)) {
                        LOG.finest(setting.getId() + ": modified and gets prepared for save");
                        Setting settingToSave = this.preparedSettingForSave(setting);
                        bulkRequest.add(((IndexRequest)new IndexRequest().index("bpc-configuration")).id(settingToSave.getId()).source(ModuleConfigurationPersistenceHandler.convertSetting(settingToSave), XContentType.JSON));
                        continue;
                    }
                    LOG.finest(setting.getId() + ": not modified and must not be saved!");
                }
                catch (SettingException e) {
                    throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "The setting with the ID '${settingId}' could not be saved.", MapUtil.mapOf("settingId", setting.getId(), "error", e.getLocalizedMessage()), (Throwable)e);
                }
            }
            if (bulkRequest.numberOfActions() > 0 && (bulkResponse = esClient.bulk(bulkRequest, RequestOptions.DEFAULT)).hasFailures()) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "Failed to bulk save the module configuration settings: ${error}", MapUtil.mapOf("error", bulkResponse.buildFailureMessage()));
            }
        }
        catch (ElasticsearchRelatedException | IOException | ElasticsearchException ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "Failed to save the module configuration settings due to an Elasticsearch error: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "Failed to save the module configuration settings: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
        }
        finally {
            LOG.fine("saveConfiguration time: " + (System.currentTimeMillis() - saveSettingsTime) + " ms");
        }
    }

    private Map<String, Setting> readModuleSettings(RestHighLevelClient esClient, Set<String> settingIDs) throws SettingException, ElasticsearchRelatedException {
        LOG.finest("readModuleSettings esClient=... settingIDs=...");
        try {
            HashMap<String, Setting> result = new HashMap<String, Setting>();
            if (settingIDs != null && !settingIDs.isEmpty()) {
                MultiGetRequest multiGetReq = new MultiGetRequest();
                for (String settingID : settingIDs) {
                    multiGetReq.add("bpc-configuration", settingID);
                }
                MultiGetResponse multiGetItemResponses = esClient.mget(multiGetReq, RequestOptions.DEFAULT);
                for (MultiGetItemResponse itemResponse : multiGetItemResponses) {
                    byte[] settingBytes;
                    GetResponse response = itemResponse.getResponse();
                    if (response == null || !response.isExists() || (settingBytes = response.getSourceAsBytes()) == null) continue;
                    String settingId = response.getId();
                    Setting s = SettingFactory.parseJsonSetting(settingBytes);
                    result.put(settingId, this.preparedSettingAfterLoad(s));
                }
            }
            return result;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    private Setting readModuleSetting(RestHighLevelClient esClient, String settingId) throws SettingException, ElasticsearchRelatedException {
        LOG.finest("readModuleSetting esClient=... settingId=" + settingId);
        try {
            byte[] settingBytes;
            GetRequest getReq = ((GetRequest)new GetRequest().index("bpc-configuration")).id(settingId);
            GetResponse response = esClient.get(getReq, RequestOptions.DEFAULT);
            if (response != null && (settingBytes = response.getSourceAsBytes()) != null) {
                Setting s = SettingFactory.parseJsonSetting(settingBytes);
                return this.preparedSettingAfterLoad(s);
            }
            return null;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    public Map<String, Setting> readModuleSettings(String moduleId, String instanceId) throws SettingException {
        LOG.info("readModuleSettings moduleId=" + moduleId + ", instanceId=" + instanceId);
        return this.readModuleSettings(moduleId, instanceId, null);
    }

    public Map<String, Setting> readModuleSettings(String moduleId, String instanceId, String instanceType) throws SettingException {
        LOG.info("readModuleSettings moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType);
        HashMap<String, Setting> settings = new HashMap<String, Setting>();
        long startTime = System.currentTimeMillis();
        try {
            RestHighLevelClient esClient = this.es.getClient();
            BoolQueryBuilder qb = instanceType == null ? QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", moduleId)).must(QueryBuilders.termQuery("instanceId", instanceId)) : QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", moduleId)).must(QueryBuilders.termQuery("instanceId", instanceId)).must(QueryBuilders.termQuery("instanceType", instanceType));
            LOG.info("readModuleSettings query: \n" + qb);
            SearchRequest searchReq = new SearchRequest().indices("bpc-configuration").source(new SearchSourceBuilder().size(100).query(qb).sort("_doc", SortOrder.ASC)).scroll(new TimeValue(60000L));
            LOG.info("readModuleSettings search request: " + searchReq);
            SearchResponse searchResponse = esClient.search(searchReq, RequestOptions.DEFAULT);
            LOG.info("Number of settings read from Elasticsearch: " + searchResponse.getHits().getTotalHits().value);
            if (searchResponse.getHits().getTotalHits().value > 0L) {
                do {
                    for (SearchHit hit : searchResponse.getHits().getHits()) {
                        Setting s = SettingFactory.parseJsonSetting(hit.getSourceRef().toBytesRef().bytes);
                        if (s != null && hit.getId().equals(s.getId())) {
                            Setting psal = this.preparedSettingAfterLoad(s);
                            settings.put(psal.getName(), psal);
                            continue;
                        }
                        LOG.warning("Skipping the invalid module setting: " + s);
                    }
                } while ((searchResponse = esClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
            }
            this.es.releaseScrollId(searchResponse);
        }
        catch (ElasticsearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                LOG.warning("Can't read the '" + moduleId + "' module settings. The Elasticsearch index '" + ex.getIndex() + "' is missing. Should happen only on first start or when someone deleted that index!");
            } else {
                LOG.log(Level.SEVERE, "Unhandled exception in ModuleManagerImpl.readModuleSettings(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            }
        }
        catch (Exception ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "Failed to read module settings. Invalid settings data for moduleId=${moduleId}, instanceId=${instanceId} and instanceType=${instanceType}", MapUtil.mapOf("moduleId", moduleId, "instanceId", instanceId, "instanceType", instanceType), (Throwable)ex);
        }
        finally {
            LOG.info("readModuleSettings done in " + (System.currentTimeMillis() - startTime) + "ms");
        }
        return settings;
    }

    public static List<Setting> readAllSettingsFromBpcConfigurationIndex(ElasticsearchService es, String bpcConfigurationIndexName) throws ElasticsearchRelatedException {
        LOG.info("readAllSettingsFromBpcConfigurationIndex es=..., bpcConfigurationIndexName=" + bpcConfigurationIndexName);
        try {
            ArrayList<Setting> result = new ArrayList<Setting>();
            RestHighLevelClient esClient = es.getClient();
            SearchRequest searchReq = new SearchRequest().indices(bpcConfigurationIndexName).scroll(new TimeValue(60000L)).source(new SearchSourceBuilder().size(500).query(QueryBuilders.matchAllQuery()));
            SearchResponse searchResponse = esClient.search(searchReq, RequestOptions.DEFAULT);
            do {
                for (SearchHit hit : searchResponse.getHits().getHits()) {
                    Map<String, Object> sourceValues = hit.getSourceAsMap();
                    Setting setting = SettingFactory.parseMapSetting(sourceValues);
                    if (setting == null) continue;
                    result.add(setting);
                }
            } while ((searchResponse = esClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
            return result;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    @NotNull
    public Set<String> readModuleInstanceIDs(String moduleId) throws ElasticsearchRelatedException {
        LOG.fine("readModuleInstanceIDs moduleId=" + moduleId);
        return this.readModuleInstanceIDs(moduleId, null);
    }

    @NotNull
    public Set<String> readModuleInstanceIDs(String moduleId, String instanceType) throws ElasticsearchRelatedException {
        LOG.fine("readModuleInstanceIDs moduleId=" + moduleId + ", instanceType=" + instanceType);
        try {
            HashSet<String> instanceIDs = new HashSet<String>();
            RestHighLevelClient esClient = this.es.getClient();
            BoolQueryBuilder qb = instanceType == null ? QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", moduleId)).mustNot(QueryBuilders.termQuery("instanceId", "noinstance")) : QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", moduleId)).mustNot(QueryBuilders.termQuery("instanceId", "noinstance")).must(QueryBuilders.termQuery("instanceType", instanceType));
            SearchRequest s = new SearchRequest().indices("bpc-configuration").source(new SearchSourceBuilder().size(0).query(qb).aggregation(((TermsAggregationBuilder)AggregationBuilders.terms("instanceIds").field("instanceId")).size(Integer.MAX_VALUE)));
            LOG.info("readModuleInstanceIDs search request: " + s);
            SearchResponse sr = esClient.search(s, RequestOptions.DEFAULT);
            Terms instances = (Terms)sr.getAggregations().get("instanceIds");
            LOG.info("agg instance keys: " + instances.getBuckets().toString());
            for (Terms.Bucket bucket : instances.getBuckets()) {
                String key = bucket.getKeyAsString();
                long docCount = bucket.getDocCount();
                instanceIDs.add(key);
                LOG.log(Level.INFO, "key [{0}], doc_count [{1}]", new Object[]{key, docCount});
            }
            return instanceIDs;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    public String readInstanceType(String moduleId, String instanceId) throws SettingException, ElasticsearchRelatedException {
        LOG.info("readInstanceType moduleId=" + moduleId + ", instanceId=" + instanceId);
        try {
            RestHighLevelClient esClient = this.es.getClient();
            SearchRequest s = new SearchRequest().indices("bpc-configuration").source(new SearchSourceBuilder().size(0).query(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", moduleId)).must(QueryBuilders.termQuery("instanceId", instanceId))).aggregation(((TermsAggregationBuilder)AggregationBuilders.terms("instanceTypes").field("instanceType")).size(Integer.MAX_VALUE)));
            LOG.info("readInstanceType search request: " + s);
            SearchResponse sr = esClient.search(s, RequestOptions.DEFAULT);
            Terms instanceTypesTerms = (Terms)sr.getAggregations().get("instanceTypes");
            LOG.info("agg instance types: " + instanceTypesTerms.getBuckets().toString());
            ArrayList<String> instanceTypes = new ArrayList<String>();
            for (Terms.Bucket bucket : instanceTypesTerms.getBuckets()) {
                String key = bucket.getKeyAsString();
                long docCount = bucket.getDocCount();
                LOG.info("Key [" + key + "], doc_count [" + docCount);
                instanceTypes.add(key);
            }
            if (instanceTypes.size() > 1) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "Invalid settings data for moduleId=${moduleId} and instanceId=${instanceId}. Only one instance type allowed, but found: ${instanceTypesFound}", MapUtil.mapOf("moduleId", moduleId, "instanceId", instanceId, "instanceTypesFound", "" + instanceTypes));
            }
            if (instanceTypes.size() == 1) {
                return (String)instanceTypes.get(0);
            }
            return "none";
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    protected Setting deleteSetting(Setting setting) throws SettingException {
        LOG.info("delete setting: " + setting);
        if (setting == null || setting.getId() == null) {
            return null;
        }
        try {
            RestHighLevelClient esClient = this.es.getClient();
            DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index("bpc-configuration")).id(setting.getId());
            DeleteResponse response = esClient.delete(deleteRequest, RequestOptions.DEFAULT);
            if (response.status() == RestStatus.NOT_FOUND) {
                LOG.warning("Could not find the setting to delete: " + setting);
            }
            return setting;
        }
        catch (IOException | ElasticsearchException ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_DELETE_FAILED, "Failed to delete the setting with the id '${settingId}' due to an Elasticsearch error: ${error}", MapUtil.mapOf("settingId", setting.getId(), "error", ex.getLocalizedMessage()), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_DELETE_FAILED, "Failed to delete the setting with the id '${settingId}' due to: ${error}", MapUtil.mapOf("settingId", setting.getId(), "error", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    public void deleteModuleInstance(String moduleId, String instanceId) throws ElasticsearchRelatedException {
        LOG.info("deleteModuleInstance moduleId=" + moduleId + ", instanceId=" + instanceId);
        try {
            RestHighLevelClient esClient = this.es.getClient();
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest("bpc-configuration").setQuery(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", moduleId)).must(QueryBuilders.termQuery("instanceId", instanceId)));
            LOG.info("deleteModuleInstance delete by query request: " + deleteByQueryRequest);
            BulkByScrollResponse dbqrsp = esClient.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            LOG.info("deleteModuleInstance Deleted " + dbqrsp.getDeleted() + " related documents from bpc-configuration");
        }
        catch (ElasticsearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                LOG.warning("Ignorning deletion of not existing index.");
            }
            throw new ElasticsearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }
}

