/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.migration;

import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.es.migration.IndexToMigrate;
import de.virtimo.bpc.core.es.migration.Migration;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

abstract class AllSearchHitsMigration
extends Migration {
    private static final Logger LOG = Logger.getLogger(AllSearchHitsMigration.class.getName());
    protected int newModelVersion;

    public AllSearchHitsMigration(ElasticsearchService es, int newModelVersion) {
        super(es);
        this.newModelVersion = newModelVersion;
    }

    abstract List<IndexRequest> migrateSearchHit(RestHighLevelClient var1, IndexToMigrate var2, IndexToMigrate var3, SearchHit var4);

    public IndexToMigrate migrateIndex(final IndexToMigrate oldIndex) throws IndexMigrationException {
        LOG.info("migrateIndex oldIndex=" + oldIndex);
        final ElasticsearchService es = this.getElasticsearchService();
        final IndexToMigrate newIndex = new IndexToMigrate(oldIndex.getAlias(), es.newIndexNameForAlias(oldIndex.getAlias()));
        this.migrate(oldIndex, newIndex, this.newModelVersion, new Migration.Migrator(){

            @Override
            public void migrate(RestHighLevelClient esClient) throws ElasticsearchRelatedException {
                try {
                    SearchRequest request = new SearchRequest().indices(oldIndex.getName()).scroll(new TimeValue(60000L)).source(new SearchSourceBuilder().size(500).query(QueryBuilders.matchAllQuery()));
                    SearchResponse searchResponse = esClient.search(request, RequestOptions.DEFAULT);
                    BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
                    do {
                        for (SearchHit hit : searchResponse.getHits().getHits()) {
                            List<IndexRequest> migrated = AllSearchHitsMigration.this.migrateSearchHit(esClient, oldIndex, newIndex, hit);
                            if (migrated != null && !migrated.isEmpty()) {
                                for (IndexRequest indexRequest : migrated) {
                                    bulkRequest.add(indexRequest);
                                }
                            }
                            if (bulkRequest.numberOfActions() <= 250) continue;
                            BulkResponse bulkResponse = esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                            LOG.info("indexed {" + bulkRequest.numberOfActions() + "}, hasFailures: {" + bulkResponse.hasFailures() + "}");
                            bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
                        }
                    } while ((searchResponse = esClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
                    es.releaseScrollId(searchResponse);
                    if (bulkRequest.numberOfActions() > 0) {
                        BulkResponse bulkResponse = esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                        LOG.info("indexed {" + bulkRequest.numberOfActions() + "}, hasFailures: {" + bulkResponse.hasFailures() + "}");
                    }
                }
                catch (IOException ex) {
                    throw new ElasticsearchRelatedException(ex);
                }
                catch (ElasticsearchException ex) {
                    throw new ElasticsearchRelatedException(ex);
                }
            }
        });
        try {
            es.refreshIndices(newIndex.getName());
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to refresh the migrated index: " + newIndex);
        }
        return newIndex;
    }
}

