/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.migration;

import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.es.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.es.migration.IndexToMigrate;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class BpcConfigurationIndexMigrationFromModelVersion10To11
extends AllSearchHitsMigration {
    private static final Logger LOG = Logger.getLogger(BpcConfigurationIndexMigrationFromModelVersion10To11.class.getName());
    private static final boolean testRun = false;
    private final Map<String, String> convertedInstanceIDsCache = new HashMap<String, String>();

    public BpcConfigurationIndexMigrationFromModelVersion10To11(ElasticsearchService es) {
        super(es, 11);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient esClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        String newDataSourceInstanceId;
        SearchHit oldDataSourceNameSettingSearchHit;
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOG.warning("Skipping document with ID mismatch: " + hit.getId() + " != " + sourceValues.get("id"));
            return null;
        }
        if ("replication".equals(sourceValues.get("moduleId")) && "rdmsDataSourceName".equals(sourceValues.get("name"))) {
            try {
                String newDataSourceInstanceId2;
                SearchHit oldDataSourceNameSettingSearchHit2;
                String oldDataSourceNameOfReplicationJob = (String)sourceValues.get("value");
                if (!StringUtil.isNullOrEmpty(oldDataSourceNameOfReplicationJob) && (oldDataSourceNameSettingSearchHit2 = this.getOldDataSourceNameSetting(esClient, oldIndex, oldDataSourceNameOfReplicationJob)) != null && !oldDataSourceNameOfReplicationJob.equals(newDataSourceInstanceId2 = this.getNewUniqueInstanceIdGeneratedFromDataSourceName(esClient, oldIndex, oldDataSourceNameSettingSearchHit2.getSourceAsMap()))) {
                    HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
                    updatedSourceValues.put("value", newDataSourceInstanceId2);
                    return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(updatedSourceValues, XContentType.JSON));
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to update the replication job instance setting named 'rdmsDataSourceName'.", ex);
            }
        }
        if ("logservice".equals(sourceValues.get("moduleId")) && "rdms".equals(sourceValues.get("name"))) {
            try {
                String oldDataSourceNameOfLogService;
                Object rdmsDataSourceNameObject;
                Map rdms;
                Object rdmsObject = sourceValues.get("value");
                if (rdmsObject instanceof Map && (rdms = (Map)rdmsObject).containsKey("rdmsDataSourceName") && (rdmsDataSourceNameObject = rdms.get("rdmsDataSourceName")) instanceof String && !StringUtil.isNullOrEmpty(oldDataSourceNameOfLogService = (String)rdmsDataSourceNameObject) && (oldDataSourceNameSettingSearchHit = this.getOldDataSourceNameSetting(esClient, oldIndex, oldDataSourceNameOfLogService)) != null && !oldDataSourceNameOfLogService.equals(newDataSourceInstanceId = this.getNewUniqueInstanceIdGeneratedFromDataSourceName(esClient, oldIndex, oldDataSourceNameSettingSearchHit.getSourceAsMap()))) {
                    HashMap<String, String> updatedRdms = new HashMap<String, String>(rdms);
                    updatedRdms.put("rdmsDataSourceName", newDataSourceInstanceId);
                    HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
                    updatedSourceValues.put("value", updatedRdms);
                    return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(updatedSourceValues, XContentType.JSON));
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to update the log service instance setting named 'rdms'.", ex);
            }
        }
        if ("backendconnection".equals(sourceValues.get("moduleId")) && "identity_provider".equals(sourceValues.get("instanceType")) && "identityProvider_configuration".equals(sourceValues.get("name"))) {
            try {
                String oldDataSourceName;
                Object dataSourceNameObject;
                Map idpConfig;
                Object idpConfigObject = sourceValues.get("value");
                if (idpConfigObject instanceof Map && (idpConfig = (Map)idpConfigObject).containsKey("datasource") && (dataSourceNameObject = idpConfig.get("datasource")) instanceof String && !StringUtil.isNullOrEmpty(oldDataSourceName = (String)dataSourceNameObject) && (oldDataSourceNameSettingSearchHit = this.getOldDataSourceNameSetting(esClient, oldIndex, oldDataSourceName)) != null && !oldDataSourceName.equals(newDataSourceInstanceId = this.getNewUniqueInstanceIdGeneratedFromDataSourceName(esClient, oldIndex, oldDataSourceNameSettingSearchHit.getSourceAsMap()))) {
                    HashMap<String, String> updatedIdpConfig = new HashMap<String, String>(idpConfig);
                    updatedIdpConfig.put("datasource", newDataSourceInstanceId);
                    HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
                    updatedSourceValues.put("value", updatedIdpConfig);
                    return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(updatedSourceValues, XContentType.JSON));
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to update the JAAS JDBC identity provider setting named 'identityProvider_configuration'.", ex);
            }
        }
        if ("backendconnection".equals(sourceValues.get("moduleId")) && "data_source".equals(sourceValues.get("instanceType"))) {
            String settingName = (String)sourceValues.get("name");
            if ("dataSourceName".equals(settingName)) {
                return null;
            }
            try {
                Map dataSourceConfiguration;
                Object dataSourceConfigurationObject;
                String newUniqueInstanceIdGeneratedFromDataSourceName = this.getNewUniqueInstanceIdGeneratedFromDataSourceName(esClient, oldIndex, sourceValues);
                String newId = this.createSettingId("backendconnection", newUniqueInstanceIdGeneratedFromDataSourceName, settingName);
                HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
                updatedSourceValues.put("id", newId);
                updatedSourceValues.put("instanceId", newUniqueInstanceIdGeneratedFromDataSourceName);
                if ("configuration".equals(settingName) && (dataSourceConfigurationObject = updatedSourceValues.get("value")) instanceof Map && (dataSourceConfiguration = (Map)dataSourceConfigurationObject).containsKey("dataSourceName")) {
                    dataSourceConfiguration.remove("dataSourceName");
                    updatedSourceValues.put("value", dataSourceConfiguration);
                }
                return Collections.singletonList(new IndexRequest(newIndex.getName()).id(newId).source(updatedSourceValues, XContentType.JSON));
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to convert a data_source related backend connection setting.", ex);
            }
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, XContentType.JSON));
    }

    private SearchHit getOldDataSourceNameSetting(RestHighLevelClient esClient, IndexToMigrate oldIndex, String dataSourceName) throws IOException {
        if (!StringUtil.isNullOrEmpty(dataSourceName)) {
            SearchRequest request = new SearchRequest().indices(oldIndex.getName()).source(new SearchSourceBuilder().size(10).query(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", "backendconnection")).must(QueryBuilders.termQuery("instanceType", "data_source")).must(QueryBuilders.termQuery("name", "dataSourceName")))).scroll(new TimeValue(60000L));
            SearchResponse response = esClient.search(request, RequestOptions.DEFAULT);
            if (response.getHits().getTotalHits().value > 0L) {
                do {
                    SearchHit[] hits;
                    for (SearchHit hit : hits = response.getHits().getHits()) {
                        Map<String, Object> sourceAsMap = hit.getSourceAsMap();
                        String dataSourceNameFromHit = (String)sourceAsMap.get("value");
                        if (!dataSourceName.equals(dataSourceNameFromHit)) continue;
                        return hit;
                    }
                } while ((response = esClient.scroll(new SearchScrollRequest(response.getScrollId()).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
            }
        }
        return null;
    }

    private String getNewUniqueInstanceIdGeneratedFromDataSourceName(RestHighLevelClient esClient, IndexToMigrate oldIndex, Map<String, Object> sourceValues) throws ElasticsearchRelatedException {
        String instanceId = (String)sourceValues.get("instanceId");
        if (this.convertedInstanceIDsCache.containsKey(instanceId)) {
            return this.convertedInstanceIDsCache.get(instanceId);
        }
        String dataSourceName = "dataSourceName".equals(sourceValues.get("name")) ? (String)sourceValues.get("value") : this.queryDataSourceNameFromOldIndexForInstanceId(esClient, oldIndex, instanceId);
        String dataSourceNameConvertedToInstanceId = BpcConfigurationIndexMigrationFromModelVersion10To11.convertToValidModuleInstanceId(dataSourceName);
        String uniqueInstanceId = this.getUniqueModuleInstanceId(dataSourceNameConvertedToInstanceId, 0);
        this.convertedInstanceIDsCache.put(instanceId, uniqueInstanceId);
        return uniqueInstanceId;
    }

    private String queryDataSourceNameFromOldIndexForInstanceId(RestHighLevelClient esClient, IndexToMigrate oldIndex, String instanceId) throws ElasticsearchRelatedException {
        String oldDataSourceNameSettingId = this.createSettingId("backendconnection", instanceId, "dataSourceName");
        try {
            SearchRequest request = new SearchRequest().indices(oldIndex.getName()).source(new SearchSourceBuilder().query(QueryBuilders.termQuery("id", oldDataSourceNameSettingId)));
            SearchResponse response = esClient.search(request, RequestOptions.DEFAULT);
            SearchHit[] hits = response.getHits().getHits();
            return hits == null || hits.length == 0 ? null : (String)hits[0].getSourceAsMap().get("value");
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    private String getUniqueModuleInstanceId(String dataSourceNameConvertedToInstanceId, int counter) {
        String uniqueInstanceId;
        String string = uniqueInstanceId = counter == 0 ? dataSourceNameConvertedToInstanceId : dataSourceNameConvertedToInstanceId + "-" + counter;
        if (this.convertedInstanceIDsCache.containsValue(uniqueInstanceId)) {
            return this.getUniqueModuleInstanceId(dataSourceNameConvertedToInstanceId, ++counter);
        }
        return uniqueInstanceId;
    }

    public static String convertToValidModuleInstanceId(String dataSourceName) {
        if (StringUtil.isNullOrEmpty(dataSourceName)) {
            return dataSourceName;
        }
        String result = dataSourceName;
        result = result.trim().toLowerCase();
        result = result.replaceAll("\\s+", "-");
        result = result.replaceAll("[^a-z0-9_\\-]", "_");
        result = result.replaceAll("(_)\\1+", "$1");
        result = result.replaceAll("(-)\\1+", "$1");
        result = result.replaceAll("[_\\-]+$", "");
        result = result.replaceAll("-_", "_");
        result = result.replaceAll("_-", "_");
        return result;
    }

    private String createSettingId(String moduleId, String instanceId, String settingName) {
        return moduleId + "_" + instanceId + "_" + settingName;
    }
}

