/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.migration;

import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.es.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.es.migration.IndexToMigrate;
import de.virtimo.bpc.util.DateUtil;
import de.virtimo.bpc.util.MapUtil;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion11To12
extends AllSearchHitsMigration {
    private static final Logger LOG = Logger.getLogger(BpcConfigurationIndexMigrationFromModelVersion11To12.class.getName());
    private static final boolean testRun = false;
    private final DateTimeFormatter expiresOnFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneOffset.UTC);

    public BpcConfigurationIndexMigrationFromModelVersion11To12(ElasticsearchService es) {
        super(es, 12);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient esClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Object apiKeysObject;
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if ("_core".equals(sourceValues.get("moduleId")) && "apiKeys".equals(sourceValues.get("name")) && (apiKeysObject = sourceValues.get("value")) instanceof Map) {
            try {
                Map originalApiKeys = (Map)apiKeysObject;
                Map updatedApiKeys = MapUtil.deepCopy(originalApiKeys);
                for (String apiKey : updatedApiKeys.keySet()) {
                    Map apiKeyDetails = (Map)updatedApiKeys.get(apiKey);
                    if (!apiKeyDetails.containsKey("issuedOn") || !apiKeyDetails.containsKey("expiresIn")) continue;
                    String issuedOn = (String)apiKeyDetails.get("issuedOn");
                    String expiresIn = (String)apiKeyDetails.get("expiresIn");
                    LocalDateTime issuedOnAsDate = ZonedDateTime.parse(issuedOn).toLocalDateTime();
                    LocalDateTime expiresOnAsDate = DateUtil.addRelativeValue(expiresIn, issuedOnAsDate);
                    String expiresOnFormatted = this.expiresOnFormatter.format(expiresOnAsDate);
                    apiKeyDetails.put("expiresOn", expiresOnFormatted);
                    apiKeyDetails.remove("expiresIn");
                }
                HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
                updatedSourceValues.put("value", updatedApiKeys);
                return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(updatedSourceValues, XContentType.JSON));
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to convert the API keys.", ex);
            }
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, XContentType.JSON));
    }
}

