/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.migration;

import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.es.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.es.migration.IndexToMigrate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion12To13
extends AllSearchHitsMigration {
    private static final Logger LOG = Logger.getLogger(BpcConfigurationIndexMigrationFromModelVersion12To13.class.getName());
    private static final boolean testRun = false;

    public BpcConfigurationIndexMigrationFromModelVersion12To13(ElasticsearchService es) {
        super(es, 13);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient esClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOG.warning("Skipping document with ID mismatch: " + hit.getId() + " != " + sourceValues.get("id"));
            return null;
        }
        if ("backendconnection".equals(sourceValues.get("moduleId")) && "deployment_target".equals(sourceValues.get("instanceType"))) {
            String newId = hit.getId();
            HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
            updatedSourceValues.put("instanceType", "deployment_system");
            if ("dt_local".equals(sourceValues.get("instanceId"))) {
                newId = this.createSettingId((String)sourceValues.get("moduleId"), "ds_local", (String)sourceValues.get("name"));
                updatedSourceValues.put("id", newId);
                updatedSourceValues.put("instanceId", "ds_local");
            }
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id(newId).source(updatedSourceValues, XContentType.JSON));
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, XContentType.JSON));
    }

    private String createSettingId(String moduleId, String instanceId, String settingName) {
        return moduleId + "_" + instanceId + "_" + settingName;
    }
}

