/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.migration;

import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.apikey.APIKey;
import de.virtimo.bpc.core.es.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.es.migration.IndexToMigrate;
import de.virtimo.bpc.util.MapUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion14To15
extends AllSearchHitsMigration {
    private static final Logger LOG = Logger.getLogger(BpcConfigurationIndexMigrationFromModelVersion14To15.class.getName());
    private static final boolean testRun = false;

    public BpcConfigurationIndexMigrationFromModelVersion14To15(ElasticsearchService es) {
        super(es, 15);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient esClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Object apiKeysObject;
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if ("_core".equals(sourceValues.get("moduleId")) && "apiKeys".equals(sourceValues.get("name")) && (apiKeysObject = sourceValues.get("value")) instanceof Map) {
            try {
                Map originalApiKeys = (Map)apiKeysObject;
                Map updatedApiKeys = MapUtil.deepCopy(originalApiKeys);
                for (String apiKey : updatedApiKeys.keySet()) {
                    Map apiKeyDetails = (Map)updatedApiKeys.get(apiKey);
                    apiKeyDetails.put("id", APIKey.generateId(apiKey));
                }
                HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
                updatedSourceValues.put("value", updatedApiKeys);
                return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(updatedSourceValues, XContentType.JSON));
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to convert the API keys.", ex);
            }
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, XContentType.JSON));
    }
}

