/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.migration;

import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.es.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.es.migration.IndexToMigrate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class BpcConfigurationIndexMigrationFromModelVersion15To16
extends AllSearchHitsMigration {
    private static final Logger LOG = Logger.getLogger(BpcConfigurationIndexMigrationFromModelVersion15To16.class.getName());
    private static final boolean testRun = false;

    public BpcConfigurationIndexMigrationFromModelVersion15To16(ElasticsearchService es) {
        super(es, 16);
    }

    @Override
    List<IndexRequest> migrateSearchHit(RestHighLevelClient esClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        String settingName = (String)sourceValues.get("name");
        String moduleId = (String)sourceValues.get("moduleId");
        if ("plugin_configuration".equals(settingName) && "_core".equals(moduleId)) {
            ArrayList pluginConfiguration = (ArrayList)sourceValues.get("value");
            try {
                Map<String, Object> moduleNavigatorSetting = this.getCoreSetting(esClient, oldIndex.getName(), "moduleNavigator");
                if (moduleNavigatorSetting != null) {
                    Boolean isModuleNavigatorActive = (Boolean)moduleNavigatorSetting.get("value");
                    if (isModuleNavigatorActive.equals(true)) {
                        pluginConfiguration.add((HashMap)this.getPluginConfig("bpcModuleNavigator"));
                    }
                    sourceValues.put("value", pluginConfiguration);
                }
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Failed to find setting 'moduleNavigator'.", e);
            }
            try {
                Map<String, Object> breadcrumbSetting = this.getCoreSetting(esClient, oldIndex.getName(), "gui_breadcrumb");
                if (breadcrumbSetting != null) {
                    Boolean isBreadcrumbActive = (Boolean)breadcrumbSetting.get("value");
                    if (isBreadcrumbActive.equals(true)) {
                        pluginConfiguration.add((HashMap)this.getPluginConfig("bpcBreadcrumb"));
                    }
                    sourceValues.put("value", pluginConfiguration);
                }
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Failed to find setting 'gui_breadcrumb'.", e);
            }
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, XContentType.JSON));
        }
        if ("_core".equals(moduleId) && ("gui_breadcrumb".equals(settingName) || "moduleNavigator".equals(settingName))) {
            return null;
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, XContentType.JSON));
    }

    private Map<String, Object> getCoreSetting(RestHighLevelClient esClient, String index, String settingName) throws IOException {
        SearchRequest request = new SearchRequest().indices(index).source(new SearchSourceBuilder().query(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", "_core")).must(QueryBuilders.termQuery("name", settingName))));
        SearchResponse response = esClient.search(request, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        if (hits.getHits().length > 0) {
            return hits.getAt(0).getSourceAsMap();
        }
        return null;
    }

    private Map<String, Object> getPluginConfig(String pluginName) {
        HashMap<String, Object> breadcrumbPluginConfig = new HashMap<String, Object>();
        breadcrumbPluginConfig.put("hook", "core_global_application_toolbar_left");
        breadcrumbPluginConfig.put("plugin", pluginName);
        breadcrumbPluginConfig.put("sourceModule", "_core");
        return breadcrumbPluginConfig;
    }
}

