/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.migration;

import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.es.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.es.migration.IndexToMigrate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.SearchHit;

class BpcConfigurationIndexMigrationFromModelVersion7To8
extends AllSearchHitsMigration {
    private static final Logger LOG = Logger.getLogger(BpcConfigurationIndexMigrationFromModelVersion7To8.class.getName());

    public BpcConfigurationIndexMigrationFromModelVersion7To8(ElasticsearchService es) {
        super(es, 8);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient esClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Object oldValueObject;
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if ("monitor".equals(sourceValues.get("moduleId")) && "row_style".equals(sourceValues.get("name")) && (oldValueObject = sourceValues.get("value")) instanceof HashMap) {
            HashMap oldValue = (HashMap)oldValueObject;
            ArrayList<HashMap> newValue = new ArrayList<HashMap>();
            if (!oldValue.isEmpty()) {
                newValue.add(oldValue);
            }
            HashMap<String, Object> newSetting = new HashMap<String, Object>();
            newSetting.put("id", sourceValues.get("id"));
            newSetting.put("moduleId", sourceValues.get("moduleId"));
            newSetting.put("instanceId", sourceValues.get("instanceId"));
            newSetting.put("instanceType", sourceValues.get("instanceType"));
            newSetting.put("name", "row_style");
            newSetting.put("type", "json");
            newSetting.put("value", newValue);
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id((String)sourceValues.get("id")).source(newSetting, XContentType.JSON));
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, XContentType.JSON));
    }
}

