/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.migration;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.es.migration.BpcConfigurationIndexMigrationFromModelVersion10To11;
import de.virtimo.bpc.core.es.migration.BpcConfigurationIndexMigrationFromModelVersion11To12;
import de.virtimo.bpc.core.es.migration.BpcConfigurationIndexMigrationFromModelVersion12To13;
import de.virtimo.bpc.core.es.migration.BpcConfigurationIndexMigrationFromModelVersion13To14;
import de.virtimo.bpc.core.es.migration.BpcConfigurationIndexMigrationFromModelVersion14To15;
import de.virtimo.bpc.core.es.migration.BpcConfigurationIndexMigrationFromModelVersion15To16;
import de.virtimo.bpc.core.es.migration.BpcConfigurationIndexMigrationFromModelVersion16To17;
import de.virtimo.bpc.core.es.migration.BpcConfigurationIndexMigrationFromModelVersion6To7;
import de.virtimo.bpc.core.es.migration.BpcConfigurationIndexMigrationFromModelVersion7To8;
import de.virtimo.bpc.core.es.migration.BpcConfigurationIndexMigrationFromModelVersion8To9;
import de.virtimo.bpc.core.es.migration.BpcConfigurationIndexMigrationFromModelVersion9To10;
import de.virtimo.bpc.core.es.migration.BpcNotificationIndexMigrationFromModelVersion1To2;
import de.virtimo.bpc.core.es.migration.IndexToMigrate;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.MapUtil;
import java.util.Set;
import java.util.logging.Logger;

public class BpcIndicesMigrator {
    private static final Logger LOG = Logger.getLogger(BpcIndicesMigrator.class.getName());
    private final ElasticsearchService es;

    public BpcIndicesMigrator(ElasticsearchService es) {
        this.es = es;
    }

    public String migrateBpcConfigurationIndex() throws IndexMigrationException, ElasticsearchRelatedException {
        LOG.info("migrateBpcConfigurationIndex");
        return this.migrateBpcConfigurationIndex("bpc-configuration");
    }

    public static int getLowestSupportedModelVersionOfBpcConfigurationIndex() {
        return 6;
    }

    public String migrateBpcConfigurationIndex(String aliasName) throws IndexMigrationException, ElasticsearchRelatedException {
        LOG.info("migrateBpcConfigurationIndex aliasName=" + aliasName);
        int toModelVersion = 17;
        if (!this.es.existsIndex(aliasName)) {
            LOG.info("Migration not necessary for [" + aliasName + "]. Does not exist.");
            return null;
        }
        String indexName = this.getTheOneAndOnlyIndexNameForAlias(aliasName);
        int currentModelVersion = this.es.getModelVersion(aliasName);
        if (currentModelVersion == toModelVersion) {
            LOG.info("Migration not necessary for [" + aliasName + "]. Uses already the required model version: " + toModelVersion);
            return indexName;
        }
        this.checkFutureModelVersion(aliasName, currentModelVersion, toModelVersion);
        LOG.warning("Migration necessary. The current [" + aliasName + "] model version is '" + currentModelVersion + "' and required is '" + toModelVersion + "'.");
        IndexToMigrate nextIndexToMigrate = new IndexToMigrate(aliasName, indexName);
        if (currentModelVersion == 6) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion6To7(this.es).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 7) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion7To8(this.es).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 8) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion8To9(this.es).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 9) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion9To10(this.es).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 10) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion10To11(this.es).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 11) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion11To12(this.es).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 12) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion12To13(this.es).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 13) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion13To14(this.es).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 14) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion14To15(this.es).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 15) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion15To16(this.es).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 16) {
            nextIndexToMigrate = new BpcConfigurationIndexMigrationFromModelVersion16To17(this.es).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 17) {
            // empty if block
        }
        return nextIndexToMigrate.getName();
    }

    public String migrateBpcNotificationIndex() throws IndexMigrationException, ElasticsearchRelatedException {
        LOG.info("migrateBpcNotificationIndex");
        return this.migrateBpcNotificationIndex("bpc-notification");
    }

    public String migrateBpcNotificationIndex(String aliasName) throws IndexMigrationException, ElasticsearchRelatedException {
        LOG.info("migrateBpcNotificationIndex aliasName=" + aliasName);
        int toModelVersion = 2;
        if (!this.es.existsIndex(aliasName)) {
            LOG.info("Migration not necessary for [" + aliasName + "]. Does not exist.");
            return null;
        }
        String indexName = this.getTheOneAndOnlyIndexNameForAlias(aliasName);
        int currentModelVersion = this.es.getModelVersion(aliasName);
        if (currentModelVersion == toModelVersion) {
            LOG.info("Migration not necessary for [" + aliasName + "]. Uses already the required model version: " + toModelVersion);
            return indexName;
        }
        this.checkFutureModelVersion(aliasName, currentModelVersion, toModelVersion);
        LOG.warning("Migration necessary. The current [" + aliasName + "] model version is '" + currentModelVersion + "' and required is '" + toModelVersion + "'.");
        IndexToMigrate nextIndexToMigrate = new IndexToMigrate(aliasName, indexName);
        if (currentModelVersion == 1) {
            nextIndexToMigrate = new BpcNotificationIndexMigrationFromModelVersion1To2(this.es).migrateIndex(nextIndexToMigrate);
            ++currentModelVersion;
        }
        if (currentModelVersion == 2) {
            // empty if block
        }
        return nextIndexToMigrate.getName();
    }

    private String getTheOneAndOnlyIndexNameForAlias(String aliasName) throws ElasticsearchRelatedException, IndexMigrationException {
        LOG.info("getIndexNameForAlias aliasName=" + aliasName);
        Set<String> indexNames = this.es.getIndexNamesWithAlias(aliasName);
        if (indexNames.size() != 1) {
            throw new IndexMigrationException((ErrorCode)CoreErrorCode.INDEX_MIGRATION_ALIAS_WITH_MULTIPLE_INDICES, "Index migration failed. Please have a look why the index alias '${aliasName}' is assigned to multiple indices: ${indexNames}", MapUtil.mapOf("aliasName", aliasName, "indexNames", "" + indexNames));
        }
        return indexNames.iterator().next();
    }

    private void checkFutureModelVersion(String aliasName, int currentModelVersion, int toModelVersion) throws IndexMigrationException {
        if (currentModelVersion > toModelVersion) {
            throw new IndexMigrationException((ErrorCode)CoreErrorCode.INDEX_MIGRATION_NOT_ALLOWED_VERSION, "You are trying to use a '${indexName}' index which is from a newer BPC version. This is not possible!", MapUtil.mapOf("indexName", aliasName, "indexModelVersion", currentModelVersion, "bpcModelVersion", toModelVersion));
        }
    }
}

