/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.migration;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.es.BpcIndexInfo;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.deployment.resource.DeploymentEndpoint;
import de.virtimo.bpc.core.es.ModuleConfigurationPersistenceHandler;
import de.virtimo.bpc.core.es.migration.BpcIndicesMigrator;
import de.virtimo.bpc.core.resource.response.SettingsBasedConfigImpl;
import de.virtimo.bpc.util.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;

public class GlobalConfigMigrator {
    private static final Logger LOG = Logger.getLogger(GlobalConfigMigrator.class.getName());
    private final ModuleManager moduleManager;
    private final ElasticsearchService es;

    public GlobalConfigMigrator(ModuleManager moduleManager, ElasticsearchService es) {
        this.moduleManager = moduleManager;
        this.es = es;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> migrate(Map<String, Object> modulesConfig) throws ServiceNotFoundException, IOException, ElasticsearchRelatedException, IndexMigrationException {
        LOG.info("migrate modulesConfig=...");
        int modelVersionOfModulesConfigToMigrate = DeploymentEndpoint.getModelVersion(modulesConfig);
        int modelVersionOfThisBpc = this.moduleManager.getModelVersionOfBpcConfigurationIndex();
        if (modelVersionOfModulesConfigToMigrate == -1) {
            return modulesConfig;
        }
        if (modelVersionOfModulesConfigToMigrate >= modelVersionOfThisBpc) {
            return modulesConfig;
        }
        if (modelVersionOfModulesConfigToMigrate < BpcIndicesMigrator.getLowestSupportedModelVersionOfBpcConfigurationIndex()) {
            return modulesConfig;
        }
        Map metadata = (Map)modulesConfig.get("metadata");
        if (metadata == null || !metadata.containsKey("fromIndex")) {
            return modulesConfig;
        }
        String tmpBpcConfigurationIndexAlias = "tmp_" + System.currentTimeMillis() + "_bpc-configuration";
        try {
            Map fromIndex = (Map)metadata.get("fromIndex");
            Map fromIndexSettings = (Map)fromIndex.get("settings");
            Map fromIndexMappings = (Map)fromIndex.get("mappings");
            fromIndexSettings.remove("creation_date");
            fromIndexSettings.remove("provided_name");
            fromIndexSettings.remove("uuid");
            fromIndexSettings.remove("version");
            String tmpBpcConfigurationIndexName = this.es.createIndex(tmpBpcConfigurationIndexAlias, fromIndexSettings, fromIndexMappings);
            List<Map<String, Object>> allModuleAndModuleInstanceSettings = this.getAllModuleAndModuleInstanceSettings(modulesConfig);
            this.writeSettingsToIndex(this.es, tmpBpcConfigurationIndexName, allModuleAndModuleInstanceSettings);
            this.es.refreshIndices(tmpBpcConfigurationIndexName);
            this.es.setModelVersion(tmpBpcConfigurationIndexName, modelVersionOfModulesConfigToMigrate);
            BpcIndicesMigrator indicesMigrator = new BpcIndicesMigrator(this.es);
            String migratedTmpBpcConfigurationIndexName = indicesMigrator.migrateBpcConfigurationIndex(tmpBpcConfigurationIndexAlias);
            BpcIndexInfo migratedTmpBpcConfigurationIndexInfo = this.es.getBpcIndexInfoUsingIndexName(migratedTmpBpcConfigurationIndexName);
            List<Setting> allSettings = ModuleConfigurationPersistenceHandler.readAllSettingsFromBpcConfigurationIndex(this.es, migratedTmpBpcConfigurationIndexName);
            SettingsBasedConfigImpl migratedConfig = new SettingsBasedConfigImpl(this.moduleManager, migratedTmpBpcConfigurationIndexInfo, modelVersionOfThisBpc, allSettings);
            Map<String, Object> migratedConfigAsMap = JsonUtil.getInstance().jsonStringAsMap(JsonUtil.getInstance().convertPojoToJsonString(migratedConfig));
            Map migratedConfigMetadata = (Map)migratedConfigAsMap.get("metadata");
            metadata.put("modelVersionPreMigration", metadata.get("modelVersion"));
            metadata.put("fromIndexPreMigration", metadata.get("fromIndex"));
            modulesConfig.put("modulesPreMigration", modulesConfig.get("modules"));
            metadata.put("modelVersion", migratedConfigMetadata.get("modelVersion"));
            metadata.put("fromIndex", migratedConfigMetadata.get("fromIndex"));
            modulesConfig.put("modules", migratedConfigAsMap.get("modules"));
            Map<String, Object> map = modulesConfig;
            return map;
        }
        finally {
            try {
                for (String tmpIndexName : this.es.getAllIndexNamesWithPrefix(tmpBpcConfigurationIndexAlias)) {
                    try {
                        this.es.deleteIndex(tmpIndexName);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.SEVERE, "Failed to delete the temporary tmp-bpc-configuration index: " + tmpIndexName, t);
                    }
                }
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Failed to delete the temporary tmp-bpc-configuration indies.", t);
            }
        }
    }

    private List<Map<String, Object>> getAllModuleAndModuleInstanceSettings(Map<String, Object> modulesConfig) {
        List modules;
        LOG.info("getAllModuleAndModuleInstanceSettings modulesConfig=...");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (modulesConfig != null && (modules = (List)modulesConfig.get("modules")) != null) {
            for (Map module : modules) {
                List instances;
                List moduleSettings = (List)module.get("settings");
                if (moduleSettings != null) {
                    for (Map moduleSetting : moduleSettings) {
                        result.add(moduleSetting);
                    }
                }
                if (!module.containsKey("instances") || (instances = (List)module.get("instances")) == null) continue;
                for (Map instance : instances) {
                    List moduleInstanceSettings = (List)instance.get("settings");
                    if (moduleInstanceSettings == null) continue;
                    for (Map moduleInstanceSetting : moduleInstanceSettings) {
                        result.add(moduleInstanceSetting);
                    }
                }
            }
        }
        return result;
    }

    private void writeSettingsToIndex(ElasticsearchService es, String indexName, List<Map<String, Object>> settings) throws ElasticsearchRelatedException {
        LOG.info("writeSettingsToIndex es=..., indexName=" + indexName + ", settings=...");
        try {
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            for (Map<String, Object> setting : settings) {
                String settingId = (String)setting.get("id");
                bulkRequest.add(new IndexRequest(indexName).id(settingId).source(setting, XContentType.JSON));
            }
            BulkResponse bulkResponse = es.getClient().bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                throw new ElasticsearchRelatedException((ErrorCode)BpcErrorCode.ELASTICSEARCH_FAILED, bulkResponse.buildFailureMessage(), null);
            }
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }
}

