/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.migration;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.es.migration.IndexToMigrate;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.MapUtil;
import java.util.logging.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.client.RestHighLevelClient;

public class Migration {
    private static final Logger LOG = Logger.getLogger(Migration.class.getName());
    private final ElasticsearchService es;

    public Migration(ElasticsearchService es) {
        this.es = es;
    }

    public ElasticsearchService getElasticsearchService() {
        return this.es;
    }

    protected void migrate(IndexToMigrate oldIndex, IndexToMigrate newIndex, int newModelVersion, Migrator migrator) throws IndexMigrationException {
        LOG.info("migrate oldIndex=" + oldIndex + ", newIndex=" + newIndex + ", newModelVersion=" + newModelVersion + ", migrator=" + migrator);
        try {
            if (this.es.getManagedIndicesHandler().isManagedIndex(newIndex.getAlias())) {
                this.es.getManagedIndicesHandler().createManagedIndex(newIndex.getAlias(), newIndex.getName(), false);
            } else {
                this.es.createIndex(newIndex.getName());
                this.es.copyIndexMapping(oldIndex.getName(), newIndex.getName());
            }
            migrator.migrate(this.es.getClient());
            this.es.setModelVersion(newIndex.getName(), newModelVersion);
            this.es.refreshIndices(newIndex.getName());
            this.es.flushIndices(newIndex.getName());
            this.es.moveAlias(oldIndex.getName(), newIndex.getName());
            this.es.closeIndex(oldIndex.getName());
        }
        catch (ResourceAlreadyExistsException ex) {
            throw new IndexMigrationException((ErrorCode)CoreErrorCode.INDEX_MIGRATION_INDEX_EXISTS_ALREADY, "Index migration failed. New index '${newIndexName}' for alias '${aliasName}' exists already. Should not be possible!", MapUtil.mapOf("aliasName", newIndex.getAlias(), "newIndexName", newIndex.getName()), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new IndexMigrationException((ErrorCode)CoreErrorCode.INDEX_MIGRATION_UNEXPECTED_ERROR, "Index migration failed: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    public static interface Migrator {
        public void migrate(RestHighLevelClient var1) throws ElasticsearchRelatedException;
    }
}

