/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.es.plugin;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.core.es.plugin.ElasticsearchBpcPluginManager;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class ElasticsearchBpcPluginCollector
extends Collector {
    private static final Logger LOG = Logger.getLogger(ElasticsearchBpcPluginCollector.class.getName());
    private final BpcServicesTracker<ElasticsearchBpcPluginManager> elasticsearchBpcPluginManagerTracker;

    public ElasticsearchBpcPluginCollector(BundleContext bundleContext) {
        this.elasticsearchBpcPluginManagerTracker = new BpcServicesTracker<ElasticsearchBpcPluginManager>(bundleContext, ElasticsearchBpcPluginManager.class);
    }

    public void unregister() {
        LOG.info("unregister");
        CollectorRegistry.defaultRegistry.unregister((Collector)this);
        BpcServicesTracker.stopAll((Object)this);
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            ElasticsearchBpcPluginManager.WebsocketState websocketState = this.elasticsearchBpcPluginManagerTracker.getService().getWebsocketState();
            int metricWebsocketState = 0;
            if (websocketState == ElasticsearchBpcPluginManager.WebsocketState.DISCONNECTED) {
                metricWebsocketState = 0;
            } else if (websocketState == ElasticsearchBpcPluginManager.WebsocketState.CONNECTED) {
                metricWebsocketState = 1;
            } else if (websocketState == ElasticsearchBpcPluginManager.WebsocketState.ERROR) {
                metricWebsocketState = 2;
            }
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_es_bpc_plugin_status_websocket", "Status of the websocket connection (0=disconnected, 1=connected, 2=error)", (double)metricWebsocketState));
        }
        catch (Throwable websocketState) {
            // empty catch block
        }
        try {
            ElasticsearchBpcPluginManager.PluginState pluginState = this.elasticsearchBpcPluginManagerTracker.getService().getPluginState();
            int metricPluginState = 0;
            if (pluginState == ElasticsearchBpcPluginManager.PluginState.UNKNOWN) {
                metricPluginState = 0;
            } else if (pluginState == ElasticsearchBpcPluginManager.PluginState.ACCESSIBLE) {
                metricPluginState = 1;
            } else if (pluginState == ElasticsearchBpcPluginManager.PluginState.NOT_ACCESSIBLE) {
                metricPluginState = 2;
            } else if (pluginState == ElasticsearchBpcPluginManager.PluginState.ERRORS) {
                metricPluginState = 3;
            }
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_es_bpc_plugin_status_plugin", "Status of the plugin (0=unknown, 1=accessible, 2=not accessible, 3=errors)", (double)metricPluginState));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mfs;
    }
}

